/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.CommonToken;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.internal.ResourceManagerFactory;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.TypeDescription;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.RutaModule;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.annotation.IAnnotationExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.bool.SimpleBooleanListExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.number.SimpleNumberListExpression;
import org.apache.uima.ruta.expression.resource.LiteralWordListExpression;
import org.apache.uima.ruta.expression.resource.LiteralWordTableExpression;
import org.apache.uima.ruta.expression.resource.StringWordListExpression;
import org.apache.uima.ruta.expression.resource.StringWordTableExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.resource.WordTableExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.string.SimpleStringListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.expression.type.SimpleTypeExpression;
import org.apache.uima.ruta.expression.type.SimpleTypeListExpression;
import org.apache.uima.ruta.resource.CSVTable;
import org.apache.uima.ruta.resource.MultiTreeWordList;
import org.apache.uima.ruta.resource.RutaResourceLoader;
import org.apache.uima.ruta.resource.RutaTable;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.resource.TreeWordList;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;
import org.apache.uima.util.InvalidXMLException;
import org.springframework.core.io.Resource;

public class RutaEnvironment {
    private static final String DOCUMENT = "Document";
    private final Object annotationTypeDummy = new Object();
    private Map<String, Type> types;
    private Map<String, RutaWordList> wordLists;
    private Map<String, RutaTable> tables;
    private RutaBlock owner;
    private Map<String, String> namespaces;
    private Map<String, Set<String>> ambiguousTypeAlias;
    private Set<String> typesystems;
    private Set<String> scripts;
    private Map<String, List<Alias>> typeImports;
    private Map<String, List<String>> packageImports;
    private Set<String> declaredAnnotationTypes;
    private Map<String, Object> variableValues;
    private Map<String, Object> tempVariableValues;
    private Map<String, Class<?>> variableTypes;
    private Map<String, Class<?>> availableTypes;
    private Map<String, Class<?>> variableGenericTypes;
    private Map<String, Class<?>> availableListTypes;
    private Map<String, Triple<Map<String, String>, List<AbstractRutaCondition>, Set<String>>> macroConditions;
    private Map<String, Triple<Map<String, String>, List<AbstractRutaAction>, Set<String>>> macroActions;
    private String[] resourcePaths = null;
    private CAS cas;
    private Map<String, Object> initializedVariables;
    private ResourceManager resourceManager;
    private Map<String, String> variableAliases;
    private RutaVerbalizer verbalizer = new RutaVerbalizer();

    public RutaEnvironment(RutaBlock owner) {
        this.owner = owner;
        this.types = new HashMap<String, Type>();
        this.namespaces = new HashMap<String, String>();
        this.ambiguousTypeAlias = new HashMap<String, Set<String>>();
        this.typesystems = new HashSet<String>();
        this.scripts = new HashSet<String>();
        this.typeImports = new HashMap<String, List<Alias>>();
        this.packageImports = new HashMap<String, List<String>>();
        this.declaredAnnotationTypes = new HashSet<String>();
        this.wordLists = new HashMap<String, RutaWordList>();
        this.tables = new HashMap<String, RutaTable>();
        this.variableValues = new HashMap<String, Object>();
        this.tempVariableValues = new HashMap<String, Object>();
        this.variableTypes = new HashMap();
        this.variableGenericTypes = new HashMap();
        this.macroConditions = new HashMap<String, Triple<Map<String, String>, List<AbstractRutaCondition>, Set<String>>>();
        this.macroActions = new HashMap<String, Triple<Map<String, String>, List<AbstractRutaAction>, Set<String>>>();
        this.availableTypes = new HashMap();
        this.availableTypes.put("ANNOTATION", AnnotationFS.class);
        this.availableTypes.put("INT", Integer.class);
        this.availableTypes.put("STRING", String.class);
        this.availableTypes.put("DOUBLE", Double.class);
        this.availableTypes.put("FLOAT", Float.class);
        this.availableTypes.put("BOOLEAN", Boolean.class);
        this.availableTypes.put("TYPE", Type.class);
        this.availableTypes.put("CONDITION", AbstractRutaCondition.class);
        this.availableTypes.put("ACTION", AbstractRutaAction.class);
        this.availableTypes.put("WORDLIST", RutaWordList.class);
        this.availableTypes.put("WORDTABLE", RutaTable.class);
        this.availableTypes.put("ANNOTATIONLIST", List.class);
        this.availableTypes.put("BOOLEANLIST", List.class);
        this.availableTypes.put("INTLIST", List.class);
        this.availableTypes.put("DOUBLELIST", List.class);
        this.availableTypes.put("FLOATLIST", List.class);
        this.availableTypes.put("STRINGLIST", List.class);
        this.availableTypes.put("TYPELIST", List.class);
        this.availableListTypes = new HashMap();
        this.availableListTypes.put("ANNOTATIONLIST", AnnotationFS.class);
        this.availableListTypes.put("BOOLEANLIST", Boolean.class);
        this.availableListTypes.put("INTLIST", Integer.class);
        this.availableListTypes.put("DOUBLELIST", Double.class);
        this.availableListTypes.put("FLOATLIST", Float.class);
        this.availableListTypes.put("STRINGLIST", String.class);
        this.availableListTypes.put("TYPELIST", Type.class);
        this.resourcePaths = this.getResourcePaths();
        this.initializedVariables = new HashMap<String, Object>();
        this.variableAliases = new HashMap<String, String>();
        this.addTypeSystem("org.apache.uima.ruta.engine.BasicTypeSystem");
    }

    public void initializeTypes(CAS cas, boolean strictImport) {
        this.cas = cas;
        try {
            if (strictImport) {
                this.importDeclaredTypes(cas.getTypeSystem());
                this.importDeclaredTypesystems(cas.getTypeSystem());
                this.importTypeAliases(cas.getTypeSystem());
                this.importPackageAliases(cas.getTypeSystem());
                this.importDeclaredScripts(cas.getTypeSystem());
            } else {
                this.importAllTypes(cas.getTypeSystem());
                this.importTypeAliases(cas.getTypeSystem());
                this.importPackageAliases(cas.getTypeSystem());
            }
            this.ambiguousTypeAlias.remove(DOCUMENT);
            this.namespaces.remove(DOCUMENT);
            Type documentType = cas.getTypeSystem().getType("uima.tcas.DocumentAnnotation");
            this.addType(DOCUMENT, documentType);
            this.addType(documentType.getShortName(), documentType);
            Type annotationType = cas.getJCas().getCasType(Annotation.type);
            this.addType("Annotation", annotationType);
        }
        catch (CASException e) {
            UIMAFramework.getLogger(this.getClass()).log(org.apache.uima.util.Level.SEVERE, "Cannot initialize types.", e);
        }
        catch (InvalidXMLException e) {
            UIMAFramework.getLogger(this.getClass()).log(org.apache.uima.util.Level.SEVERE, "Cannot initialize types.", e);
        }
    }

    private void importAllTypes(TypeSystem ts) throws CASException {
        Type topType = ts.getTopType();
        if (topType != null) {
            List<Type> list = ts.getProperlySubsumedTypes(topType);
            for (Type type : list) {
                this.addType(type);
            }
        }
    }

    private void importDeclaredTypes(TypeSystem casTS) throws InvalidXMLException {
        for (String name : this.declaredAnnotationTypes) {
            Type type = casTS.getType(name);
            if (type != null) {
                this.addType(type);
                continue;
            }
            throw new RuntimeException("Type '" + name + "' not found");
        }
    }

    private void importDeclaredTypesystems(TypeSystem casTS) throws InvalidXMLException {
        String[] descriptors = this.typesystems.toArray(new String[this.typesystems.size()]);
        TypeSystemDescription ts = TypeSystemDescriptionFactory.createTypeSystemDescription(descriptors);
        ts.resolveImports(this.getResourceManager());
        for (TypeDescription td : ts.getTypes()) {
            Type type = casTS.getType(td.getName());
            if (type == null) {
                throw new RuntimeException("Type '" + td.getName() + "' not found");
            }
            this.addType(type);
        }
    }

    private void importDeclaredScripts(TypeSystem casTS) throws InvalidXMLException {
        RutaModule script = this.owner.getScript();
        for (String eachImportedScript : this.scripts) {
            RutaModule importedModule = script.getScript(eachImportedScript);
            RutaEnvironment importedEnvironment = importedModule.getRootBlock().getEnvironment();
            Map<String, Type> importedTypeMap = importedEnvironment.getTypes();
            Map<String, String> importedNamespaces = importedEnvironment.getNamespaces();
            Set<Map.Entry<String, String>> entrySet = importedNamespaces.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                if (this.ownsType(entry.getValue()) || StringUtils.equals(entry.getKey(), DOCUMENT)) continue;
                Type type = importedTypeMap.get(entry.getValue());
                this.addType(entry.getKey(), type);
            }
        }
    }

    private void importTypeAliases(TypeSystem casTS) {
        for (List<Alias> aliases : this.typeImports.values()) {
            for (Alias alias : aliases) {
                Type type = casTS.getType(alias.longName);
                if (type == null) {
                    throw new RuntimeException("Type '" + alias.longName + "' not found");
                }
                this.addType(alias.shortName, casTS.getType(alias.longName));
            }
        }
    }

    private void importPackageAliases(TypeSystem casTS) {
        Iterator<Type> iter = casTS.getTypeIterator();
        while (iter.hasNext()) {
            Type type = iter.next();
            String name = type.getName();
            String pkg = name.substring(0, Math.max(name.lastIndexOf(46), 0));
            List<String> aliases = this.packageImports.get(pkg);
            if (aliases == null) continue;
            for (String alias : aliases) {
                if (alias.isEmpty()) {
                    this.addType(type);
                    continue;
                }
                this.addType(alias + "." + type.getShortName(), type);
            }
        }
    }

    public String[] getResourcePaths() {
        RutaBlock parent;
        if (this.resourcePaths == null && (parent = this.owner.getParent()) != null) {
            return parent.getEnvironment().getResourcePaths();
        }
        return this.resourcePaths;
    }

    public void setResourcePaths(String[] resourcePaths) {
        this.resourcePaths = resourcePaths;
    }

    public boolean ownsType(String match) {
        match = this.expand(match);
        return this.types.keySet().contains(match);
    }

    private String expand(String string) {
        String complete = this.namespaces.get(string);
        if (complete == null) {
            if (!string.contains(".")) {
                complete = this.namespaces.get(string);
                if (complete == null) {
                    complete = string;
                }
            } else {
                complete = string;
            }
        }
        return complete;
    }

    public Type getType(String match) {
        RutaBlock parent;
        Set<String> ambiguousTargets = this.ambiguousTypeAlias.get(match);
        if (ambiguousTargets != null) {
            StringBuilder message = new StringBuilder(match);
            message.append(" is ambiguous, use one of the following instead : ");
            for (String target : ambiguousTargets) {
                message.append(target).append(' ');
            }
            throw new IllegalArgumentException(message.toString());
        }
        String expanded = this.expand(match);
        Type type = this.types.get(expanded);
        if (type == null && (parent = this.owner.getParent()) != null) {
            type = parent.getEnvironment().getType(match);
        }
        return type;
    }

    public void addType(String string, Type type) {
        this.importType(type.getName(), string);
        this.types.put(type.getName(), type);
    }

    public void addType(Type type) {
        this.addType(type.getShortName(), type);
    }

    public void declareType(String name) {
        this.declaredAnnotationTypes.add(name);
    }

    public void addTypeSystem(String descriptor) {
        this.typesystems.add(descriptor);
    }

    public void addScript(String script) {
        this.scripts.add(script);
    }

    private void importType(String longName, String shortName) {
        Set<String> targets = this.ambiguousTypeAlias.get(shortName);
        if (targets != null) {
            targets.add(longName);
        } else {
            String existing = this.namespaces.put(shortName, longName);
            if (existing != null && !existing.equals(longName)) {
                targets = new HashSet<String>(2);
                targets.add(existing);
                targets.add(longName);
                this.ambiguousTypeAlias.put(shortName, targets);
                this.namespaces.remove(shortName);
            }
        }
    }

    public void importTypeFromTypeSystem(String typesystem, String longName, String shortName) {
        String key = typesystem != null ? typesystem : "";
        List<Alias> aliases = this.typeImports.get(key);
        if (aliases == null) {
            aliases = new ArrayList<Alias>();
            this.typeImports.put(key, aliases);
        }
        aliases.add(new Alias(longName, shortName));
    }

    public void importTypeFromTypeSystem(String typesystem, String longName) {
        this.importTypeFromTypeSystem(typesystem, longName, longName.substring(longName.lastIndexOf(46) + 1));
    }

    public void importPackageFromTypeSystem(String typesystem, String packageName, String alias) {
        TypeSystemDescription tsd = TypeSystemDescriptionFactory.createTypeSystemDescription(typesystem);
        try {
            tsd.resolveImports(this.getResourceManager());
        }
        catch (InvalidXMLException e) {
            throw new RuntimeException("Cannot resolve imports in " + typesystem, e);
        }
        for (TypeDescription td : tsd.getTypes()) {
            String qname = td.getName();
            if (packageName != null && (!qname.startsWith(packageName) || qname.indexOf(46, packageName.length() + 1) != -1)) continue;
            if (alias != null) {
                String shortName = alias + "." + qname.substring(qname.lastIndexOf(46) + 1);
                this.importTypeFromTypeSystem(typesystem, qname, shortName);
                continue;
            }
            this.importTypeFromTypeSystem(typesystem, qname);
        }
    }

    public void importAllPackagesFromTypeSystem(String typesystem, String alias) {
        this.importPackageFromTypeSystem(typesystem, null, alias);
    }

    public void importPackage(String packageName, String alias) {
        List<String> aliases = this.packageImports.get(packageName);
        if (aliases == null) {
            aliases = new ArrayList<String>(1);
            this.packageImports.put(packageName, aliases);
        }
        aliases.add(alias == null ? "" : alias);
    }

    public RutaWordList getWordList(String list) {
        block14: {
            if (list == null) {
                return null;
            }
            RutaWordList result = this.wordLists.get(list);
            UimaContext context = this.owner.getContext();
            Boolean dictRemoveWS = false;
            if (context != null && (dictRemoveWS = (Boolean)context.getConfigParameterValue("dictRemoveWS")) == null) {
                dictRemoveWS = false;
            }
            if (result == null) {
                if (list.endsWith("txt") || list.endsWith("twl") || list.endsWith("mtwl")) {
                    RutaResourceLoader resourceLoader = new RutaResourceLoader(this.getResourcePaths(), this.getResourceManager().getExtensionClassLoader());
                    Resource resource = resourceLoader.getResource(list);
                    if (resource.exists()) {
                        try {
                            if (list.endsWith("mtwl")) {
                                this.wordLists.put(list, new MultiTreeWordList(resource));
                                break block14;
                            }
                            this.wordLists.put(list, new TreeWordList(resource, (boolean)dictRemoveWS));
                        }
                        catch (IOException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error reading word list" + list, e);
                        }
                    } else {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't find " + list + "!");
                    }
                } else {
                    try {
                        RutaWordList rutaList = (RutaWordList)context.getResourceObject(list);
                        if (rutaList != null) {
                            this.wordLists.put(list, rutaList);
                        } else {
                            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't find external resource list" + list);
                        }
                    }
                    catch (ResourceAccessException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't find external resource list" + list, e);
                    }
                }
            }
        }
        return this.wordLists.get(list);
    }

    public RutaTable getWordTable(String table) {
        UimaContext context = this.owner.getContext();
        RutaTable result = this.tables.get(table);
        if (result == null) {
            if (table.endsWith("csv") || table.endsWith("txt") || table.endsWith("tsv")) {
                RutaResourceLoader resourceLoader = new RutaResourceLoader(this.getResourcePaths(), this.getResourceManager().getExtensionClassLoader());
                Resource resource = resourceLoader.getResource(table);
                if (resource.exists()) {
                    try {
                        this.tables.put(table, new CSVTable(resource, this.getCsvSeparator(context)));
                    }
                    catch (IOException e) {
                        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Error reading csv table " + table, e);
                    }
                } else {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't find " + table + "!");
                }
            } else {
                try {
                    RutaTable rutaTable = (RutaTable)context.getResourceObject(table);
                    this.tables.put(table, rutaTable);
                }
                catch (ResourceAccessException e) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Can't find external resource table" + table, e);
                }
            }
        }
        return this.tables.get(table);
    }

    private String getCsvSeparator(UimaContext context) {
        String cvsSeparator;
        if (context != null && (cvsSeparator = (String)context.getConfigParameterValue("csvSeparator")) != null) {
            return cvsSeparator;
        }
        return ";";
    }

    private void addVariable(String name, Class<?> type, Class<?> generic) {
        this.variableTypes.put(name, type);
        if (generic != null) {
            this.variableGenericTypes.put(name, generic);
        }
        this.variableValues.put(name, this.getInitialValue(name, type));
    }

    private Object getInitialValue(String name, Class<?> type) {
        Object init = this.initializedVariables.get(name);
        if (init != null) {
            if (init instanceof List) {
                ArrayList list = new ArrayList();
                list.addAll((Collection)init);
                return list;
            }
            return init;
        }
        if (Integer.class.equals(type)) {
            return 0;
        }
        if (Double.class.equals(type)) {
            return 0.0;
        }
        if (Float.class.equals(type)) {
            return Float.valueOf(0.0f);
        }
        if (String.class.equals(type)) {
            return null;
        }
        if (Boolean.class.equals(type)) {
            return false;
        }
        if (Type.class.equals(type)) {
            return null;
        }
        if (List.class.equals(type)) {
            return new ArrayList();
        }
        return null;
    }

    public void addVariable(String name, String type) {
        this.addVariable(name, this.availableTypes.get(type), this.availableListTypes.get(type));
    }

    public void removeVariable(String name) {
        this.variableTypes.remove(name);
        this.variableGenericTypes.remove(name);
        this.variableValues.remove(name);
        this.tempVariableValues.remove(name);
    }

    public boolean ownsVariable(String name) {
        return this.variableTypes.containsKey(name);
    }

    public boolean ownsVariableOfType(String name, String type) {
        if (this.variableAliases.containsKey(name)) {
            name = this.variableAliases.get(name);
        }
        Class<?> varclass = this.variableTypes.get(name);
        Class<?> aclass = this.availableTypes.get(type);
        boolean list = true;
        if (aclass.equals(List.class)) {
            Class<?> vt = this.variableGenericTypes.get(name);
            Class<?> at = this.availableListTypes.get(type);
            list = vt != null && vt.equals(at);
        }
        return list && varclass != null && varclass.equals(aclass);
    }

    public boolean isVariable(String name) {
        if (this.variableAliases.containsKey(name)) {
            name = this.variableAliases.get(name);
        }
        if (this.ownsVariable(name)) {
            return true;
        }
        if (this.owner != null && this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().isVariable(name);
        }
        return false;
    }

    public boolean isVariableOfType(String name, String type) {
        return this.ownsVariableOfType(name, type) || this.owner.getParent() != null && this.owner.getParent().getEnvironment().isVariableOfType(name, type);
    }

    public Class<?> getVariableType(String name) {
        Class<?> result;
        if (this.variableAliases.containsKey(name)) {
            name = this.variableAliases.get(name);
        }
        if ((result = this.variableTypes.get(name)) != null) {
            return result;
        }
        if (this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().getVariableType(name);
        }
        return null;
    }

    public Class<?> getVariableGenericType(String name) {
        Class<?> result = this.variableGenericTypes.get(name);
        if (result != null) {
            return result;
        }
        if (this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().getVariableGenericType(name);
        }
        return null;
    }

    public <T> T getVariableValue(String name, Class<T> type, RutaStream stream) {
        String stringValue;
        if (this.variableAliases.containsKey(name)) {
            name = this.variableAliases.get(name);
        }
        Object result = null;
        boolean containsKey = this.variableValues.containsKey(name);
        result = this.tempVariableValues.get(name);
        if (result == null) {
            result = this.variableValues.get(name);
        }
        if (result instanceof String && type.equals(Type.class) && (result = this.types.get(stringValue = (String)result)) == null) {
            result = this.getType(stringValue);
        }
        if (containsKey && result == null) {
            Object initialValue = this.getInitialValue(name, type);
            if (initialValue instanceof Type) {
                return type.cast(initialValue);
            }
            if (initialValue != null) {
                throw new IllegalArgumentException("Variable " + name + " of type " + type + " is not correctly initialized! It is not a Type, but " + initialValue);
            }
        }
        if (result == this.annotationTypeDummy) {
            return type.cast(this.cas.getAnnotationType());
        }
        if (result != null) {
            MatchContext context = new MatchContext(this.owner);
            if (RutaWordList.class.isAssignableFrom(type) && result instanceof WordListExpression) {
                WordListExpression wle = (WordListExpression)result;
                RutaWordList list = wle.getList(context, stream);
                return type.cast(list);
            }
            if (RutaTable.class.isAssignableFrom(type) && result instanceof WordTableExpression) {
                WordTableExpression wte = (WordTableExpression)result;
                RutaTable table = wte.getTable(context, stream);
                return type.cast(table);
            }
            return type.cast(result);
        }
        if (this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().getVariableValue(name, type, stream);
        }
        return null;
    }

    public Object getVariableValue(String name, RutaStream stream) {
        return this.getVariableValue(name, Object.class, stream);
    }

    public Object getLiteralValue(String var, Object value) {
        if (this.ownsVariable(var)) {
            String typeName;
            MatchContext context = new MatchContext(this.owner);
            Class<?> clazz = this.variableTypes.get(var);
            if (value instanceof INumberExpression) {
                INumberExpression ne = (INumberExpression)value;
                if (clazz.equals(Integer.class)) {
                    return ne.getIntegerValue(context, null);
                }
                if (clazz.equals(Double.class)) {
                    return ne.getDoubleValue(context, null);
                }
                if (clazz.equals(Float.class)) {
                    return Float.valueOf(ne.getFloatValue(context, null));
                }
                if (clazz.equals(String.class)) {
                    return ne.getStringValue(context, null);
                }
            } else {
                if (clazz.equals(String.class) && value instanceof IStringExpression) {
                    IStringExpression se = (IStringExpression)value;
                    return se.getStringValue(context, null);
                }
                if (clazz.equals(Boolean.class) && value instanceof IBooleanExpression) {
                    IBooleanExpression be = (IBooleanExpression)value;
                    return be.getBooleanValue(context, null);
                }
            }
            if (clazz.equals(RutaWordList.class) && value instanceof LiteralWordListExpression) {
                return value;
            }
            if (clazz.equals(RutaWordList.class) && value instanceof StringWordListExpression) {
                return value;
            }
            if (clazz.equals(RutaWordList.class) && value instanceof String) {
                return value;
            }
            if (clazz.equals(RutaTable.class) && value instanceof LiteralWordTableExpression) {
                return value;
            }
            if (clazz.equals(RutaTable.class) && value instanceof StringWordTableExpression) {
                return value;
            }
            if (clazz.equals(RutaTable.class) && value instanceof String) {
                return value;
            }
            if (clazz.equals(List.class) && value instanceof ListExpression) {
                List list = this.getList((ListExpression)value);
                return list;
            }
            if (clazz.equals(Type.class) && value instanceof CommonToken) {
                typeName = ((CommonToken)value).getText();
                return typeName;
            }
            if (clazz.equals(Type.class) && value instanceof SimpleTypeExpression) {
                typeName = ((SimpleTypeExpression)value).getTypeString();
                return typeName;
            }
            return null;
        }
        return this.owner.getParent().getEnvironment().getLiteralValue(var, value);
    }

    public void setInitialVariableValue(String var, Object value) {
        if (this.ownsVariable(var)) {
            if (value instanceof List) {
                ArrayList initValue = new ArrayList();
                initValue.addAll((Collection)value);
                this.initializedVariables.put(var, initValue);
            } else {
                this.initializedVariables.put(var, value);
            }
            this.setVariableValue(var, value);
        } else if (this.owner.getParent() != null) {
            this.owner.getParent().getEnvironment().setInitialVariableValue(var, value);
        }
    }

    public void setVariableValue(String name, Object value) {
        if (this.variableAliases.containsKey(name)) {
            name = this.variableAliases.get(name);
        }
        if (this.ownsVariable(name)) {
            Class<?> clazz = this.variableTypes.get(name);
            if (value == null) {
                value = this.getInitialValue(name, clazz);
            }
            this.variableValues.put(name, value);
        } else if (this.owner.getParent() != null) {
            this.owner.getParent().getEnvironment().setVariableValue(name, value);
        }
    }

    public void setTempVariableValue(String name, Object value) {
        if (this.variableAliases.containsKey(name)) {
            name = this.variableAliases.get(name);
        }
        this.tempVariableValues.put(name, value);
    }

    private List getList(ListExpression value) {
        if (value instanceof SimpleBooleanListExpression) {
            SimpleBooleanListExpression e = (SimpleBooleanListExpression)value;
            return e.getList();
        }
        if (value instanceof SimpleNumberListExpression) {
            SimpleNumberListExpression e = (SimpleNumberListExpression)value;
            return e.getList();
        }
        if (value instanceof SimpleStringListExpression) {
            SimpleStringListExpression e = (SimpleStringListExpression)value;
            return e.getList();
        }
        if (value instanceof SimpleTypeListExpression) {
            SimpleTypeListExpression e = (SimpleTypeListExpression)value;
            return e.getList();
        }
        return null;
    }

    public void reset(CAS cas) {
        this.cas = cas;
        Set<Map.Entry<String, Object>> entrySet = this.variableValues.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Class<?> variableType = this.variableTypes.get(key);
            Object initialValue = this.getInitialValue(key, this.variableTypes.get(key));
            if ((variableType.equals(RutaTable.class) || variableType.equals(RutaWordList.class)) && initialValue == null) continue;
            entry.setValue(initialValue);
        }
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager != null) {
            return this.resourceManager;
        }
        RutaBlock parent = this.owner.getParent();
        if (parent != null) {
            return parent.getEnvironment().getResourceManager();
        }
        try {
            this.resourceManager = ResourceManagerFactory.newResourceManager();
            return this.resourceManager;
        }
        catch (ResourceInitializationException e) {
            UIMAFramework.getLogger(this.getClass()).log(org.apache.uima.util.Level.SEVERE, "Failed to initialize fallback ResourceManager.", e);
            return UIMAFramework.newDefaultResourceManager();
        }
    }

    public void setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public void addMacroAction(String name, Map<String, String> def, Set<String> vars, List<AbstractRutaAction> actions2) {
        this.macroActions.put(name, new ImmutableTriple<Map<String, String>, List<AbstractRutaAction>, Set<String>>(def, actions2, vars));
    }

    public void addMacroCondition(String name, Map<String, String> def, Set<String> vars, List<AbstractRutaCondition> conditions) {
        this.macroConditions.put(name, new ImmutableTriple<Map<String, String>, List<AbstractRutaCondition>, Set<String>>(def, conditions, vars));
    }

    public boolean isMacroAction(String name) {
        boolean isDefined = this.macroActions.keySet().contains(name);
        if (isDefined) {
            return true;
        }
        if (this.owner != null && this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().isMacroAction(name);
        }
        return false;
    }

    public boolean isMacroCondition(String name) {
        boolean isDefined = this.macroConditions.keySet().contains(name);
        if (isDefined) {
            return true;
        }
        if (this.owner != null && this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().isMacroCondition(name);
        }
        return false;
    }

    public Triple<Map<String, String>, List<AbstractRutaAction>, Set<String>> getMacroAction(String name) {
        Triple<Map<String, String>, List<AbstractRutaAction>, Set<String>> definition = this.macroActions.get(name);
        if (definition != null) {
            return definition;
        }
        if (this.owner != null && this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().getMacroAction(name);
        }
        return null;
    }

    public Triple<Map<String, String>, List<AbstractRutaCondition>, Set<String>> getMacroCondition(String name) {
        Triple<Map<String, String>, List<AbstractRutaCondition>, Set<String>> definition = this.macroConditions.get(name);
        if (definition != null) {
            return definition;
        }
        if (this.owner != null && this.owner.getParent() != null) {
            return this.owner.getParent().getEnvironment().getMacroCondition(name);
        }
        return null;
    }

    public void addAliasVariable(String name, String var) {
        this.variableAliases.put(name, var);
    }

    public void removeAliasVariable(String name) {
        this.variableAliases.remove(name);
    }

    public String getVariableNameOfExpression(IRutaExpression expression) {
        String verbalize = this.verbalizer.verbalize(expression);
        return verbalize;
    }

    public Map<String, Type> getTypes() {
        return this.types;
    }

    public Set<String> getDeclaredAnnotationTypes() {
        return this.declaredAnnotationTypes;
    }

    public Set<String> getTypesystems() {
        return this.typesystems;
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public void addMatchToVariable(RuleMatch ruleMatch, RuleElement element, MatchContext context, RutaStream stream) {
        String var = element.getLabel();
        if (StringUtils.isBlank(var)) {
            return;
        }
        List<AnnotationFS> annotations = ruleMatch.getMatchedAnnotationsOfElement(element);
        this.addAnnotationsToVariable(annotations, var, context);
    }

    public void removeVariableValue(String var, MatchContext context) {
        if (StringUtils.isBlank(var)) {
            return;
        }
        this.setTempVariableValue(var, null);
    }

    public void addAnnotationsToVariable(List<AnnotationFS> annotations, String var, MatchContext context) {
        if (StringUtils.isBlank(var)) {
            return;
        }
        Class<?> variableType = this.getVariableType(var);
        if (List.class.equals(variableType) && AnnotationFS.class.equals(this.getVariableGenericType(var))) {
            this.setTempVariableValue(var, annotations);
        } else if (AnnotationFS.class.equals(variableType) && context.getDirection()) {
            AnnotationFS annotation = null;
            if (annotations != null) {
                annotation = context.getDirection() ? annotations.get(annotations.size() - 1) : annotations.get(0);
            }
            this.setTempVariableValue(var, annotation);
        }
    }

    public void acceptTempVariableValues(Collection<String> localVariables) {
        for (String variableName : localVariables) {
            if (!this.tempVariableValues.containsKey(variableName)) continue;
            Object value = this.tempVariableValues.get(variableName);
            this.setVariableValue(variableName, value);
        }
        this.clearTempVariables(localVariables);
    }

    public void clearTempVariables(Collection<String> localVariables) {
        for (String variableName : localVariables) {
            this.tempVariableValues.remove(variableName);
        }
    }

    public void ensureMaterializedInitialValues(MatchContext matchContext, RutaStream stream) {
        for (Map.Entry<String, Object> entry : new ArrayList<Map.Entry<String, Object>>(this.initializedVariables.entrySet())) {
            String var = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof IAnnotationExpression || value instanceof IBooleanExpression || value instanceof INumberExpression || value instanceof IStringExpression || value instanceof ITypeExpression) {
                Class<?> clazz = this.variableTypes.get(var);
                Object expressionValue = stream.getExpressionValue(clazz, (IRutaExpression)value, matchContext);
                this.initializedVariables.put(var, expressionValue);
                this.variableValues.put(var, expressionValue);
                continue;
            }
            if (!(value instanceof List)) continue;
            List list = (List)value;
            ArrayList<Object> newList = new ArrayList<Object>(list.size());
            Class<?> clazz = this.variableGenericTypes.get(var);
            for (Object each : list) {
                if (each instanceof IAnnotationExpression || each instanceof IBooleanExpression || each instanceof INumberExpression || each instanceof IStringExpression || each instanceof ITypeExpression) {
                    Object expressionValue = stream.getExpressionValue(clazz, (IRutaExpression)each, matchContext);
                    newList.add(expressionValue);
                    continue;
                }
                newList.add(each);
            }
            this.initializedVariables.put(var, newList);
            this.variableValues.put(var, new ArrayList(newList));
        }
    }

    private static class Alias {
        final String longName;
        final String shortName;

        Alias(String longName, String shortName) {
            this.longName = longName;
            this.shortName = shortName;
        }
    }
}

