/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.ConstraintFactory;
import org.apache.uima.cas.FSConstraint;
import org.apache.uima.cas.FSIntConstraint;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.FSMatchConstraint;
import org.apache.uima.cas.FeaturePath;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.constraint.BasicTypeConstraint;
import org.apache.uima.ruta.constraint.NotConstraint;

public class FilterManager {
    private final Collection<Type> defaultFilterTypes;
    private final FSMatchConstraint additionalWindow;
    private final AnnotationFS windowAnnotation;
    private final Type windowType;
    private Collection<Type> currentFilterTypes;
    private Collection<Type> currentRetainTypes;
    private ConstraintFactory cf;
    private final CAS cas;
    private Set<Type> currentHiddenTypes;
    private boolean emptyIsInvisible;

    public FilterManager(Collection<Type> defaultFilterTypes, boolean emptyIsInvisible, CAS cas) {
        this.defaultFilterTypes = defaultFilterTypes;
        this.currentFilterTypes = new ArrayList<Type>();
        this.currentRetainTypes = new ArrayList<Type>();
        this.cf = cas.getConstraintFactory();
        this.windowAnnotation = null;
        this.windowType = null;
        this.additionalWindow = null;
        this.emptyIsInvisible = emptyIsInvisible;
        this.cas = cas;
    }

    public FilterManager(Collection<Type> defaultFilterTypes, Collection<Type> filterTypes, Collection<Type> retainTypes, AnnotationFS windowAnnotation, Type windowType, boolean emptyIsInvisible, CAS cas) {
        this.defaultFilterTypes = defaultFilterTypes;
        this.currentFilterTypes = new ArrayList<Type>(filterTypes);
        this.currentRetainTypes = new ArrayList<Type>(retainTypes);
        this.cf = cas.getConstraintFactory();
        this.windowAnnotation = windowAnnotation;
        this.windowType = windowType;
        this.additionalWindow = this.createWindowConstraint(windowAnnotation, cas);
        this.emptyIsInvisible = emptyIsInvisible;
        this.cas = cas;
    }

    private FSMatchConstraint createWindowConstraint(AnnotationFS windowAnnotation, CAS cas) {
        if (windowAnnotation == null) {
            return null;
        }
        FeaturePath beginFP = cas.createFeaturePath();
        Type type = windowAnnotation.getType();
        beginFP.addFeature(type.getFeatureByBaseName("begin"));
        FSIntConstraint intConstraint = this.cf.createIntConstraint();
        intConstraint.geq(windowAnnotation.getBegin());
        FSMatchConstraint beginConstraint = this.cf.embedConstraint(beginFP, (FSConstraint)intConstraint);
        FeaturePath endFP = cas.createFeaturePath();
        endFP.addFeature(type.getFeatureByBaseName("end"));
        intConstraint = this.cf.createIntConstraint();
        intConstraint.leq(windowAnnotation.getEnd());
        FSMatchConstraint endConstraint = this.cf.embedConstraint(endFP, (FSConstraint)intConstraint);
        FSMatchConstraint windowConstraint = this.cf.and(beginConstraint, endConstraint);
        return windowConstraint;
    }

    public FSMatchConstraint getDefaultConstraint() {
        return this.createCurrentConstraint(true);
    }

    private FSMatchConstraint createCurrentConstraint(boolean windowConstraint) {
        HashSet<Type> filterTypes = new HashSet<Type>();
        filterTypes.addAll(this.defaultFilterTypes);
        filterTypes.addAll(this.currentFilterTypes);
        filterTypes.removeAll(this.currentRetainTypes);
        for (Type type : this.currentRetainTypes) {
            if (type == null) continue;
            List<Type> subsumedTypes = this.cas.getTypeSystem().getProperlySubsumedTypes(type);
            filterTypes.removeAll(subsumedTypes);
        }
        this.currentHiddenTypes = filterTypes;
        FSMatchConstraint typeConstraint = this.createTypeConstraint(filterTypes);
        FSMatchConstraint constraint = new NotConstraint(typeConstraint);
        if (this.additionalWindow != null && windowConstraint) {
            constraint = this.cf.and(this.additionalWindow, constraint);
        }
        return constraint;
    }

    private FSMatchConstraint createTypeConstraint(Collection<Type> types) {
        BasicTypeConstraint result = new BasicTypeConstraint(types, this.emptyIsInvisible);
        return result;
    }

    public void retainTypes(List<Type> list) {
        this.currentRetainTypes = list;
    }

    public void filterTypes(List<Type> list) {
        this.currentFilterTypes = list;
    }

    public void addFilterTypes(List<Type> types) {
        this.currentFilterTypes.addAll(types);
    }

    public void addRetainTypes(List<Type> types) {
        this.currentRetainTypes.addAll(types);
    }

    public void removeFilterTypes(List<Type> types) {
        this.currentFilterTypes.removeAll(types);
    }

    public void removeRetainTypes(List<Type> types) {
        this.currentRetainTypes.removeAll(types);
    }

    public Collection<Type> getDefaultFilterTypes() {
        return this.defaultFilterTypes;
    }

    public FSMatchConstraint getAdditionalWindow() {
        return this.additionalWindow;
    }

    public Collection<Type> getCurrentFilterTypes() {
        return this.currentFilterTypes;
    }

    public Collection<Type> getCurrentRetainTypes() {
        return this.currentRetainTypes;
    }

    public AnnotationFS getWindowAnnotation() {
        return this.windowAnnotation;
    }

    public Type getWindowType() {
        return this.windowType;
    }

    public FSIterator<AnnotationFS> createFilteredIterator(CAS cas, Type basicType) {
        if (this.windowAnnotation != null) {
            FSIterator windowIt = cas.getAnnotationIndex(basicType).subiterator(this.windowAnnotation);
            FSIterator<AnnotationFS> iterator = cas.createFilteredIterator(windowIt, this.createCurrentConstraint(false));
            return iterator;
        }
        FSIterator<AnnotationFS> iterator = cas.createFilteredIterator(cas.getAnnotationIndex(basicType).iterator(), this.createCurrentConstraint(false));
        return iterator;
    }

    public Set<Type> getCurrentHiddenTypes() {
        return this.currentHiddenTypes;
    }
}

