/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.uima.UIMAFramework;
import org.apache.uima.adapter.jms.activemq.SpringContainerDeployer;
import org.apache.uima.adapter.jms.service.UIMA_Service;
import org.apache.uima.ducc.user.jp.DuccAbstractProcessContainer;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class UimaASServiceContainer
extends DuccAbstractProcessContainer
implements ApplicationListener<ApplicationEvent> {
    private String[] args = null;
    private SpringContainerDeployer serviceDeployer;
    public volatile boolean initialized = false;
    private static final Class<?> CLASS_NAME = UimaASServiceContainer.class;

    @Override
    public boolean useThreadAffinity() {
        return false;
    }

    @Override
    protected void doDeploy() throws Exception {
        UIMA_Service service = new UIMA_Service();
        if (this.args == null || this.args.length == 0) {
            throw new RuntimeException("Unable to Deploy UIMA-AS service Due to Missing Deployment Descriptor ");
        }
        for (int i = 0; i < this.args.length - 1; ++i) {
            if (!this.args[i].equals("-dd") || this.args[i + 1].endsWith(".xml")) continue;
            this.args[i + 1] = this.copyDD(this.args[i + 1]);
        }
        String[] contextFiles = service.initialize(this.args);
        if (contextFiles == null) {
            throw new Exception("Spring Context Files Not Generated. Unable to Launch Uima AS Service");
        }
        this.serviceDeployer = service.deploy(contextFiles, (ApplicationListener)this);
        if (this.serviceDeployer == null || this.serviceDeployer.initializationFailed()) {
            System.out.println(">>> Failed to Deploy UIMA Service");
            throw new ResourceInitializationException(new RuntimeException("Unable to deploy UIMA-AS service from " + this.args[0]));
        }
        System.out.println(">>> Service Container Deployed Successfully");
    }

    private String copyDD(String resourceName) throws IOException {
        String resourceFile = resourceName.replace('.', '/') + ".xml";
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceFile);
        if (is == null) {
            return resourceName;
        }
        String logDir = System.getProperty("ducc.process.log.dir");
        File dir2 = new File(logDir);
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        File outf = File.createTempFile("uima-as-dd-", ".xml", dir2);
        try (FileOutputStream outs = new FileOutputStream(outf);){
            int len;
            byte[] buf = new byte[4096];
            while ((len = is.read(buf)) > 0) {
                outs.write(buf, 0, len);
            }
        }
        UIMAFramework.getLogger(CLASS_NAME).log(Level.INFO, "Copied resource " + resourceName + " as " + outf.getAbsolutePath());
        return outf.getAbsolutePath();
    }

    @Override
    protected int doInitialize(Properties p, String[] args) throws Exception {
        this.args = args;
        return 1;
    }

    @Override
    protected void doStop() throws Exception {
        if (this.serviceDeployer != null) {
            this.serviceDeployer.getTopLevelController().stop();
        }
    }

    @Override
    protected List<Properties> doProcess(Object subject) throws Exception {
        return null;
    }

    @Override
    public void onApplicationEvent(ApplicationEvent arg0) {
    }
}

