/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.jp;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public class DuccUimaLoader {
    private static boolean suppressClassPathDisplay;
    Object uimaContainerInstance = null;
    Method processMethod = null;
    Method stopMethod = null;
    private static FilenameFilter jarFilter;

    public static void main(String[] args) {
        try {
            DuccUimaLoader loader = new DuccUimaLoader();
            loader.deploy(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int deploy(String[] args) throws Exception {
        URL[] urls = this.getUrls();
        DuccUimaLoader.addUrlsToSystemLoader(urls);
        Class<?> classToLaunch = null;
        try {
            classToLaunch = ClassLoader.getSystemClassLoader().loadClass("UimaProcessContainer");
        }
        catch (ClassNotFoundException e) {
            System.err.println("Cannot find class to launch");
            System.exit(1);
        }
        Method deployMethod = classToLaunch.getMethod("deploy", String[].class);
        this.processMethod = classToLaunch.getMethod("process", String.class);
        this.stopMethod = classToLaunch.getMethod("stop", new Class[0]);
        int args2length = args.length - 1;
        if (args2length < 0) {
            args2length = 0;
        }
        this.uimaContainerInstance = classToLaunch.newInstance();
        Object scaleout = deployMethod.invoke(this.uimaContainerInstance, new Object[]{args});
        return (Integer)scaleout;
    }

    public void stop() throws Exception {
        this.stopMethod.invoke(this.uimaContainerInstance, new Object[0]);
    }

    public void process(String xmi) throws Exception {
        this.processMethod.invoke(this.uimaContainerInstance, xmi);
    }

    private static void addUrlsToSystemLoader(URL[] urls) throws IOException {
        URLClassLoader systemClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (URL url : urls) {
                method.invoke((Object)systemClassLoader, url);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new IOException("Error, could not add URL to system classloader");
        }
    }

    private URL[] getUrls() throws MalformedURLException, IOException, URISyntaxException {
        String[] jpaths;
        String jps = System.getProperty("org.apache.uima.ducc.userjarpath");
        if (null == jps) {
            System.err.println("Missing the -Dorg.apache.uima.jarpath=XXXX property");
            System.exit(1);
        }
        if (!suppressClassPathDisplay) {
            System.out.println("UimaBootstrap ClassPath:");
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String p : jpaths = jps.split(File.pathSeparator)) {
            DuccUimaLoader.addUrlsFromPath(p, urls);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static void addUrlsFromPath(String p, List<URL> urls) throws MalformedURLException, IOException, URISyntaxException {
        File pf = new File(p);
        if (pf.isDirectory()) {
            File[] jars = pf.listFiles(jarFilter);
            if (jars == null || jars.length == 0) {
                DuccUimaLoader.add(urls, pf);
            } else {
                for (File f : jars) {
                    DuccUimaLoader.add(urls, f);
                }
            }
        } else if (p.toLowerCase().endsWith(".jar")) {
            DuccUimaLoader.add(urls, pf);
        }
    }

    private static void add(List<URL> urls, File cp) throws MalformedURLException {
        URL url = cp.toURI().toURL();
        if (!suppressClassPathDisplay) {
            System.out.format(" %s%n", url.toString());
        }
        urls.add(url);
    }

    static {
        jarFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir2, String name) {
                name = name.toLowerCase();
                return name.endsWith(".jar");
            }
        };
    }
}

