/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.jd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.ducc.CasHelper;
import org.apache.uima.ducc.user.common.DuccUimaSerializer;
import org.apache.uima.ducc.user.common.ExceptionHelper;
import org.apache.uima.ducc.user.common.QuotedOptions;
import org.apache.uima.ducc.user.common.UimaUtils;
import org.apache.uima.ducc.user.jd.JdUserCasManager;
import org.apache.uima.ducc.user.jd.JdUserMetaCas;
import org.apache.uima.ducc.user.jd.JdUserSerializationException;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.ConfigurationParameter;
import org.apache.uima.resource.metadata.ConfigurationParameterDeclarations;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.XMLInputSource;
import org.apache.uima.util.XMLParser;

public class JdUserCollectionReader {
    private static DuccUimaSerializer uimaSerializer = new DuccUimaSerializer();
    private String crXml = null;
    private String crCfg = null;
    private JdUserCasManager cm = null;
    private CollectionReader cr = null;
    private HashMap<String, String> overrides = new HashMap();
    private int total = -1;
    private AtomicInteger seqNo = new AtomicInteger(0);

    public JdUserCollectionReader(String crXml, String crCfg) throws Exception {
        this.initialize(crXml, crCfg);
    }

    public void initialize(String crXml, String crCfg) throws Exception {
        try {
            this._initialize(crXml, crCfg);
        }
        catch (Exception e) {
            Exception jdUserException = ExceptionHelper.wrapStringifiedException(e);
            throw jdUserException;
        }
    }

    private void _initialize(String crXml, String crCfg) throws InvalidXMLException, ResourceConfigurationException, ResourceInitializationException {
        this.setCrXml(crXml);
        this.setCrCfg(crCfg);
        XMLParser xmlParser = UIMAFramework.getXMLParser();
        XMLInputSource in = null;
        String crDescriptor = crXml;
        in = UimaUtils.getXMLInputSource(crDescriptor);
        CollectionReaderDescription crrs = xmlParser.parseCollectionReaderDescription(in);
        ResourceCreationSpecifier specifier = crrs;
        ConfigurationParameterDeclarations configurationParameterDeclarations = specifier.getMetaData().getConfigurationParameterDeclarations();
        ConfigurationParameterSettings cps = specifier.getMetaData().getConfigurationParameterSettings();
        if (crCfg != null) {
            ArrayList<String> toks = QuotedOptions.tokenizeList(crCfg, true);
            Map<String, String> map = QuotedOptions.parseAssignments(toks, 0);
            for (Map.Entry<String, String> ent : map.entrySet()) {
                String name = ent.getKey();
                String value = ent.getValue();
                this.overrides.put(name, value);
                ConfigurationParameter configurationParameter = UimaUtils.findConfigurationParameter(configurationParameterDeclarations, name);
                if (configurationParameter == null) {
                    throw new ResourceConfigurationException("nonexistent_parameter", new Object[]{name, "CollectionReader"});
                }
                Object object = UimaUtils.getOverrideValueObject(configurationParameter, value);
                cps.setParameterValue(name, object);
            }
        }
        this.setCr(UIMAFramework.produceCollectionReader(crrs));
        this.initTotal();
        this.cm = new JdUserCasManager(this.cr);
    }

    public int getTotal() {
        return this.total;
    }

    public JdUserMetaCas getJdUserEmptyMetaCas() throws Exception {
        JdUserMetaCas retVal = null;
        try {
            String serializedCas = null;
            String documentText = null;
            int systemSeqNo = this.seqNo.incrementAndGet();
            retVal = new JdUserMetaCas(systemSeqNo, serializedCas, documentText);
        }
        catch (Exception e) {
            Exception jdUserException = ExceptionHelper.wrapStringifiedException(e);
            throw jdUserException;
        }
        return retVal;
    }

    public JdUserMetaCas getJdUserMetaCas() throws Exception {
        try {
            return this._getJdUserMetaCas();
        }
        catch (Exception e) {
            Exception jdUserException = ExceptionHelper.wrapStringifiedException(e);
            throw jdUserException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JdUserMetaCas _getJdUserMetaCas() throws CollectionException, IOException, Exception {
        JdUserMetaCas retVal = null;
        CollectionReader collectionReader = this.cr;
        synchronized (collectionReader) {
            if (this.cr.hasNext()) {
                CAS cas = this.cm.getEmptyCas();
                this.cr.getNext(cas);
                String serializedCas = null;
                try {
                    serializedCas = this.serialize(cas);
                }
                catch (Exception e) {
                    JdUserSerializationException se = new JdUserSerializationException(e);
                    throw se;
                }
                String documentText = CasHelper.getId(cas);
                int systemSeqNo = this.seqNo.incrementAndGet();
                retVal = new JdUserMetaCas(systemSeqNo, serializedCas, documentText);
                this.cm.recycle(cas);
            }
        }
        return retVal;
    }

    public String serialize(CAS cas) throws Exception {
        String serializedCas = uimaSerializer.serializeCasToXmi(cas);
        return serializedCas;
    }

    public void recycle(CAS cas) {
        this.cm.recycle(cas);
    }

    private void setCrXml(String value) {
        this.crXml = value;
    }

    public String getCrXml() {
        return this.crXml;
    }

    private void setCrCfg(String value) {
        this.crCfg = value;
    }

    public String getCrCfg() {
        return this.crCfg;
    }

    private void setCr(CollectionReader value) {
        this.cr = value;
    }

    public CollectionReader getCr() {
        return this.cr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Progress[] getProgressArray() {
        CollectionReader collectionReader = this.cr;
        synchronized (collectionReader) {
            return this.cr.getProgress();
        }
    }

    public Progress getProgress() {
        Progress progress = null;
        Progress[] progressArray = this.getProgressArray();
        if (progressArray != null) {
            progress = progressArray[0];
        }
        return progress;
    }

    private void initTotal() {
        Progress progress = this.getProgress();
        if (progress != null) {
            this.setTotal((int)progress.getTotal());
        }
    }

    private void setTotal(int value) {
        this.total = value;
    }
}

