/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.common.main;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.uima.ducc.user.common.investment.Investment;
import org.apache.uima.ducc.user.jp.iface.IProcessContainer;

public class DuccJobService {
    boolean DEBUG = false;
    private Investment investment = null;
    private Method stopMethod;
    private Object duccContainerInstance;
    private Logger logger = Logger.getLogger(DuccJobService.class.getName());

    public static URLClassLoader create(String classPath) throws MalformedURLException {
        return DuccJobService.create(classPath.split(":"));
    }

    public static URLClassLoader create(String[] classPathElements) throws MalformedURLException {
        ArrayList<URL> urlList = new ArrayList<URL>(classPathElements.length);
        for (String element : classPathElements) {
            if (element.endsWith("*")) {
                File dir2 = new File(element.substring(0, element.length() - 1));
                File[] files = dir2.listFiles();
                if (files == null) continue;
                for (File f : files) {
                    if (!f.getName().endsWith(".jar")) continue;
                    urlList.add(f.toURI().toURL());
                }
                continue;
            }
            File f = new File(element);
            if (!f.exists()) continue;
            urlList.add(f.toURI().toURL());
        }
        URL[] urls = new URL[urlList.size()];
        return new URLClassLoader(urlList.toArray(urls), ClassLoader.getSystemClassLoader().getParent());
    }

    public static void dump(ClassLoader cl, int numLevels) {
        int n = 0;
        for (URLClassLoader ucl = (URLClassLoader)cl; ucl != null && ++n <= numLevels; ucl = (URLClassLoader)ucl.getParent()) {
            System.out.println("Class-loader " + n + " has " + ucl.getURLs().length + " urls:");
            for (URL u : ucl.getURLs()) {
                System.out.println("  " + u);
            }
        }
    }

    public void start(String[] args) throws Exception {
        try {
            this.investment = new Investment();
            ClassLoader sysCL = Thread.currentThread().getContextClassLoader();
            String duccContainerClasspath = System.getProperty("ducc.deploy.DuccClasspath");
            URLClassLoader ucl = DuccJobService.create(duccContainerClasspath);
            if (System.getProperty("ducc.debug") != null) {
                this.DEBUG = true;
            }
            if (this.DEBUG) {
                DuccJobService.dump(ucl, 4);
            }
            Class<?> duccServiceClass = ucl.loadClass("org.apache.uima.ducc.common.main.DuccService");
            Method bootMethod = duccServiceClass.getMethod("boot", String[].class);
            Method setProcessorMethod = duccServiceClass.getMethod("setProcessor", Object.class, String[].class);
            Method registerInvestmentInstanceMethod = duccServiceClass.getMethod("registerInvestmentInstance", Object.class);
            Method startMethod = duccServiceClass.getMethod("start", new Class[0]);
            this.stopMethod = duccServiceClass.getMethod("stop", new Class[0]);
            this.logger.log(Level.INFO, ">>>>>>>>> Booting Ducc Container");
            HashMap<String, String> savedPropsMap = DuccJobService.hideLoggingProperties();
            Thread.currentThread().setContextClassLoader(ucl);
            this.duccContainerInstance = duccServiceClass.newInstance();
            bootMethod.invoke(this.duccContainerInstance, new Object[]{args});
            this.logger.log(Level.INFO, "<<<<<<<< Ducc Container booted");
            DuccJobService.restoreLoggingProperties(savedPropsMap);
            String processorClass = System.getProperty("ducc.deploy.JpProcessorClass");
            Class<?> processorClz = sysCL.loadClass(processorClass);
            IProcessContainer pc = (IProcessContainer)processorClz.newInstance();
            this.logger.log(Level.INFO, ">>>>>>>>> Running Ducc Container");
            setProcessorMethod.invoke(this.duccContainerInstance, pc, args);
            registerInvestmentInstanceMethod.invoke(this.duccContainerInstance, this.investment);
            startMethod.invoke(this.duccContainerInstance, new Object[0]);
            this.logger.log(Level.INFO, "<<<<<<<< Ducc Container ended");
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.out.println("Exiting Process Due to Unrecoverable Error");
            Runtime.getRuntime().halt(99);
        }
    }

    public void stop() {
        try {
            this.stopMethod.invoke(this.duccContainerInstance, new Object[0]);
        }
        catch (Throwable t) {
            this.logger.log(Level.SEVERE, "Stop failed");
            t.printStackTrace();
        }
    }

    public static HashMap<String, String> hideLoggingProperties() {
        String[] propsToSave = new String[]{"log4j.configuration", "java.util.logging.config.file", "java.util.logging.config.class", "org.apache.uima.logger.class"};
        HashMap<String, String> savedPropsMap = new HashMap<String, String>();
        for (String prop : propsToSave) {
            String val = System.getProperty(prop);
            if (val == null) continue;
            savedPropsMap.put(prop, val);
            System.getProperties().remove(prop);
        }
        return savedPropsMap;
    }

    public static void restoreLoggingProperties(HashMap<String, String> savedPropsMap) {
        for (String prop : savedPropsMap.keySet()) {
            System.setProperty(prop, savedPropsMap.get(prop));
        }
    }

    public static void main(String[] args) {
        try {
            DuccJobService service = new DuccJobService();
            service.start(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

