/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.user.common;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.uima.UIMAFramework;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.impl.XmiCasDeserializer;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.util.Level;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class DuccUimaSerializer {
    private static final String LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String EXTERNAL_GENERAL_ENTITIES = "http://xml.org/sax/features/external-general-entities";
    private static final String EXTERNAL_PARAMETER_ENTITIES = "http://xml.org/sax/features/external-parameter-entities";

    public String serializeCasToXmi(CAS aCAS) throws Exception {
        try (StringWriter writer = new StringWriter();){
            XMLSerializer xmlSer = new XMLSerializer(writer, false);
            XmiCasSerializer ser = new XmiCasSerializer(aCAS.getTypeSystem());
            ser.serialize(aCAS, xmlSer.getContentHandler());
            String string = ((Object)writer).toString();
            return string;
        }
    }

    private void secureXmlReader(XMLReader xmlReader) {
        try {
            xmlReader.setFeature(EXTERNAL_GENERAL_ENTITIES, false);
        }
        catch (SAXNotRecognizedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader didn't recognize feature http://xml.org/sax/features/external-general-entities");
        }
        catch (SAXNotSupportedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader doesn't support feature http://xml.org/sax/features/external-general-entities");
        }
        try {
            xmlReader.setFeature(EXTERNAL_PARAMETER_ENTITIES, false);
        }
        catch (SAXNotRecognizedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader didn't recognize feature http://xml.org/sax/features/external-parameter-entities");
        }
        catch (SAXNotSupportedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader doesn't support feature http://xml.org/sax/features/external-parameter-entities");
        }
        try {
            xmlReader.setFeature(LOAD_EXTERNAL_DTD, false);
        }
        catch (SAXNotRecognizedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader didn't recognized feature http://apache.org/xml/features/nonvalidating/load-external-dtd");
        }
        catch (SAXNotSupportedException e) {
            UIMAFramework.getLogger().log(Level.WARNING, "XMLReader doesn't support feature http://apache.org/xml/features/nonvalidating/load-external-dtd");
        }
    }

    public void deserializeCasFromXmi(String anXmlStr, CAS aCAS) throws FactoryConfigurationError, ParserConfigurationException, SAXException, IOException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        this.secureXmlReader(xmlReader);
        StringReader reader = new StringReader(anXmlStr);
        XmiCasDeserializer deser = new XmiCasDeserializer(aCAS.getTypeSystem());
        DefaultHandler handler = deser.getXmiCasHandler(aCAS);
        xmlReader.setContentHandler(handler);
        xmlReader.parse(new InputSource(reader));
    }
}

