/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc.logger;

import java.io.File;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.uima.ducc.logger.LoggerFormatter;

public class ToLog {
    private static String getFilePath(Class<?> clazz) {
        String filePath = null;
        String key = "ducc.process.log.dir";
        String value = System.getProperty(key);
        if (value != null) {
            filePath = value;
            if (!filePath.endsWith(File.separator)) {
                filePath = filePath + File.separator;
            }
            filePath = filePath + clazz.getSimpleName() + ".log";
        }
        return filePath;
    }

    private static Logger create(Class<?> clazz, String filePath) {
        Logger logger = Logger.getLogger(clazz.getCanonicalName());
        try {
            boolean append = true;
            FileHandler fileHandler = new FileHandler(filePath, append);
            LoggerFormatter loggerFormatter = new LoggerFormatter();
            fileHandler.setFormatter(loggerFormatter);
            logger.addHandler(fileHandler);
            logger.setUseParentHandlers(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logger;
    }

    private static Logger getLogger(Class<?> clazz, String filePath) {
        Logger logger = null;
        if (filePath != null) {
            logger = ToLog.create(clazz, filePath);
        }
        return logger;
    }

    private static Logger getLogger(Class<?> clazz) {
        String filePath = ToLog.getFilePath(clazz);
        Logger logger = ToLog.getLogger(clazz, filePath);
        return logger;
    }

    private static void close(Logger logger) {
        Handler[] handlers = logger.getHandlers();
        if (handlers != null) {
            for (Handler handler : handlers) {
                handler.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void info(Class<?> clazz, String text) {
        Class<ToLog> clazz2 = ToLog.class;
        synchronized (ToLog.class) {
            Logger logger;
            if (clazz != null && text != null && (logger = ToLog.getLogger(clazz)) != null) {
                logger.info(text);
                ToLog.close(logger);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug(Class<?> clazz, String text) {
        Class<ToLog> clazz2 = ToLog.class;
        synchronized (ToLog.class) {
            Logger logger;
            if (clazz != null && text != null && (logger = ToLog.getLogger(clazz)) != null) {
                logger.log(Level.FINE, text);
                ToLog.close(logger);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warning(Class<?> clazz, String text) {
        Class<ToLog> clazz2 = ToLog.class;
        synchronized (ToLog.class) {
            Logger logger;
            if (clazz != null && text != null && (logger = ToLog.getLogger(clazz)) != null) {
                logger.log(Level.WARNING, text);
                ToLog.close(logger);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void warning(Class<?> clazz, Throwable t) {
        Class<ToLog> clazz2 = ToLog.class;
        synchronized (ToLog.class) {
            Logger logger;
            if (clazz != null && t != null && (logger = ToLog.getLogger(clazz)) != null) {
                logger.log(Level.WARNING, t.getMessage(), t);
                ToLog.close(logger);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }
}

