/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ducc;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.uima.ducc.ErrorHandler;
import org.apache.uima.ducc.logger.ToLog;

public class ErrorHandlerProgrammability {
    private Map<Key, Integer> map = new ConcurrentHashMap<Key, Integer>();

    public ErrorHandlerProgrammability() {
        this.map.put(Key.max_job_errors, new Integer(15));
        this.map.put(Key.max_timeout_retrys_per_workitem, new Integer(0));
        this.dumpArgs();
        this.dumpMap();
    }

    public ErrorHandlerProgrammability(String argString) {
        this.map.put(Key.max_job_errors, new Integer(15));
        this.map.put(Key.max_timeout_retrys_per_workitem, new Integer(0));
        this.dumpArgs(argString);
        String[] args = this.toArgs(argString);
        this.override(args);
        this.dumpMap();
    }

    private String[] toArgs(String argString) {
        String[] list = null;
        if (argString != null) {
            list = argString.split("\\s+");
        }
        return list;
    }

    public ErrorHandlerProgrammability(String[] args) {
        this.map.put(Key.max_job_errors, new Integer(15));
        this.map.put(Key.max_timeout_retrys_per_workitem, new Integer(0));
        this.dumpArgs(args);
        this.override(args);
        this.dumpMap();
    }

    private void override(String[] args) {
        if (args != null) {
            for (String arg : args) {
                String[] kvp = arg.split("=");
                if (kvp.length == 2) {
                    Key key = this.parseKey(kvp[0]);
                    Integer value = this.parseValue(kvp[1]);
                    this.map.put(key, value);
                    String text = "override: " + key.name() + "=" + value;
                    ToLog.info(ErrorHandler.class, text);
                    continue;
                }
                String text = "illegal argument: " + arg;
                ToLog.warning(ErrorHandler.class, text);
            }
        }
    }

    private Key parseKey(String name) {
        Key key = null;
        if (name != null) {
            for (Key k : Key.values()) {
                if (!name.equals(k.name())) continue;
                key = k;
                break;
            }
            if (key == null) {
                String text = "illegal argument: " + name;
                ToLog.warning(ErrorHandler.class, text);
            }
        } else {
            String text = "missing argument: <name>=";
            ToLog.warning(ErrorHandler.class, text);
        }
        return key;
    }

    private Integer parseValue(String value) {
        int iVal = 0;
        if (value != null) {
            try {
                iVal = Integer.parseInt(value);
            }
            catch (Exception e) {
                String text = "illegal argument: " + value;
                ToLog.warning(ErrorHandler.class, text);
            }
        } else {
            String text = "missing argument: =<value>";
            ToLog.warning(ErrorHandler.class, text);
        }
        return iVal;
    }

    public Integer getInteger(Key key) {
        return this.map.get((Object)key);
    }

    private void dumpArgs() {
        String text = "args: none";
        ToLog.debug(ErrorHandler.class, text);
    }

    public void dumpArgs(String args) {
        if (args == null) {
            String text = "argString: null";
            ToLog.debug(ErrorHandler.class, text);
        } else {
            String text = "argString: " + args;
            ToLog.debug(ErrorHandler.class, text);
        }
    }

    public void dumpArgs(String[] args) {
        if (args == null) {
            String text = "args: null";
            ToLog.debug(ErrorHandler.class, text);
        } else {
            StringBuffer sb = new StringBuffer();
            for (String arg : args) {
                sb.append(arg);
                sb.append(" ");
            }
            String text = "args: " + sb.toString().trim();
            ToLog.debug(ErrorHandler.class, text);
        }
    }

    private void dumpMap() {
        for (Map.Entry<Key, Integer> entry : this.map.entrySet()) {
            String key = entry.getKey().name();
            Integer value = entry.getValue();
            String text = key + "=" + value;
            ToLog.debug(ErrorHandler.class, text);
        }
    }

    public static enum Key {
        max_job_errors,
        max_timeout_retrys_per_workitem;

    }
}

