/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;

@Deprecated
public class RAMDirectory
extends BaseDirectory
implements Accountable {
    protected final Map<String, RAMFile> fileMap = new ConcurrentHashMap<String, RAMFile>();
    protected final AtomicLong sizeInBytes = new AtomicLong();
    private final AtomicLong nextTempFileCounter = new AtomicLong();

    public RAMDirectory() {
        this(new SingleInstanceLockFactory());
    }

    public RAMDirectory(LockFactory lockFactory) {
        super(lockFactory);
    }

    public RAMDirectory(FSDirectory dir2, IOContext context) throws IOException {
        this(dir2, false, context);
    }

    private RAMDirectory(FSDirectory dir2, boolean closeDir, IOContext context) throws IOException {
        this();
        for (String file : dir2.listAll()) {
            if (Files.isDirectory(dir2.getDirectory().resolve(file), new LinkOption[0])) continue;
            this.copyFrom(dir2, file, file, context);
        }
        if (closeDir) {
            dir2.close();
        }
    }

    @Override
    public final String[] listAll() {
        this.ensureOpen();
        Set<String> fileNames = this.fileMap.keySet();
        ArrayList<String> names = new ArrayList<String>(fileNames.size());
        for (String name : fileNames) {
            names.add(name);
        }
        Object[] namesArray = names.toArray(new String[names.size()]);
        Arrays.sort(namesArray);
        return namesArray;
    }

    public final boolean fileNameExists(String name) {
        this.ensureOpen();
        return this.fileMap.containsKey(name);
    }

    @Override
    public final long fileLength(String name) throws IOException {
        this.ensureOpen();
        RAMFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLength();
    }

    @Override
    public final long ramBytesUsed() {
        this.ensureOpen();
        return this.sizeInBytes.get();
    }

    @Override
    public Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables("file", this.fileMap);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.ensureOpen();
        RAMFile file = this.fileMap.remove(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        file.directory = null;
        this.sizeInBytes.addAndGet(-file.sizeInBytes);
    }

    @Override
    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        RAMFile file = this.newRAMFile();
        if (this.fileMap.putIfAbsent(name, file) != null) {
            throw new FileAlreadyExistsException(name);
        }
        return new RAMOutputStream(name, file, true);
    }

    @Override
    public IndexOutput createTempOutput(String prefix, String suffix, IOContext context) throws IOException {
        String name;
        this.ensureOpen();
        RAMFile file = this.newRAMFile();
        while (this.fileMap.putIfAbsent(name = IndexFileNames.segmentFileName(prefix, suffix + "_" + Long.toString(this.nextTempFileCounter.getAndIncrement(), 36), "tmp"), file) != null) {
        }
        return new RAMOutputStream(name, file, true);
    }

    protected RAMFile newRAMFile() {
        return new RAMFile(this);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
    }

    @Override
    public void rename(String source, String dest) throws IOException {
        this.ensureOpen();
        RAMFile file = this.fileMap.get(source);
        if (file == null) {
            throw new FileNotFoundException(source);
        }
        if (this.fileMap.putIfAbsent(dest, file) != null) {
            throw new FileAlreadyExistsException(dest);
        }
        if (!this.fileMap.remove(source, file)) {
            throw new IllegalStateException("file was unexpectedly replaced: " + source);
        }
        this.fileMap.remove(source);
    }

    @Override
    public void syncMetaData() throws IOException {
    }

    @Override
    public IndexInput openInput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        RAMFile file = this.fileMap.get(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return new RAMInputStream(name, file);
    }

    @Override
    public void close() {
        this.isOpen = false;
        this.fileMap.clear();
    }

    @Override
    public Set<String> getPendingDeletions() {
        return Collections.emptySet();
    }
}

