/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;

public final class ReaderManager
extends ReferenceManager<DirectoryReader> {
    public ReaderManager(IndexWriter writer) throws IOException {
        this(writer, true, false);
    }

    public ReaderManager(IndexWriter writer, boolean applyAllDeletes, boolean writeAllDeletes) throws IOException {
        this.current = DirectoryReader.open(writer, applyAllDeletes, writeAllDeletes);
    }

    public ReaderManager(Directory dir2) throws IOException {
        this.current = DirectoryReader.open(dir2);
    }

    public ReaderManager(DirectoryReader reader) throws IOException {
        this.current = reader;
    }

    @Override
    protected void decRef(DirectoryReader reference) throws IOException {
        reference.decRef();
    }

    @Override
    protected DirectoryReader refreshIfNeeded(DirectoryReader referenceToRefresh) throws IOException {
        return DirectoryReader.openIfChanged(referenceToRefresh);
    }

    @Override
    protected boolean tryIncRef(DirectoryReader reference) {
        return reference.tryIncRef();
    }

    @Override
    protected int getRefCount(DirectoryReader reference) {
        return reference.getRefCount();
    }
}

