/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene70;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSelector;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Version;

public class Lucene70SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene70SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SegmentInfo read(Directory dir2, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName(segment, "", SI_EXTENSION);
        try (ChecksumIndexInput input = dir2.openChecksumInput(fileName, context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                Sort indexSort;
                Version minVersion;
                int format = CodecUtil.checkIndexHeader(input, CODEC_NAME, 0, 0, segmentID, "");
                Version version2 = Version.fromBits(input.readInt(), input.readInt(), input.readInt());
                byte hasMinVersion = input.readByte();
                switch (hasMinVersion) {
                    case 0: {
                        minVersion = null;
                        break;
                    }
                    case 1: {
                        minVersion = Version.fromBits(input.readInt(), input.readInt(), input.readInt());
                        break;
                    }
                    default: {
                        throw new CorruptIndexException("Illegal boolean value " + hasMinVersion, input);
                    }
                }
                int docCount = input.readInt();
                if (docCount < 0) {
                    throw new CorruptIndexException("invalid docCount: " + docCount, input);
                }
                boolean isCompoundFile = input.readByte() == 1;
                Map<String, String> diagnostics = input.readMapOfStrings();
                Set<String> files = input.readSetOfStrings();
                Map<String, String> attributes = input.readMapOfStrings();
                int numSortFields = input.readVInt();
                if (numSortFields > 0) {
                    SortField[] sortFields = new SortField[numSortFields];
                    for (int i = 0; i < numSortFields; ++i) {
                        Object missingValue;
                        boolean reverse;
                        SortField.Type sortType;
                        String fieldName = input.readString();
                        int sortTypeID = input.readVInt();
                        SortedSetSelector.Type sortedSetSelector = null;
                        SortedNumericSelector.Type sortedNumericSelector = null;
                        switch (sortTypeID) {
                            case 0: {
                                sortType = SortField.Type.STRING;
                                break;
                            }
                            case 1: {
                                sortType = SortField.Type.LONG;
                                break;
                            }
                            case 2: {
                                sortType = SortField.Type.INT;
                                break;
                            }
                            case 3: {
                                sortType = SortField.Type.DOUBLE;
                                break;
                            }
                            case 4: {
                                sortType = SortField.Type.FLOAT;
                                break;
                            }
                            case 5: {
                                sortType = SortField.Type.STRING;
                                byte selector = input.readByte();
                                if (selector == 0) {
                                    sortedSetSelector = SortedSetSelector.Type.MIN;
                                    break;
                                }
                                if (selector == 1) {
                                    sortedSetSelector = SortedSetSelector.Type.MAX;
                                    break;
                                }
                                if (selector == 2) {
                                    sortedSetSelector = SortedSetSelector.Type.MIDDLE_MIN;
                                    break;
                                }
                                if (selector == 3) {
                                    sortedSetSelector = SortedSetSelector.Type.MIDDLE_MAX;
                                    break;
                                }
                                throw new CorruptIndexException("invalid index SortedSetSelector ID: " + selector, input);
                            }
                            case 6: {
                                byte type = input.readByte();
                                if (type == 0) {
                                    sortType = SortField.Type.LONG;
                                } else if (type == 1) {
                                    sortType = SortField.Type.INT;
                                } else if (type == 2) {
                                    sortType = SortField.Type.DOUBLE;
                                } else if (type == 3) {
                                    sortType = SortField.Type.FLOAT;
                                } else {
                                    throw new CorruptIndexException("invalid index SortedNumericSortField type ID: " + type, input);
                                }
                                byte numericSelector = input.readByte();
                                if (numericSelector == 0) {
                                    sortedNumericSelector = SortedNumericSelector.Type.MIN;
                                    break;
                                }
                                if (numericSelector == 1) {
                                    sortedNumericSelector = SortedNumericSelector.Type.MAX;
                                    break;
                                }
                                throw new CorruptIndexException("invalid index SortedNumericSelector ID: " + numericSelector, input);
                            }
                            default: {
                                throw new CorruptIndexException("invalid index sort field type ID: " + sortTypeID, input);
                            }
                        }
                        byte b = input.readByte();
                        if (b == 0) {
                            reverse = true;
                        } else if (b == 1) {
                            reverse = false;
                        } else {
                            throw new CorruptIndexException("invalid index sort reverse: " + b, input);
                        }
                        sortFields[i] = sortedSetSelector != null ? new SortedSetSortField(fieldName, reverse, sortedSetSelector) : (sortedNumericSelector != null ? new SortedNumericSortField(fieldName, sortType, reverse, sortedNumericSelector) : new SortField(fieldName, sortType, reverse));
                        b = input.readByte();
                        if (b == 0) {
                            missingValue = null;
                        } else {
                            switch (sortType) {
                                case STRING: {
                                    if (b == 1) {
                                        missingValue = SortField.STRING_LAST;
                                        break;
                                    }
                                    if (b == 2) {
                                        missingValue = SortField.STRING_FIRST;
                                        break;
                                    }
                                    throw new CorruptIndexException("invalid missing value flag: " + b, input);
                                }
                                case LONG: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, input);
                                    }
                                    missingValue = input.readLong();
                                    break;
                                }
                                case INT: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, input);
                                    }
                                    missingValue = input.readInt();
                                    break;
                                }
                                case DOUBLE: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, input);
                                    }
                                    missingValue = Double.longBitsToDouble(input.readLong());
                                    break;
                                }
                                case FLOAT: {
                                    if (b != 1) {
                                        throw new CorruptIndexException("invalid missing value flag: " + b, input);
                                    }
                                    missingValue = Float.valueOf(Float.intBitsToFloat(input.readInt()));
                                    break;
                                }
                                default: {
                                    throw new AssertionError((Object)("unhandled sortType=" + (Object)((Object)sortType)));
                                }
                            }
                        }
                        if (missingValue == null) continue;
                        sortFields[i].setMissingValue(missingValue);
                    }
                    indexSort = new Sort(sortFields);
                } else {
                    if (numSortFields < 0) {
                        throw new CorruptIndexException("invalid index sort field count: " + numSortFields, input);
                    }
                    indexSort = null;
                }
                si = new SegmentInfo(dir2, version2, minVersion, segment, docCount, isCompoundFile, null, diagnostics, segmentID, attributes, indexSort);
                si.setFiles(files);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter(input, priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void write(Directory dir2, SegmentInfo si, IOContext ioContext) throws IOException {
        String fileName = IndexFileNames.segmentFileName(si.name, "", SI_EXTENSION);
        try (IndexOutput output = dir2.createOutput(fileName, ioContext);){
            si.addFile(fileName);
            CodecUtil.writeIndexHeader(output, CODEC_NAME, 0, si.getId(), "");
            Version version2 = si.getVersion();
            if (version2.major < 7) {
                throw new IllegalArgumentException("invalid major version: should be >= 7 but got: " + version2.major + " segment=" + si);
            }
            output.writeInt(version2.major);
            output.writeInt(version2.minor);
            output.writeInt(version2.bugfix);
            if (si.getMinVersion() != null) {
                output.writeByte((byte)1);
                Version minVersion = si.getMinVersion();
                output.writeInt(minVersion.major);
                output.writeInt(minVersion.minor);
                output.writeInt(minVersion.bugfix);
            } else {
                output.writeByte((byte)0);
            }
            assert (version2.prerelease == 0);
            output.writeInt(si.maxDoc());
            output.writeByte((byte)(si.getUseCompoundFile() ? 1 : -1));
            output.writeMapOfStrings(si.getDiagnostics());
            Set<String> files = si.files();
            for (String file : files) {
                if (IndexFileNames.parseSegmentName(file).equals(si.name)) continue;
                throw new IllegalArgumentException("invalid files: expected segment=" + si.name + ", got=" + files);
            }
            output.writeSetOfStrings(files);
            output.writeMapOfStrings(si.getAttributes());
            Sort indexSort = si.getIndexSort();
            int numSortFields = indexSort == null ? 0 : indexSort.getSort().length;
            output.writeVInt(numSortFields);
            block25: for (int i = 0; i < numSortFields; ++i) {
                int sortTypeID;
                SortField sortField = indexSort.getSort()[i];
                SortField.Type sortType = sortField.getType();
                output.writeString(sortField.getField());
                switch (sortField.getType()) {
                    case STRING: {
                        sortTypeID = 0;
                        break;
                    }
                    case LONG: {
                        sortTypeID = 1;
                        break;
                    }
                    case INT: {
                        sortTypeID = 2;
                        break;
                    }
                    case DOUBLE: {
                        sortTypeID = 3;
                        break;
                    }
                    case FLOAT: {
                        sortTypeID = 4;
                        break;
                    }
                    case CUSTOM: {
                        if (sortField instanceof SortedSetSortField) {
                            sortTypeID = 5;
                            sortType = SortField.Type.STRING;
                            break;
                        }
                        if (!(sortField instanceof SortedNumericSortField)) throw new IllegalStateException("Unexpected SortedNumericSortField " + sortField);
                        sortTypeID = 6;
                        sortType = ((SortedNumericSortField)sortField).getNumericType();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected sort type: " + (Object)((Object)sortField.getType()));
                    }
                }
                output.writeVInt(sortTypeID);
                if (sortTypeID == 5) {
                    SortedSetSortField ssf = (SortedSetSortField)sortField;
                    if (ssf.getSelector() == SortedSetSelector.Type.MIN) {
                        output.writeByte((byte)0);
                    } else if (ssf.getSelector() == SortedSetSelector.Type.MAX) {
                        output.writeByte((byte)1);
                    } else if (ssf.getSelector() == SortedSetSelector.Type.MIDDLE_MIN) {
                        output.writeByte((byte)2);
                    } else {
                        if (ssf.getSelector() != SortedSetSelector.Type.MIDDLE_MAX) throw new IllegalStateException("Unexpected SortedSetSelector type: " + (Object)((Object)ssf.getSelector()));
                        output.writeByte((byte)3);
                    }
                } else if (sortTypeID == 6) {
                    SortedNumericSortField snsf = (SortedNumericSortField)sortField;
                    if (snsf.getNumericType() == SortField.Type.LONG) {
                        output.writeByte((byte)0);
                    } else if (snsf.getNumericType() == SortField.Type.INT) {
                        output.writeByte((byte)1);
                    } else if (snsf.getNumericType() == SortField.Type.DOUBLE) {
                        output.writeByte((byte)2);
                    } else {
                        if (snsf.getNumericType() != SortField.Type.FLOAT) throw new IllegalStateException("Unexpected SortedNumericSelector type: " + (Object)((Object)snsf.getNumericType()));
                        output.writeByte((byte)3);
                    }
                    if (snsf.getSelector() == SortedNumericSelector.Type.MIN) {
                        output.writeByte((byte)0);
                    } else {
                        if (snsf.getSelector() != SortedNumericSelector.Type.MAX) throw new IllegalStateException("Unexpected sorted numeric selector type: " + (Object)((Object)snsf.getSelector()));
                        output.writeByte((byte)1);
                    }
                }
                output.writeByte((byte)(!sortField.getReverse() ? 1 : 0));
                Object missingValue = sortField.getMissingValue();
                if (missingValue == null) {
                    output.writeByte((byte)0);
                    continue;
                }
                switch (sortType) {
                    case STRING: {
                        if (missingValue == SortField.STRING_LAST) {
                            output.writeByte((byte)1);
                            continue block25;
                        }
                        if (missingValue != SortField.STRING_FIRST) throw new AssertionError((Object)("unrecognized missing value for STRING field \"" + sortField.getField() + "\": " + missingValue));
                        output.writeByte((byte)2);
                        continue block25;
                    }
                    case LONG: {
                        output.writeByte((byte)1);
                        output.writeLong((Long)missingValue);
                        continue block25;
                    }
                    case INT: {
                        output.writeByte((byte)1);
                        output.writeInt((Integer)missingValue);
                        continue block25;
                    }
                    case DOUBLE: {
                        output.writeByte((byte)1);
                        output.writeLong(Double.doubleToLongBits((Double)missingValue));
                        continue block25;
                    }
                    case FLOAT: {
                        output.writeByte((byte)1);
                        output.writeInt(Float.floatToIntBits(((Float)missingValue).floatValue()));
                        continue block25;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected sort type: " + (Object)((Object)sortField.getType()));
                    }
                }
            }
            CodecUtil.writeFooter(output);
            return;
        }
    }
}

