/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math3.exception.NoBracketingException;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Precision;

public class BrentSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public BrentSolver() {
        this(1.0E-6);
    }

    public BrentSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    public BrentSolver(double relativeAccuracy, double absoluteAccuracy, double functionValueAccuracy) {
        super(relativeAccuracy, absoluteAccuracy, functionValueAccuracy);
    }

    protected double doSolve() {
        double min2 = this.getMin();
        double max = this.getMax();
        double initial = this.getStartValue();
        double functionValueAccuracy = this.getFunctionValueAccuracy();
        this.verifySequence(min2, initial, max);
        double yInitial = this.computeObjectiveValue(initial);
        if (FastMath.abs(yInitial) <= functionValueAccuracy) {
            return initial;
        }
        double yMin = this.computeObjectiveValue(min2);
        if (FastMath.abs(yMin) <= functionValueAccuracy) {
            return min2;
        }
        if (yInitial * yMin < 0.0) {
            return this.brent(min2, initial, yMin, yInitial);
        }
        double yMax = this.computeObjectiveValue(max);
        if (FastMath.abs(yMax) <= functionValueAccuracy) {
            return max;
        }
        if (yInitial * yMax < 0.0) {
            return this.brent(initial, max, yInitial, yMax);
        }
        throw new NoBracketingException(min2, max, yMin, yMax);
    }

    private double brent(double lo, double hi, double fLo, double fHi) {
        double d;
        double a = lo;
        double fa = fLo;
        double b = hi;
        double fb = fHi;
        double c = a;
        double fc = fa;
        double e = d = b - a;
        double t = this.getAbsoluteAccuracy();
        double eps = this.getRelativeAccuracy();
        while (true) {
            if (FastMath.abs(fc) < FastMath.abs(fb)) {
                a = b;
                b = c;
                c = a;
                fa = fb;
                fb = fc;
                fc = fa;
            }
            double tol = 2.0 * eps * FastMath.abs(b) + t;
            double m3 = 0.5 * (c - b);
            if (FastMath.abs(m3) <= tol || Precision.equals(fb, 0.0)) {
                return b;
            }
            if (FastMath.abs(e) < tol || FastMath.abs(fa) <= FastMath.abs(fb)) {
                e = d = m3;
            } else {
                double q;
                double p;
                double s2 = fb / fa;
                if (a == c) {
                    p = 2.0 * m3 * s2;
                    q = 1.0 - s2;
                } else {
                    q = fa / fc;
                    double r = fb / fc;
                    p = s2 * (2.0 * m3 * q * (q - r) - (b - a) * (r - 1.0));
                    q = (q - 1.0) * (r - 1.0) * (s2 - 1.0);
                }
                if (p > 0.0) {
                    q = -q;
                } else {
                    p = -p;
                }
                s2 = e;
                e = d;
                if (p >= 1.5 * m3 * q - FastMath.abs(tol * q) || p >= FastMath.abs(0.5 * s2 * q)) {
                    e = d = m3;
                } else {
                    d = p / q;
                }
            }
            a = b;
            fa = fb;
            b = FastMath.abs(d) > tol ? (b += d) : (m3 > 0.0 ? (b += tol) : (b -= tol));
            fb = this.computeObjectiveValue(b);
            if (!(fb > 0.0 && fc > 0.0) && (!(fb <= 0.0) || !(fc <= 0.0))) continue;
            c = a;
            fc = fa;
            e = d = b - a;
        }
    }
}

