/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.solvers;

import org.apache.commons.math3.analysis.solvers.AbstractUnivariateSolver;
import org.apache.commons.math3.analysis.solvers.UnivariateSolverUtils;
import org.apache.commons.math3.util.FastMath;

public class BisectionSolver
extends AbstractUnivariateSolver {
    private static final double DEFAULT_ABSOLUTE_ACCURACY = 1.0E-6;

    public BisectionSolver() {
        this(1.0E-6);
    }

    public BisectionSolver(double absoluteAccuracy) {
        super(absoluteAccuracy);
    }

    public BisectionSolver(double relativeAccuracy, double absoluteAccuracy) {
        super(relativeAccuracy, absoluteAccuracy);
    }

    protected double doSolve() {
        double m3;
        double min2 = this.getMin();
        double max = this.getMax();
        this.verifyInterval(min2, max);
        double absoluteAccuracy = this.getAbsoluteAccuracy();
        do {
            m3 = UnivariateSolverUtils.midpoint(min2, max);
            double fmin = this.computeObjectiveValue(min2);
            double fm = this.computeObjectiveValue(m3);
            if (fm * fmin > 0.0) {
                min2 = m3;
                continue;
            }
            max = m3;
        } while (!(FastMath.abs(max - min2) <= absoluteAccuracy));
        m3 = UnivariateSolverUtils.midpoint(min2, max);
        return m3;
    }
}

