/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.function;

import org.apache.commons.math3.analysis.DifferentiableUnivariateFunction;
import org.apache.commons.math3.analysis.ParametricUnivariateFunction;
import org.apache.commons.math3.analysis.UnivariateFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NotStrictlyPositiveException;
import org.apache.commons.math3.exception.NullArgumentException;
import org.apache.commons.math3.util.FastMath;

public class Gaussian
implements DifferentiableUnivariateFunction {
    private final double mean;
    private final double i2s2;
    private final double norm;

    public Gaussian(double norm, double mean, double sigma) {
        if (sigma <= 0.0) {
            throw new NotStrictlyPositiveException(sigma);
        }
        this.norm = norm;
        this.mean = mean;
        this.i2s2 = 1.0 / (2.0 * sigma * sigma);
    }

    public Gaussian(double mean, double sigma) {
        this(1.0 / (sigma * FastMath.sqrt(Math.PI * 2)), mean, sigma);
    }

    public Gaussian() {
        this(0.0, 1.0);
    }

    public double value(double x) {
        return Gaussian.value(x - this.mean, this.norm, this.i2s2);
    }

    public UnivariateFunction derivative() {
        return new UnivariateFunction(){

            public double value(double x) {
                double diff = x - Gaussian.this.mean;
                double g2 = Gaussian.value(diff, Gaussian.this.norm, Gaussian.this.i2s2);
                if (g2 == 0.0) {
                    return 0.0;
                }
                return -2.0 * diff * Gaussian.this.i2s2 * g2;
            }
        };
    }

    private static double value(double xMinusMean, double norm, double i2s2) {
        return norm * FastMath.exp(-xMinusMean * xMinusMean * i2s2);
    }

    public static class Parametric
    implements ParametricUnivariateFunction {
        public double value(double x, double ... param) {
            this.validateParameters(param);
            double diff = x - param[1];
            double i2s2 = 1.0 / (2.0 * param[2] * param[2]);
            return Gaussian.value(diff, param[0], i2s2);
        }

        public double[] gradient(double x, double ... param) {
            this.validateParameters(param);
            double norm = param[0];
            double diff = x - param[1];
            double sigma = param[2];
            double i2s2 = 1.0 / (2.0 * sigma * sigma);
            double n = Gaussian.value(diff, 1.0, i2s2);
            double m3 = norm * n * 2.0 * i2s2 * diff;
            double s2 = m3 * diff / sigma;
            return new double[]{n, m3, s2};
        }

        private void validateParameters(double[] param) {
            if (param == null) {
                throw new NullArgumentException();
            }
            if (param.length != 3) {
                throw new DimensionMismatchException(param.length, 3);
            }
            if (param[2] <= 0.0) {
                throw new NotStrictlyPositiveException(param[2]);
            }
        }
    }
}

