/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.generate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.VertexFactory;
import org._3pq.jgrapht.generate.GraphGenerator;
import org._3pq.jgrapht.generate.RingGraphGenerator;

public class WheelGraphGenerator
implements GraphGenerator {
    public static final String HUB_VERTEX = "Hub Vertex";
    private boolean m_inwardSpokes;
    private int m_size;

    public WheelGraphGenerator(int n) {
        this(n, true);
    }

    public WheelGraphGenerator(int n, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("must be non-negative");
        }
        this.m_size = n;
        this.m_inwardSpokes = bl;
    }

    public void generateGraph(Graph graph, final VertexFactory vertexFactory, Map map) {
        if (this.m_size < 1) {
            return;
        }
        final ArrayList arrayList2 = new ArrayList();
        VertexFactory vertexFactory2 = new VertexFactory(){

            public Object createVertex() {
                Object object = vertexFactory.createVertex();
                arrayList2.add(object);
                return object;
            }
        };
        RingGraphGenerator ringGraphGenerator = new RingGraphGenerator(this.m_size - 1);
        ringGraphGenerator.generateGraph(graph, vertexFactory2, map);
        Object object = vertexFactory.createVertex();
        graph.addVertex(object);
        if (map != null) {
            map.put(HUB_VERTEX, object);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.m_inwardSpokes) {
                graph.addEdge(e, object);
                continue;
            }
            graph.addEdge(object, e);
        }
    }
}

