/*
 * Decompiled with CFR 0.152.
 */
package org._3pq.jgrapht.ext;

import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.border.Border;
import javax.swing.tree.MutableTreeNode;
import org._3pq.jgrapht.DirectedGraph;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.EdgeFactory;
import org._3pq.jgrapht.Graph;
import org._3pq.jgrapht.ListenableGraph;
import org._3pq.jgrapht.event.GraphEdgeChangeEvent;
import org._3pq.jgrapht.event.GraphListener;
import org._3pq.jgrapht.event.GraphVertexChangeEvent;
import org.jgraph.event.GraphModelEvent;
import org.jgraph.event.GraphModelListener;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.ConnectionSet;
import org.jgraph.graph.DefaultEdge;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.DefaultGraphModel;
import org.jgraph.graph.DefaultPort;
import org.jgraph.graph.GraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgraph.graph.Port;

public class JGraphModelAdapter
extends DefaultGraphModel {
    private static final long serialVersionUID = 3256722883706302515L;
    final Set m_jCellsBeingAdded = new HashSet();
    final Set m_jCellsBeingRemoved = new HashSet();
    final Set m_jtElementsBeingAdded = new HashSet();
    final Set m_jtElementsBeingRemoved = new HashSet();
    private final CellFactory m_cellFactory;
    private final Map m_cellToEdge = new HashMap();
    private final Map m_cellToVertex = new HashMap();
    private AttributeMap m_defaultEdgeAttributes;
    private AttributeMap m_defaultVertexAttributes;
    private final Map m_edgeToCell = new HashMap();
    private final Map m_vertexToCell = new HashMap();
    private final ShieldedGraph m_jtGraph;

    public JGraphModelAdapter(Graph graph) {
        this(graph, JGraphModelAdapter.createDefaultVertexAttributes(), JGraphModelAdapter.createDefaultEdgeAttributes(graph));
    }

    public JGraphModelAdapter(Graph graph, AttributeMap attributeMap, AttributeMap attributeMap2) {
        this(graph, attributeMap, attributeMap2, new DefaultCellFactory());
    }

    public JGraphModelAdapter(Graph graph, AttributeMap attributeMap, AttributeMap attributeMap2, CellFactory cellFactory) {
        Iterator iterator;
        if (graph == null || attributeMap == null || attributeMap2 == null || cellFactory == null) {
            throw new IllegalArgumentException("null is NOT permitted");
        }
        this.m_jtGraph = new ShieldedGraph(graph);
        this.setDefaultVertexAttributes(attributeMap);
        this.setDefaultEdgeAttributes(attributeMap2);
        this.m_cellFactory = cellFactory;
        if (graph instanceof ListenableGraph) {
            iterator = (ListenableGraph)graph;
            iterator.addGraphListener(new JGraphTListener());
        }
        iterator = graph.vertexSet().iterator();
        while (iterator.hasNext()) {
            this.handleJGraphTAddedVertex(iterator.next());
        }
        iterator = graph.edgeSet().iterator();
        while (iterator.hasNext()) {
            this.handleJGraphTAddedEdge((Edge)iterator.next());
        }
        this.addGraphModelListener(new JGraphListener());
    }

    public static AttributeMap createDefaultEdgeAttributes(Graph graph) {
        AttributeMap attributeMap = new AttributeMap();
        if (graph instanceof DirectedGraph) {
            GraphConstants.setLineEnd((Map)attributeMap, (int)2);
            GraphConstants.setEndFill((Map)attributeMap, (boolean)true);
            GraphConstants.setEndSize((Map)attributeMap, (int)10);
        }
        GraphConstants.setForeground((Map)attributeMap, (Color)Color.decode("#25507C"));
        GraphConstants.setFont((Map)attributeMap, (Font)GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        GraphConstants.setLineColor((Map)attributeMap, (Color)Color.decode("#7AA1E6"));
        return attributeMap;
    }

    public static AttributeMap createDefaultVertexAttributes() {
        AttributeMap attributeMap = new AttributeMap();
        Color color = Color.decode("#FF9900");
        GraphConstants.setBounds((Map)attributeMap, (Rectangle2D)new Rectangle2D.Double(50.0, 50.0, 90.0, 30.0));
        GraphConstants.setBorder((Map)attributeMap, (Border)BorderFactory.createRaisedBevelBorder());
        GraphConstants.setBackground((Map)attributeMap, (Color)color);
        GraphConstants.setForeground((Map)attributeMap, (Color)Color.white);
        GraphConstants.setFont((Map)attributeMap, (Font)GraphConstants.DEFAULTFONT.deriveFont(1, 12.0f));
        GraphConstants.setOpaque((Map)attributeMap, (boolean)true);
        return attributeMap;
    }

    public CellFactory getCellFactory() {
        return this.m_cellFactory;
    }

    public void setDefaultEdgeAttributes(AttributeMap attributeMap) {
        this.m_defaultEdgeAttributes = attributeMap;
    }

    public AttributeMap getDefaultEdgeAttributes() {
        return this.m_defaultEdgeAttributes;
    }

    public void setDefaultVertexAttributes(AttributeMap attributeMap) {
        this.m_defaultVertexAttributes = attributeMap;
    }

    public AttributeMap getDefaultVertexAttributes() {
        return this.m_defaultVertexAttributes;
    }

    public DefaultEdge getEdgeCell(Edge edge) {
        return (DefaultEdge)this.m_edgeToCell.get(edge);
    }

    public DefaultGraphCell getVertexCell(Object object) {
        return (DefaultGraphCell)this.m_vertexToCell.get(object);
    }

    public DefaultPort getVertexPort(Object object) {
        DefaultGraphCell defaultGraphCell = this.getVertexCell(object);
        if (defaultGraphCell == null) {
            return null;
        }
        return (DefaultPort)defaultGraphCell.getChildAt(0);
    }

    public void edit(Map map) {
        this.edit(map, null, null, null);
    }

    void handleJGraphChangedEdge(org.jgraph.graph.Edge edge) {
        if (this.isDangling(edge)) {
            if (this.m_cellToEdge.containsKey(edge)) {
                this.handleJGraphRemovedEdge(edge);
            }
        } else if (this.m_cellToEdge.containsKey(edge)) {
            Edge edge2 = (Edge)this.m_cellToEdge.get(edge);
            Object object = JGraphModelAdapter.getSourceVertex((GraphModel)this, (Object)edge);
            Object object2 = JGraphModelAdapter.getTargetVertex((GraphModel)this, (Object)edge);
            Object v = this.m_cellToVertex.get(object);
            Object v2 = this.m_cellToVertex.get(object2);
            if (edge2.getSource() != v || edge2.getTarget() != v2) {
                this.handleJGraphRemovedEdge(edge);
                this.handleJGraphInsertedEdge(edge);
            }
        } else {
            this.handleJGraphInsertedEdge(edge);
        }
    }

    void handleJGraphInsertedEdge(org.jgraph.graph.Edge edge) {
        if (!this.isDangling(edge)) {
            Object object = JGraphModelAdapter.getSourceVertex((GraphModel)this, (Object)edge);
            Object object2 = JGraphModelAdapter.getTargetVertex((GraphModel)this, (Object)edge);
            Object v = this.m_cellToVertex.get(object);
            Object v2 = this.m_cellToVertex.get(object2);
            Edge edge2 = this.m_jtGraph.getEdgeFactory().createEdge(v, v2);
            boolean bl = this.m_jtGraph.addEdge(edge2);
            if (bl) {
                this.m_cellToEdge.put(edge, edge2);
                this.m_edgeToCell.put(edge2, edge);
            } else {
                this.internalRemoveCell((GraphCell)edge);
                System.err.println("Warning: an edge was deleted because the underlying JGraphT graph refused to create it. This situation can happen when a constraint of the underlying graph is violated, e.g., an attempt to add a parallel edge or a self-loop to a graph that forbids them. To avoid this message, make sure to use a suitable underlying JGraphT graph.");
            }
        }
    }

    void handleJGraphInsertedVertex(GraphCell graphCell) {
        Object object = graphCell instanceof DefaultGraphCell ? ((DefaultGraphCell)graphCell).getUserObject() : graphCell.toString();
        if (this.m_vertexToCell.containsKey(object)) {
            System.err.println("Warning: detected two JGraph vertices with the same JGraphT vertex as user object. It is an indication for a faulty situation that should NOT happen.Removing vertex: " + graphCell);
            this.internalRemoveCell(graphCell);
        } else {
            this.m_jtGraph.addVertex(object);
            this.m_cellToVertex.put(graphCell, object);
            this.m_vertexToCell.put(object, graphCell);
        }
    }

    void handleJGraphRemovedEdge(org.jgraph.graph.Edge edge) {
        if (this.m_cellToEdge.containsKey(edge)) {
            Edge edge2 = (Edge)this.m_cellToEdge.get(edge);
            this.m_jtGraph.removeEdge(edge2);
            this.m_cellToEdge.remove(edge);
            this.m_edgeToCell.remove(edge2);
        }
    }

    void handleJGraphRemovedVertex(GraphCell graphCell) {
        if (this.m_cellToVertex.containsKey(graphCell)) {
            Object v = this.m_cellToVertex.get(graphCell);
            List list = this.m_jtGraph.edgesOf(v);
            if (!list.isEmpty()) {
                this.m_jtGraph.removeAllEdges(new ArrayList(list));
            }
            this.m_jtGraph.removeVertex(v);
            this.m_cellToVertex.remove(graphCell);
            this.m_vertexToCell.remove(v);
        }
    }

    void handleJGraphTAddedEdge(Edge edge) {
        DefaultEdge defaultEdge = this.m_cellFactory.createEdgeCell(edge);
        this.m_edgeToCell.put(edge, defaultEdge);
        this.m_cellToEdge.put(defaultEdge, edge);
        ConnectionSet connectionSet = new ConnectionSet();
        connectionSet.connect((Object)defaultEdge, (Object)this.getVertexPort(edge.getSource()), (Object)this.getVertexPort(edge.getTarget()));
        this.internalInsertCell((GraphCell)defaultEdge, this.createEdgeAttributeMap(defaultEdge), connectionSet);
    }

    void handleJGraphTAddedVertex(Object object) {
        DefaultGraphCell defaultGraphCell = this.m_cellFactory.createVertexCell(object);
        defaultGraphCell.add((MutableTreeNode)new DefaultPort());
        this.m_vertexToCell.put(object, defaultGraphCell);
        this.m_cellToVertex.put(defaultGraphCell, object);
        this.internalInsertCell((GraphCell)defaultGraphCell, this.createVertexAttributeMap((GraphCell)defaultGraphCell), null);
    }

    void handleJGraphTRemoveVertex(Object object) {
        DefaultGraphCell defaultGraphCell = (DefaultGraphCell)this.m_vertexToCell.remove(object);
        this.m_cellToVertex.remove(defaultGraphCell);
        this.internalRemoveCell((GraphCell)defaultGraphCell);
        if (defaultGraphCell.getChildCount() > 0) {
            this.remove(new Object[]{defaultGraphCell.getChildAt(0)});
        }
    }

    void handleJGraphTRemovedEdge(Edge edge) {
        DefaultEdge defaultEdge = (DefaultEdge)this.m_edgeToCell.remove(edge);
        this.m_cellToEdge.remove(defaultEdge);
        this.internalRemoveCell((GraphCell)defaultEdge);
    }

    private boolean isDangling(org.jgraph.graph.Edge edge) {
        Object object = JGraphModelAdapter.getSourceVertex((GraphModel)this, (Object)edge);
        Object object2 = JGraphModelAdapter.getTargetVertex((GraphModel)this, (Object)edge);
        return !this.m_cellToVertex.containsKey(object) || !this.m_cellToVertex.containsKey(object2);
    }

    private AttributeMap createEdgeAttributeMap(DefaultEdge defaultEdge) {
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.put((Object)defaultEdge, this.getDefaultEdgeAttributes().clone());
        return attributeMap;
    }

    private AttributeMap createVertexAttributeMap(GraphCell graphCell) {
        AttributeMap attributeMap = new AttributeMap();
        attributeMap.put((Object)graphCell, this.getDefaultVertexAttributes().clone());
        return attributeMap;
    }

    private void internalInsertCell(GraphCell graphCell, AttributeMap attributeMap, ConnectionSet connectionSet) {
        this.m_jCellsBeingAdded.add(graphCell);
        this.insert(new Object[]{graphCell}, (Map)attributeMap, connectionSet, null, null);
        this.m_jCellsBeingAdded.remove(graphCell);
    }

    private void internalRemoveCell(GraphCell graphCell) {
        this.m_jCellsBeingRemoved.add(graphCell);
        this.remove(new Object[]{graphCell});
        this.m_jCellsBeingRemoved.remove(graphCell);
    }

    private class ShieldedGraph {
        private final Graph m_graph;

        ShieldedGraph(Graph graph) {
            this.m_graph = graph;
        }

        EdgeFactory getEdgeFactory() {
            return this.m_graph.getEdgeFactory();
        }

        boolean addEdge(Edge edge) {
            JGraphModelAdapter.this.m_jtElementsBeingAdded.add(edge);
            boolean bl = this.m_graph.addEdge(edge);
            JGraphModelAdapter.this.m_jtElementsBeingAdded.remove(edge);
            return bl;
        }

        void addVertex(Object object) {
            JGraphModelAdapter.this.m_jtElementsBeingAdded.add(object);
            this.m_graph.addVertex(object);
            JGraphModelAdapter.this.m_jtElementsBeingAdded.remove(object);
        }

        List edgesOf(Object object) {
            return this.m_graph.edgesOf(object);
        }

        boolean removeAllEdges(Collection collection) {
            return this.m_graph.removeAllEdges(collection);
        }

        void removeEdge(Edge edge) {
            JGraphModelAdapter.this.m_jtElementsBeingRemoved.add(edge);
            this.m_graph.removeEdge(edge);
            JGraphModelAdapter.this.m_jtElementsBeingRemoved.remove(edge);
        }

        void removeVertex(Object object) {
            JGraphModelAdapter.this.m_jtElementsBeingRemoved.add(object);
            this.m_graph.removeVertex(object);
            JGraphModelAdapter.this.m_jtElementsBeingRemoved.remove(object);
        }
    }

    private class JGraphTListener
    implements GraphListener,
    Serializable {
        private static final long serialVersionUID = 3616724963609360440L;

        private JGraphTListener() {
        }

        public void edgeAdded(GraphEdgeChangeEvent graphEdgeChangeEvent) {
            Edge edge = graphEdgeChangeEvent.getEdge();
            if (!JGraphModelAdapter.this.m_jtElementsBeingAdded.remove(edge)) {
                JGraphModelAdapter.this.handleJGraphTAddedEdge(edge);
            }
        }

        public void edgeRemoved(GraphEdgeChangeEvent graphEdgeChangeEvent) {
            Edge edge = graphEdgeChangeEvent.getEdge();
            if (!JGraphModelAdapter.this.m_jtElementsBeingRemoved.remove(edge)) {
                JGraphModelAdapter.this.handleJGraphTRemovedEdge(edge);
            }
        }

        public void vertexAdded(GraphVertexChangeEvent graphVertexChangeEvent) {
            Object object = graphVertexChangeEvent.getVertex();
            if (!JGraphModelAdapter.this.m_jtElementsBeingAdded.remove(object)) {
                JGraphModelAdapter.this.handleJGraphTAddedVertex(object);
            }
        }

        public void vertexRemoved(GraphVertexChangeEvent graphVertexChangeEvent) {
            Object object = graphVertexChangeEvent.getVertex();
            if (!JGraphModelAdapter.this.m_jtElementsBeingRemoved.remove(object)) {
                JGraphModelAdapter.this.handleJGraphTRemoveVertex(object);
            }
        }
    }

    private class JGraphListener
    implements GraphModelListener,
    Serializable {
        private static final long serialVersionUID = 3544673988098865209L;

        private JGraphListener() {
        }

        public void graphChanged(GraphModelEvent graphModelEvent) {
            Object[] objectArray;
            Object[] objectArray2;
            GraphModelEvent.GraphModelChange graphModelChange = graphModelEvent.getChange();
            Object[] objectArray3 = graphModelChange.getRemoved();
            if (objectArray3 != null) {
                this.handleRemovedEdges(this.filterEdges(objectArray3));
                this.handleRemovedVertices(this.filterVertices(objectArray3));
            }
            if ((objectArray2 = graphModelChange.getInserted()) != null) {
                this.handleInsertedVertices(this.filterVertices(objectArray2));
                this.handleInsertedEdges(this.filterEdges(objectArray2));
            }
            if ((objectArray = graphModelChange.getChanged()) != null) {
                this.handleChangedEdges(this.filterEdges(objectArray));
            }
        }

        private List filterEdges(Object[] objectArray) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof org.jgraph.graph.Edge)) continue;
                arrayList2.add(objectArray[i]);
            }
            return arrayList2;
        }

        private List filterVertices(Object[] objectArray) {
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (object instanceof org.jgraph.graph.Edge || object instanceof Port) continue;
                if (object instanceof DefaultGraphCell) {
                    DefaultGraphCell defaultGraphCell = (DefaultGraphCell)object;
                    if (!defaultGraphCell.isLeaf() && !(defaultGraphCell.getFirstChild() instanceof Port)) continue;
                    arrayList2.add(object);
                    continue;
                }
                if (!(object instanceof GraphCell)) continue;
                arrayList2.add(object);
            }
            return arrayList2;
        }

        private void handleChangedEdges(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                org.jgraph.graph.Edge edge = (org.jgraph.graph.Edge)iterator.next();
                JGraphModelAdapter.this.handleJGraphChangedEdge(edge);
            }
        }

        private void handleInsertedEdges(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                org.jgraph.graph.Edge edge = (org.jgraph.graph.Edge)iterator.next();
                if (JGraphModelAdapter.this.m_jCellsBeingAdded.remove(edge)) continue;
                JGraphModelAdapter.this.handleJGraphInsertedEdge(edge);
            }
        }

        private void handleInsertedVertices(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                GraphCell graphCell = (GraphCell)iterator.next();
                if (JGraphModelAdapter.this.m_jCellsBeingAdded.remove(graphCell)) continue;
                JGraphModelAdapter.this.handleJGraphInsertedVertex(graphCell);
            }
        }

        private void handleRemovedEdges(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                org.jgraph.graph.Edge edge = (org.jgraph.graph.Edge)iterator.next();
                if (JGraphModelAdapter.this.m_jCellsBeingRemoved.remove(edge)) continue;
                JGraphModelAdapter.this.handleJGraphRemovedEdge(edge);
            }
        }

        private void handleRemovedVertices(List list) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                GraphCell graphCell = (GraphCell)iterator.next();
                if (JGraphModelAdapter.this.m_jCellsBeingRemoved.remove(graphCell)) continue;
                JGraphModelAdapter.this.handleJGraphRemovedVertex(graphCell);
            }
        }
    }

    public static class DefaultCellFactory
    implements CellFactory,
    Serializable {
        private static final long serialVersionUID = 3690194343461861173L;

        public DefaultEdge createEdgeCell(Edge edge) {
            return new DefaultEdge((Object)edge);
        }

        public DefaultGraphCell createVertexCell(Object object) {
            return new DefaultGraphCell(object);
        }
    }

    public static interface CellFactory {
        public DefaultEdge createEdgeCell(Edge var1);

        public DefaultGraphCell createVertexCell(Object var1);
    }
}

