/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.Preconditioner;

public class DiagonalPreconditioner
implements Preconditioner {
    private double[] invdiag;

    public DiagonalPreconditioner(int n) {
        this.invdiag = new double[n];
    }

    @Override
    public Vector apply(Vector b, Vector x) {
        if (!(x instanceof DenseVector) || !(b instanceof DenseVector)) {
            throw new IllegalArgumentException("Vector must be DenseVectors");
        }
        double[] xd = ((DenseVector)x).getData();
        double[] bd = ((DenseVector)b).getData();
        for (int i = 0; i < this.invdiag.length; ++i) {
            xd[i] = bd[i] * this.invdiag[i];
        }
        return x;
    }

    @Override
    public Vector transApply(Vector b, Vector x) {
        return this.apply(b, x);
    }

    @Override
    public void setMatrix(Matrix A2) {
        if (A2.numRows() != this.invdiag.length) {
            throw new IllegalArgumentException("Matrix size differs from preconditioner size");
        }
        for (int i = 0; i < this.invdiag.length; ++i) {
            this.invdiag[i] = A2.get(i, i);
            if (this.invdiag[i] == 0.0) {
                throw new RuntimeException("Zero diagonal on row " + (i + 1));
            }
            this.invdiag[i] = 1.0 / this.invdiag[i];
        }
    }
}

