/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import no.uib.cipr.matrix.sparse.Arrays;

public class CompRowMatrix
extends AbstractMatrix {
    double[] data;
    int[] columnIndex;
    int[] rowPointer;

    public CompRowMatrix(MatrixVectorReader r) throws IOException {
        block13: {
            int i;
            double[] entry;
            int[] column;
            int[] row;
            int numEntries;
            MatrixInfo info;
            block12: {
                int i2;
                super(0, 0);
                info = null;
                info = r.hasInfo() ? r.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isDense()) {
                    throw new UnsupportedOperationException("Dense matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                MatrixSize size = r.readMatrixSize(info);
                this.numRows = size.numRows();
                this.numColumns = size.numColumns();
                numEntries = size.numEntries();
                row = new int[numEntries];
                column = new int[numEntries];
                entry = new double[numEntries];
                r.readCoordinate(row, column, entry);
                r.add(-1, row);
                r.add(-1, column);
                ArrayList rnz = new ArrayList(this.numRows);
                for (i2 = 0; i2 < this.numRows; ++i2) {
                    rnz.add(new HashSet());
                }
                for (i2 = 0; i2 < numEntries; ++i2) {
                    ((Set)rnz.get(row[i2])).add(column[i2]);
                }
                if (info.isSymmetric() || info.isSkewSymmetric()) {
                    for (i2 = 0; i2 < numEntries; ++i2) {
                        if (row[i2] == column[i2]) continue;
                        ((Set)rnz.get(column[i2])).add(row[i2]);
                    }
                }
                int[][] nz = new int[this.numRows][];
                for (i = 0; i < this.numRows; ++i) {
                    nz[i] = new int[((Set)rnz.get(i)).size()];
                    int j = 0;
                    for (Integer colind : (Set)rnz.get(i)) {
                        nz[i][j++] = colind;
                    }
                }
                this.construct(nz);
                for (i = 0; i < size.numEntries(); ++i) {
                    this.set(row[i], column[i], entry[i]);
                }
                if (!info.isSymmetric()) break block12;
                for (i = 0; i < numEntries; ++i) {
                    if (row[i] == column[i]) continue;
                    this.set(column[i], row[i], entry[i]);
                }
                break block13;
            }
            if (!info.isSkewSymmetric()) break block13;
            for (i = 0; i < numEntries; ++i) {
                if (row[i] == column[i]) continue;
                this.set(column[i], row[i], -entry[i]);
            }
        }
    }

    public CompRowMatrix(int numRows, int numColumns, int[][] nz) {
        super(numRows, numColumns);
        this.construct(nz);
    }

    private void construct(int[][] nz) {
        int i;
        int nnz = 0;
        for (i = 0; i < nz.length; ++i) {
            nnz += nz[i].length;
        }
        this.rowPointer = new int[this.numRows + 1];
        this.columnIndex = new int[nnz];
        this.data = new double[nnz];
        if (nz.length != this.numRows) {
            throw new IllegalArgumentException("nz.length != numRows");
        }
        for (i = 1; i <= this.numRows; ++i) {
            this.rowPointer[i] = this.rowPointer[i - 1] + nz[i - 1].length;
            int j = this.rowPointer[i - 1];
            int k = 0;
            while (j < this.rowPointer[i]) {
                this.columnIndex[j] = nz[i - 1][k];
                if (nz[i - 1][k] < 0 || nz[i - 1][k] >= this.numColumns) {
                    throw new IllegalArgumentException("nz[" + (i - 1) + "][" + k + "]=" + nz[i - 1][k] + ", which is not a valid column index");
                }
                ++j;
                ++k;
            }
            java.util.Arrays.sort(this.columnIndex, this.rowPointer[i - 1], this.rowPointer[i]);
        }
    }

    private void construct(Matrix A2, boolean deep) {
        if (deep) {
            if (A2 instanceof CompRowMatrix) {
                CompRowMatrix Ac = (CompRowMatrix)A2;
                this.data = new double[Ac.data.length];
                this.columnIndex = new int[Ac.columnIndex.length];
                this.rowPointer = new int[Ac.rowPointer.length];
                System.arraycopy(Ac.data, 0, this.data, 0, this.data.length);
                System.arraycopy(Ac.columnIndex, 0, this.columnIndex, 0, this.columnIndex.length);
                System.arraycopy(Ac.rowPointer, 0, this.rowPointer, 0, this.rowPointer.length);
            } else {
                ArrayList rnz = new ArrayList(this.numRows);
                for (int i = 0; i < this.numRows; ++i) {
                    rnz.add(new HashSet());
                }
                for (MatrixEntry e : A2) {
                    ((Set)rnz.get(e.row())).add(e.column());
                }
                int[][] nz = new int[this.numRows][];
                for (int i = 0; i < this.numRows; ++i) {
                    nz[i] = new int[((Set)rnz.get(i)).size()];
                    int j = 0;
                    for (Integer colind : (Set)rnz.get(i)) {
                        nz[i][j++] = colind;
                    }
                }
                this.construct(nz);
                this.set(A2);
            }
        } else {
            CompRowMatrix Ac = (CompRowMatrix)A2;
            this.columnIndex = Ac.getColumnIndices();
            this.rowPointer = Ac.getRowPointers();
            this.data = Ac.getData();
        }
    }

    public CompRowMatrix(Matrix A2, boolean deep) {
        super(A2);
        this.construct(A2, deep);
    }

    public CompRowMatrix(Matrix A2) {
        this(A2, true);
    }

    public int[] getColumnIndices() {
        return this.columnIndex;
    }

    public int[] getRowPointers() {
        return this.rowPointer;
    }

    public double[] getData() {
        return this.data;
    }

    @Override
    public Matrix mult(Matrix B2, Matrix C2) {
        this.checkMultAdd(B2, C2);
        C2.zero();
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < C2.numColumns(); ++j) {
                double dot = 0.0;
                for (int k = this.rowPointer[i]; k < this.rowPointer[i + 1]; ++k) {
                    dot += this.data[k] * B2.get(this.columnIndex[k], j);
                }
                if (dot == 0.0) continue;
                C2.set(i, j, dot);
            }
        }
        return C2;
    }

    @Override
    public Vector mult(Vector x, Vector y) {
        this.checkMultAdd(x, y);
        y.zero();
        if (x instanceof DenseVector) {
            double[] xd = ((DenseVector)x).getData();
            for (int i = 0; i < this.numRows; ++i) {
                double dot = 0.0;
                for (int j = this.rowPointer[i]; j < this.rowPointer[i + 1]; ++j) {
                    dot += this.data[j] * xd[this.columnIndex[j]];
                }
                if (dot == 0.0) continue;
                y.set(i, dot);
            }
            return y;
        }
        for (int i = 0; i < this.numRows; ++i) {
            double dot = 0.0;
            for (int j = this.rowPointer[i]; j < this.rowPointer[i + 1]; ++j) {
                dot += this.data[j] * x.get(this.columnIndex[j]);
            }
            y.set(i, dot);
        }
        return y;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        int i = 0;
        while (i < this.numRows) {
            double dot = 0.0;
            for (int j = this.rowPointer[i]; j < this.rowPointer[i + 1]; ++j) {
                dot += this.data[j] * xd[this.columnIndex[j]];
            }
            int n = i++;
            yd[n] = yd[n] + alpha * dot;
        }
        return y;
    }

    @Override
    public Vector transMult(Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMult(x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        y.zero();
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = this.rowPointer[i]; j < this.rowPointer[i + 1]; ++j) {
                int n = this.columnIndex[j];
                yd[n] = yd[n] + this.data[j] * xd[i];
            }
        }
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        y.scale(1.0 / alpha);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = this.rowPointer[i]; j < this.rowPointer[i + 1]; ++j) {
                int n = this.columnIndex[j];
                yd[n] = yd[n] + this.data[j] * xd[i];
            }
        }
        return y.scale(alpha);
    }

    @Override
    public void set(int row, int column, double value) {
        this.check(row, column);
        int index = this.getIndex(row, column);
        this.data[index] = value;
    }

    @Override
    public void add(int row, int column, double value) {
        int index;
        this.check(row, column);
        int n = index = this.getIndex(row, column);
        this.data[n] = this.data[n] + value;
    }

    @Override
    public double get(int row, int column) {
        this.check(row, column);
        int index = Arrays.binarySearch(this.columnIndex, column, this.rowPointer[row], this.rowPointer[row + 1]);
        if (index >= 0) {
            return this.data[index];
        }
        return 0.0;
    }

    private int getIndex(int row, int column) {
        int i = Arrays.binarySearch(this.columnIndex, column, this.rowPointer[row], this.rowPointer[row + 1]);
        if (i != -1 && this.columnIndex[i] == column) {
            return i;
        }
        throw new IndexOutOfBoundsException("Entry (" + (row + 1) + ", " + (column + 1) + ") is not in the matrix structure");
    }

    @Override
    public CompRowMatrix copy() {
        return new CompRowMatrix(this);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new CompRowMatrixIterator();
    }

    @Override
    public CompRowMatrix zero() {
        java.util.Arrays.fill(this.data, 0.0);
        return this;
    }

    @Override
    public Matrix set(Matrix B2) {
        if (!(B2 instanceof CompRowMatrix)) {
            return super.set(B2);
        }
        this.checkSize(B2);
        CompRowMatrix Bc = (CompRowMatrix)B2;
        if (Bc.columnIndex.length != this.columnIndex.length || Bc.rowPointer.length != this.rowPointer.length) {
            this.data = new double[Bc.data.length];
            this.columnIndex = new int[Bc.columnIndex.length];
            this.rowPointer = new int[Bc.rowPointer.length];
        }
        System.arraycopy(Bc.data, 0, this.data, 0, this.data.length);
        System.arraycopy(Bc.columnIndex, 0, this.columnIndex, 0, this.columnIndex.length);
        System.arraycopy(Bc.rowPointer, 0, this.rowPointer, 0, this.rowPointer.length);
        return this;
    }

    private class CompRowMatrixEntry
    implements MatrixEntry {
        private int row;
        private int cursor;

        private CompRowMatrixEntry() {
        }

        public void update(int row, int cursor) {
            this.row = row;
            this.cursor = cursor;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return CompRowMatrix.this.columnIndex[this.cursor];
        }

        @Override
        public double get() {
            return CompRowMatrix.this.data[this.cursor];
        }

        @Override
        public void set(double value) {
            CompRowMatrix.this.data[this.cursor] = value;
        }
    }

    private class CompRowMatrixIterator
    implements Iterator<MatrixEntry> {
        private int row;
        private int cursor;
        private CompRowMatrixEntry entry;

        public CompRowMatrixIterator() {
            this.entry = new CompRowMatrixEntry();
            this.nextNonEmptyRow();
        }

        private void nextNonEmptyRow() {
            while (this.row < CompRowMatrix.this.numRows() && CompRowMatrix.this.rowPointer[this.row] == CompRowMatrix.this.rowPointer[this.row + 1]) {
                ++this.row;
            }
            this.cursor = CompRowMatrix.this.rowPointer[this.row];
        }

        @Override
        public boolean hasNext() {
            return this.cursor < CompRowMatrix.this.data.length;
        }

        @Override
        public MatrixEntry next() {
            this.entry.update(this.row, this.cursor);
            if (this.cursor < CompRowMatrix.this.rowPointer[this.row + 1] - 1) {
                ++this.cursor;
            } else {
                ++this.row;
                this.nextNonEmptyRow();
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.entry.set(0.0);
        }
    }
}

