/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.AbstractIterativeSolver;
import no.uib.cipr.matrix.sparse.IterativeSolverNotConvergedException;

public class CGS
extends AbstractIterativeSolver {
    private Vector p;
    private Vector q;
    private Vector u;
    private Vector phat;
    private Vector qhat;
    private Vector vhat;
    private Vector uhat;
    private Vector sum;
    private Vector r;
    private Vector rtilde;

    public CGS(Vector template) {
        this.p = template.copy();
        this.q = template.copy();
        this.u = template.copy();
        this.phat = template.copy();
        this.qhat = template.copy();
        this.vhat = template.copy();
        this.uhat = template.copy();
        this.sum = template.copy();
        this.r = template.copy();
        this.rtilde = template.copy();
    }

    @Override
    public Vector solve(Matrix A2, Vector b, Vector x) throws IterativeSolverNotConvergedException {
        this.checkSizes(A2, b, x);
        double rho_1 = 0.0;
        double rho_2 = 0.0;
        double alpha = 0.0;
        double beta = 0.0;
        A2.multAdd(-1.0, x, this.r.set(b));
        this.rtilde.set(this.r);
        this.iter.setFirst();
        while (!this.iter.converged(this.r, x)) {
            rho_1 = this.rtilde.dot(this.r);
            if (rho_1 == 0.0) {
                throw new IterativeSolverNotConvergedException(NotConvergedException.Reason.Breakdown, "rho", this.iter);
            }
            if (this.iter.isFirst()) {
                this.u.set(this.r);
                this.p.set(this.u);
            } else {
                beta = rho_1 / rho_2;
                this.u.set(this.r).add(beta, this.q);
                this.sum.set(this.q).add(beta, this.p);
                this.p.set(this.u).add(beta, this.sum);
            }
            this.M.apply(this.p, this.phat);
            A2.mult(this.phat, this.vhat);
            alpha = rho_1 / this.rtilde.dot(this.vhat);
            this.q.set(-alpha, this.vhat).add(this.u);
            this.M.apply(this.sum.set(this.u).add(this.q), this.uhat);
            x.add(alpha, this.uhat);
            A2.mult(this.uhat, this.qhat);
            this.r.add(-alpha, this.qhat);
            rho_2 = rho_1;
            this.iter.next();
        }
        return x;
    }
}

