/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.sparse;

import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.sparse.DefaultIterationMonitor;
import no.uib.cipr.matrix.sparse.IterationMonitor;
import no.uib.cipr.matrix.sparse.IterativeSolver;
import no.uib.cipr.matrix.sparse.Preconditioner;

public abstract class AbstractIterativeSolver
implements IterativeSolver {
    protected Preconditioner M = new IdentityPreconditioner();
    protected IterationMonitor iter = new DefaultIterationMonitor();

    @Override
    public void setPreconditioner(Preconditioner M) {
        this.M = M;
    }

    @Override
    public Preconditioner getPreconditioner() {
        return this.M;
    }

    @Override
    public IterationMonitor getIterationMonitor() {
        return this.iter;
    }

    @Override
    public void setIterationMonitor(IterationMonitor iter) {
        this.iter = iter;
    }

    protected void checkSizes(Matrix A2, Vector b, Vector x) {
        if (!A2.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        if (b.size() != A2.numRows()) {
            throw new IllegalArgumentException("b.size() != A.numRows()");
        }
        if (b.size() != x.size()) {
            throw new IllegalArgumentException("b.size() != x.size()");
        }
    }

    private static class IdentityPreconditioner
    implements Preconditioner {
        private IdentityPreconditioner() {
        }

        @Override
        public Vector apply(Vector b, Vector x) {
            return x.set(b);
        }

        @Override
        public Vector transApply(Vector b, Vector x) {
            return x.set(b);
        }

        @Override
        public void setMatrix(Matrix A2) {
        }
    }
}

