/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed;

import java.util.Arrays;
import no.uib.cipr.matrix.DenseLU;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.distributed.BlockDiagonalPreconditioner;
import no.uib.cipr.matrix.distributed.Communicator;
import no.uib.cipr.matrix.distributed.DistColMatrix;
import no.uib.cipr.matrix.distributed.DistMatrix;
import no.uib.cipr.matrix.distributed.DistRowMatrix;
import no.uib.cipr.matrix.distributed.DistVector;
import no.uib.cipr.matrix.sparse.Preconditioner;

@Deprecated
public class TwoLevelPreconditioner
extends BlockDiagonalPreconditioner {
    private static final int root = 0;
    private final DistMatrix A;
    private final Communicator comm;
    private final int rank;
    private final int size;
    private final int[] indexToRank;
    private final DistVector z;
    private final DistVector r;
    private final DenseMatrix A0;
    private final DenseVector b0;
    private final DenseLU lu;
    private final double[] Ai;
    private final double[][] Ai0;
    private final boolean row;
    private final double[][] zi0;

    public TwoLevelPreconditioner(Preconditioner prec, DistRowMatrix A2, DistVector z) {
        super(prec);
        this.A = A2;
        this.z = z;
        this.r = z.copy();
        this.row = true;
        this.indexToRank = this.createIndexToRank(A2.numColumns(), A2.getColumnOwnerships());
        this.comm = A2.getCommunicator();
        this.rank = this.comm.rank();
        this.size = this.comm.size();
        this.A0 = new DenseMatrix(this.size, this.size);
        this.b0 = new DenseVector(this.size);
        this.lu = new DenseLU(this.size, this.size);
        this.Ai = new double[this.size];
        if (this.rank == 0) {
            this.Ai0 = new double[this.size][this.size];
            this.zi0 = new double[this.size][1];
        } else {
            this.Ai0 = null;
            this.zi0 = null;
        }
    }

    public TwoLevelPreconditioner(Preconditioner prec, DistColMatrix A2, DistVector z) {
        super(prec);
        this.A = A2;
        this.z = z;
        this.r = z.copy();
        this.row = false;
        this.indexToRank = this.createIndexToRank(A2.numColumns(), A2.getColumnOwnerships());
        this.comm = A2.getCommunicator();
        this.rank = this.comm.rank();
        this.size = this.comm.size();
        this.A0 = new DenseMatrix(this.size, this.size);
        this.b0 = new DenseVector(this.size);
        this.lu = new DenseLU(this.size, this.size);
        this.Ai = new double[this.size];
        if (this.rank == 0) {
            this.Ai0 = new double[this.size][this.size];
            this.zi0 = new double[this.size][1];
        } else {
            this.Ai0 = null;
            this.zi0 = null;
        }
    }

    private int[] createIndexToRank(int size, int[] n) {
        int[] indexToRank = new int[size];
        for (int i = 0; i < n.length - 1; ++i) {
            for (int j = n[i]; j < n[i + 1]; ++j) {
                indexToRank[j] = i;
            }
        }
        return indexToRank;
    }

    @Override
    public Vector apply(Vector b, Vector x) {
        if (!(b instanceof DistVector) || !(x instanceof DistVector)) {
            throw new IllegalArgumentException("Vectors must be DistVectors");
        }
        boolean transpose = false;
        return this.apply(b, x, transpose);
    }

    @Override
    public Vector transApply(Vector b, Vector x) {
        if (!(b instanceof DistVector) || !(x instanceof DistVector)) {
            throw new IllegalArgumentException("Vectors must be DistVectors");
        }
        boolean transpose = true;
        return this.apply(b, x, transpose);
    }

    private Vector apply(Vector b, Vector x, boolean transpose) {
        this.calculateCoarseResidual(b, x, transpose);
        if (this.rank == 0) {
            this.solveCoarseSystem(transpose);
        }
        this.updateWithCoarseCorrection(x);
        return this.applyBlockPreconditioner(b, x, transpose);
    }

    private void calculateCoarseResidual(Vector b, Vector x, boolean transpose) {
        if (transpose) {
            this.A.transMultAdd(-1.0, x, this.z.set(b));
        } else {
            this.A.multAdd(-1.0, x, this.z.set(b));
        }
        double zi = 0.0;
        for (VectorEntry e : this.z.getLocal()) {
            zi += e.get();
        }
        double[] zij = new double[]{zi};
        this.comm.gather(zij, (Object[])this.zi0, 0);
    }

    private void solveCoarseSystem(boolean transpose) {
        for (int i = 0; i < this.size; ++i) {
            this.b0.set(i, this.zi0[i][0]);
        }
        if (transpose) {
            this.lu.transSolve(new DenseMatrix(this.b0, false));
        } else {
            this.lu.solve(new DenseMatrix(this.b0, false));
        }
        double[] data = this.b0.getData();
        for (int i = 0; i < this.size; ++i) {
            this.zi0[i][0] = data[i];
        }
    }

    private void updateWithCoarseCorrection(Vector x) {
        DistVector xd = (DistVector)x;
        double[] zij = new double[1];
        this.comm.scatter((Object[])this.zi0, zij, 0);
        for (VectorEntry e : xd.getLocal()) {
            e.set(e.get() + zij[0]);
        }
    }

    private Vector applyBlockPreconditioner(Vector b, Vector x, boolean transpose) {
        if (transpose) {
            this.A.transMultAdd(-1.0, x, this.z.set(b));
        } else {
            this.A.multAdd(-1.0, x, this.z.set(b));
        }
        this.r.set(b);
        if (transpose) {
            super.transApply(this.z, this.r);
        } else {
            super.apply(this.z, this.r);
        }
        return x.add(this.r);
    }

    @Override
    public void setMatrix(Matrix A2) {
        if (!(A2 instanceof DistMatrix)) {
            throw new IllegalArgumentException("A is not a DistRowMatrix or a DistColMatrix");
        }
        Matrix Ad = this.A.getBlock();
        Matrix Ao = this.A.getOff();
        super.setMatrix(A2);
        Arrays.fill(this.Ai, 0.0);
        for (MatrixEntry e : Ad) {
            int n = this.rank;
            this.Ai[n] = this.Ai[n] + e.get();
        }
        if (this.row) {
            for (MatrixEntry e : Ao) {
                int n = this.indexToRank[e.column()];
                this.Ai[n] = this.Ai[n] + e.get();
            }
            this.comm.gather(this.Ai, (Object[])this.Ai0, 0);
            if (this.rank == 0) {
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        this.A0.set(i, j, this.Ai0[i][j]);
                    }
                }
            }
        } else {
            for (MatrixEntry e : Ao) {
                int n = this.indexToRank[e.row()];
                this.Ai[n] = this.Ai[n] + e.get();
            }
            this.comm.gather(this.Ai, (Object[])this.Ai0, 0);
            if (this.rank == 0) {
                for (int i = 0; i < this.size; ++i) {
                    for (int j = 0; j < this.size; ++j) {
                        this.A0.set(i, j, this.Ai0[j][i]);
                    }
                }
            }
        }
        if (this.rank == 0) {
            this.lu.factor(this.A0);
        }
    }
}

