/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix.distributed;

import java.util.Arrays;
import java.util.Iterator;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.distributed.Communicator;
import no.uib.cipr.matrix.distributed.Reductions;
import no.uib.cipr.matrix.distributed.SuperIterator;
import no.uib.cipr.matrix.distributed.VectorScatter;

@Deprecated
abstract class DistMatrix
extends AbstractMatrix {
    final Communicator comm;
    final Matrix A;
    final Matrix B;
    final int[] n;
    final int[] m;
    final int rank;
    final int size;
    final Vector locR;
    final Vector locC;
    final VectorScatter scatter;

    public DistMatrix(int numRows, int numColumns, Communicator comm, Matrix A2, Matrix B2) {
        super(numRows, numColumns);
        this.comm = comm;
        this.A = A2;
        this.B = B2;
        this.locR = new DenseVector(numRows);
        this.locC = new DenseVector(numColumns);
        this.rank = comm.rank();
        this.size = comm.size();
        this.n = new int[this.size + 1];
        this.m = new int[this.size + 1];
        int[] send = new int[]{A2.numRows(), A2.numColumns()};
        int[][] recv = new int[this.size][2];
        comm.allGather(send, (Object[])recv);
        for (int i = 0; i < this.size; ++i) {
            this.n[i + 1] = this.n[i] + recv[i][0];
            this.m[i + 1] = this.m[i] + recv[i][1];
        }
        if (this.n[this.size] != numRows) {
            throw new IllegalArgumentException("Sum of local row sizes (" + this.n[this.size] + ") do not match the global row size (" + numRows + ")");
        }
        if (this.m[this.size] != numColumns) {
            throw new IllegalArgumentException("Sum of local column sizes (" + this.m[this.size] + ") do not match the global column size (" + numColumns + ")");
        }
        this.scatter = this.scatterSetup();
    }

    private VectorScatter scatterSetup() {
        int[] ind = this.getCommIndices();
        Arrays.sort(ind);
        int[] N = this.getDelimiter();
        int[][] recv = new int[this.size][1];
        int[][] recvI = new int[this.size][];
        int i = 0;
        for (int k = 0; k < this.size; ++k) {
            int l = 0;
            int I2 = i;
            while (I2 < ind.length && ind[I2] < N[k + 1]) {
                int[] nArray = recv[k];
                nArray[0] = nArray[0] + 1;
                ++I2;
                ++l;
            }
            recvI[k] = new int[recv[k][0]];
            l = 0;
            I2 = i;
            while (I2 < ind.length && ind[I2] < N[k + 1]) {
                recvI[k][l] = ind[I2];
                ++I2;
                ++l;
            }
            i += recv[k][0];
        }
        int[][] send = new int[this.size][1];
        this.comm.allToAll((Object[])recv, (Object[])send);
        int[][] sendI = new int[this.size][];
        for (int i2 = 0; i2 < this.size; ++i2) {
            sendI[i2] = new int[send[i2][0]];
        }
        this.comm.allToAll((Object[])recvI, (Object[])sendI);
        return new VectorScatter(this.comm, sendI, recvI);
    }

    abstract int[] getDelimiter();

    abstract int[] getCommIndices();

    public int[] getRowOwnerships() {
        return this.n;
    }

    public int[] getColumnOwnerships() {
        return this.m;
    }

    public Matrix getBlock() {
        return this.A;
    }

    public Matrix getOff() {
        return this.B;
    }

    @Override
    public DistMatrix zero() {
        this.A.zero();
        this.B.zero();
        return this;
    }

    @Override
    protected double max() {
        double normA = this.A.norm(Matrix.Norm.Maxvalue);
        double normB = this.B.norm(Matrix.Norm.Maxvalue);
        double[] recv = new double[2];
        this.comm.allReduce(new double[]{normA, normB}, recv, Reductions.max());
        return recv[0] + recv[1];
    }

    @Override
    protected double normF() {
        double normA = this.A.norm(Matrix.Norm.Frobenius);
        double normB = this.B.norm(Matrix.Norm.Frobenius);
        normA *= normA;
        normB *= normB;
        double[] recv = new double[2];
        this.comm.allReduce(new double[]{normA, normB}, recv, Reductions.sum());
        return Math.sqrt(recv[0] + recv[1]);
    }

    public abstract boolean local(int var1, int var2);

    boolean inA(int row, int column) {
        return row >= this.n[this.rank] && row < this.n[this.rank + 1] && column >= this.m[this.rank] && column < this.m[this.rank + 1];
    }

    @Override
    public Matrix rank1(double alpha, Vector x, Vector y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Matrix rank2(double alpha, Vector x, Vector y) {
        throw new UnsupportedOperationException();
    }

    public Communicator getCommunicator() {
        return this.comm;
    }

    private static class DistMatrixEntry
    implements MatrixEntry {
        private int row;
        private int column;
        private MatrixEntry entry;

        private DistMatrixEntry() {
        }

        public void update(int rowOffset, int columnOffset, MatrixEntry entry) {
            this.row = rowOffset + entry.row();
            this.column = columnOffset + entry.column();
            this.entry = entry;
        }

        @Override
        public int row() {
            return this.row;
        }

        @Override
        public int column() {
            return this.column;
        }

        @Override
        public double get() {
            return this.entry.get();
        }

        @Override
        public void set(double value) {
            this.entry.set(value);
        }
    }

    class DistMatrixIterator
    implements Iterator<MatrixEntry> {
        private SuperIterator<Matrix, MatrixEntry> iterator;
        private DistMatrixEntry entry;
        private int rowAOffset;
        private int columnAOffset;
        private int rowBOffset;
        private int columnBOffset;

        public DistMatrixIterator(int rowAOffset, int columnAOffset, int rowBOffset, int columnBOffset) {
            this.rowAOffset = rowAOffset;
            this.rowBOffset = rowBOffset;
            this.columnAOffset = columnAOffset;
            this.columnBOffset = columnBOffset;
            this.iterator = new SuperIterator(Arrays.asList(DistMatrix.this.A, DistMatrix.this.B));
            this.entry = new DistMatrixEntry();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public MatrixEntry next() {
            Object se = this.iterator.next();
            if (((SuperIterator.SuperIteratorEntry)se).index() == 0) {
                this.entry.update(this.rowAOffset, this.columnAOffset, (MatrixEntry)((SuperIterator.SuperIteratorEntry)se).get());
            } else {
                this.entry.update(this.rowBOffset, this.columnBOffset, (MatrixEntry)((SuperIterator.SuperIteratorEntry)se).get());
            }
            return this.entry;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

