/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractTriangPackMatrix;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class UpperTriangPackMatrix
extends AbstractTriangPackMatrix {
    public UpperTriangPackMatrix(int n) {
        super(n, UpLo.Upper, Diag.NonUnit);
    }

    UpperTriangPackMatrix(int n, Diag diag) {
        super(n, UpLo.Upper, diag);
    }

    public UpperTriangPackMatrix(Matrix A2) {
        this(A2, true);
    }

    public UpperTriangPackMatrix(Matrix A2, boolean deep) {
        super(A2, deep, UpLo.Upper, Diag.NonUnit);
    }

    UpperTriangPackMatrix(Matrix A2, boolean deep, Diag diag) {
        super(A2, deep, UpLo.Upper, diag);
    }

    @Override
    public void add(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        int n = this.getIndex(row, column);
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void set(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        this.data[this.getIndex((int)row, (int)column)] = value;
    }

    @Override
    public double get(int row, int column) {
        if (row > column) {
            return 0.0;
        }
        return this.data[this.getIndex(row, column)];
    }

    int getIndex(int row, int column) {
        this.check(row, column);
        return row + (column + 1) * column / 2;
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e : A2) {
            if (e.row() > e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    @Override
    public UpperTriangPackMatrix copy() {
        return new UpperTriangPackMatrix(this);
    }
}

