/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractTriangDenseMatrix;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.UpLo;

public class UpperTriangDenseMatrix
extends AbstractTriangDenseMatrix {
    public UpperTriangDenseMatrix(int n) {
        super(n, UpLo.Upper, Diag.NonUnit);
    }

    UpperTriangDenseMatrix(int n, Diag diag) {
        super(n, UpLo.Upper, diag);
    }

    public UpperTriangDenseMatrix(Matrix A2) {
        this(A2, Math.min(A2.numRows(), A2.numColumns()));
    }

    public UpperTriangDenseMatrix(Matrix A2, boolean deep) {
        this(A2, Math.min(A2.numRows(), A2.numColumns()), deep);
    }

    UpperTriangDenseMatrix(Matrix A2, boolean deep, Diag diag) {
        this(A2, Math.min(A2.numRows(), A2.numColumns()), deep, diag);
    }

    public UpperTriangDenseMatrix(Matrix A2, int k) {
        this(A2, k, true);
    }

    public UpperTriangDenseMatrix(Matrix A2, int k, boolean deep) {
        super(A2, k, deep, UpLo.Upper, Diag.NonUnit);
    }

    UpperTriangDenseMatrix(Matrix A2, int k, boolean deep, Diag diag) {
        super(A2, k, deep, UpLo.Upper, diag);
    }

    @Override
    public void add(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        super.add(row, column, value);
    }

    @Override
    public double get(int row, int column) {
        if (row > column) {
            return 0.0;
        }
        return super.get(row, column);
    }

    @Override
    public void set(int row, int column, double value) {
        if (row > column) {
            throw new IllegalArgumentException("row > column");
        }
        super.set(row, column, value);
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e : A2) {
            if (e.row() > e.column()) continue;
            this.set(e.row(), e.column(), e.get());
        }
    }

    @Override
    public UpperTriangDenseMatrix copy() {
        return new UpperTriangDenseMatrix(this);
    }
}

