/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.OrthogonalComputer;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class RQ
extends OrthogonalComputer {
    public RQ(int m3, int n) {
        super(m3, n, true);
        if (n < m3) {
            throw new IllegalArgumentException("n < m");
        }
        this.work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgerqf(m3, n, new double[0], Matrices.ld(m3), new double[0], this.work, -1, info);
        int lwork = info.val != 0 ? m3 : (int)this.work[0];
        lwork = Math.max(1, lwork);
        this.work = new double[lwork];
        this.workGen = new double[1];
        info = new intW(0);
        LAPACK.getInstance().dorgrq(m3, n, m3, new double[0], Matrices.ld(m3), new double[0], this.workGen, -1, info);
        lwork = info.val != 0 ? m3 : (int)this.workGen[0];
        lwork = Math.max(1, lwork);
        this.workGen = new double[lwork];
    }

    public static RQ factorize(Matrix A2) {
        return new RQ(A2.numRows(), A2.numColumns()).factor(new DenseMatrix(A2));
    }

    @Override
    public RQ factor(DenseMatrix A2) {
        if (this.Q.numRows() != A2.numRows()) {
            throw new IllegalArgumentException("Q.numRows() != A.numRows()");
        }
        if (this.Q.numColumns() != A2.numColumns()) {
            throw new IllegalArgumentException("Q.numColumns() != A.numColumns()");
        }
        if (this.R == null) {
            throw new IllegalArgumentException("R == null");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgerqf(this.m, this.n, A2.getData(), Matrices.ld(this.m), this.tau, this.work, this.work.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.R.zero();
        for (MatrixEntry e : A2) {
            if (e.column() < this.n - this.m + e.row()) continue;
            this.R.set(e.row(), e.column() - (this.n - this.m), e.get());
        }
        info.val = 0;
        LAPACK.getInstance().dorgrq(this.m, this.n, this.k, A2.getData(), Matrices.ld(this.m), this.tau, this.workGen, this.workGen.length, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.Q.set(A2);
        return this;
    }

    public UpperTriangDenseMatrix getR() {
        return this.R;
    }
}

