/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractPackMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.LowerSPDPackMatrix;
import no.uib.cipr.matrix.LowerTriangPackMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.UpperSPDPackMatrix;
import no.uib.cipr.matrix.UpperTriangPackMatrix;
import org.netlib.lapack.LAPACK;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class PackCholesky {
    private final int n;
    private LowerTriangPackMatrix Cl;
    private UpperTriangPackMatrix Cu;
    private boolean notspd;
    private final boolean upper;

    public PackCholesky(int n, boolean upper) {
        this.n = n;
        this.upper = upper;
        if (upper) {
            this.Cu = new UpperTriangPackMatrix(n);
        } else {
            this.Cl = new LowerTriangPackMatrix(n);
        }
    }

    public static PackCholesky factorize(Matrix A2) {
        return new PackCholesky(A2.numRows(), true).factor(new UpperSPDPackMatrix(A2));
    }

    public PackCholesky factor(LowerSPDPackMatrix A2) {
        if (this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for upper matrices");
        }
        return this.decompose(A2);
    }

    public PackCholesky factor(UpperSPDPackMatrix A2) {
        if (!this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for lower matrices");
        }
        return this.decompose(A2);
    }

    private PackCholesky decompose(AbstractPackMatrix A2) {
        if (this.n != A2.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        this.notspd = false;
        intW info = new intW(0);
        if (this.upper) {
            LAPACK.getInstance().dpptrf(UpLo.Upper.netlib(), A2.numRows(), A2.getData(), info);
        } else {
            LAPACK.getInstance().dpptrf(UpLo.Lower.netlib(), A2.numRows(), A2.getData(), info);
        }
        if (info.val > 0) {
            this.notspd = true;
        } else if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        if (this.upper) {
            this.Cu.set(A2);
        } else {
            this.Cl.set(A2);
        }
        return this;
    }

    public boolean isSPD() {
        return !this.notspd;
    }

    public LowerTriangPackMatrix getL() {
        if (!this.upper) {
            return this.Cl;
        }
        throw new UnsupportedOperationException();
    }

    public UpperTriangPackMatrix getU() {
        if (this.upper) {
            return this.Cu;
        }
        throw new UnsupportedOperationException();
    }

    public DenseMatrix solve(DenseMatrix B2) throws MatrixNotSPDException {
        if (this.notspd) {
            throw new MatrixNotSPDException();
        }
        if (B2.numRows() != this.n) {
            throw new IllegalArgumentException("B.numRows() != n");
        }
        intW info = new intW(0);
        if (this.upper) {
            LAPACK.getInstance().dpptrs(UpLo.Upper.netlib(), this.Cu.numRows(), B2.numColumns(), this.Cu.getData(), B2.getData(), Matrices.ld(this.Cu.numRows()), info);
        } else {
            LAPACK.getInstance().dpptrs(UpLo.Lower.netlib(), this.Cl.numRows(), B2.numColumns(), this.Cl.getData(), B2.getData(), Matrices.ld(this.Cl.numRows()), info);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return B2;
    }

    public double rcond(Matrix A2) {
        if (A2.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        if (!A2.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        double anorm = A2.norm(Matrix.Norm.One);
        double[] work = new double[3 * this.n];
        int[] iwork = new int[this.n];
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        if (this.upper) {
            LAPACK.getInstance().dppcon(UpLo.Upper.netlib(), this.n, this.Cu.getData(), anorm, rcond, work, iwork, info);
        } else {
            LAPACK.getInstance().dppcon(UpLo.Lower.netlib(), this.n, this.Cl.getData(), anorm, rcond, work, iwork, info);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return rcond.val;
    }
}

