/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.LowerTriangDenseMatrix;
import no.uib.cipr.matrix.UpperTriangDenseMatrix;

abstract class OrthogonalComputer {
    final DenseMatrix Q;
    final LowerTriangDenseMatrix L;
    final UpperTriangDenseMatrix R;
    final int m;
    final int n;
    final int k;
    double[] work;
    double[] workGen;
    final double[] tau;

    OrthogonalComputer(int m3, int n, boolean upper) {
        this.m = m3;
        this.n = n;
        this.k = Math.min(m3, n);
        this.tau = new double[this.k];
        this.Q = new DenseMatrix(m3, n);
        if (upper) {
            this.R = new UpperTriangDenseMatrix(Math.min(m3, n));
            this.L = null;
        } else {
            this.L = new LowerTriangDenseMatrix(Math.min(m3, n));
            this.R = null;
        }
    }

    public abstract OrthogonalComputer factor(DenseMatrix var1);

    public DenseMatrix getQ() {
        return this.Q;
    }
}

