/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.JobEig;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.NotConvergedException;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class EVD {
    private final double[] work;
    private final int n;
    private final JobEig jobLeft;
    private final JobEig jobRight;
    private final double[] Wr;
    private final double[] Wi;
    private final DenseMatrix Vl;
    private final DenseMatrix Vr;

    public EVD(int n) {
        this(n, true, true);
    }

    public EVD(int n, boolean left, boolean right) {
        this.n = n;
        this.jobLeft = left ? JobEig.All : JobEig.Eigenvalues;
        this.jobRight = right ? JobEig.All : JobEig.Eigenvalues;
        this.Wr = new double[n];
        this.Wi = new double[n];
        this.Vl = left ? new DenseMatrix(n, n) : null;
        this.Vr = right ? new DenseMatrix(n, n) : null;
        double[] worksize = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgeev(this.jobLeft.netlib(), this.jobRight.netlib(), n, new double[0], Matrices.ld(n), new double[0], new double[0], new double[0], Matrices.ld(n), new double[0], Matrices.ld(n), worksize, -1, info);
        int lwork = 0;
        lwork = info.val != 0 ? (this.jobLeft == JobEig.All || this.jobRight == JobEig.All ? 4 * n : 3 * n) : (int)worksize[0];
        lwork = Math.max(1, lwork);
        this.work = new double[lwork];
    }

    public static EVD factorize(Matrix A2) throws NotConvergedException {
        return new EVD(A2.numRows()).factor(new DenseMatrix(A2));
    }

    public EVD factor(DenseMatrix A2) throws NotConvergedException {
        if (!A2.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        if (A2.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgeev(this.jobLeft.netlib(), this.jobRight.netlib(), this.n, A2.getData(), Matrices.ld(this.n), this.Wr, this.Wi, this.jobLeft == JobEig.All ? this.Vl.getData() : new double[]{}, Matrices.ld(this.n), this.jobRight == JobEig.All ? this.Vr.getData() : new double[]{}, Matrices.ld(this.n), this.work, this.work.length, info);
        if (info.val > 0) {
            throw new NotConvergedException(NotConvergedException.Reason.Iterations);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return this;
    }

    public DenseMatrix getLeftEigenvectors() {
        return this.Vl;
    }

    public DenseMatrix getRightEigenvectors() {
        return this.Vr;
    }

    public double[] getRealEigenvalues() {
        return this.Wr;
    }

    public double[] getImaginaryEigenvalues() {
        return this.Wi;
    }

    public boolean hasLeftEigenvectors() {
        return this.Vl != null;
    }

    public boolean hasRightEigenvectors() {
        return this.Vr != null;
    }
}

