/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.io.IOException;
import no.uib.cipr.matrix.AbstractDenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.Vector;
import no.uib.cipr.matrix.VectorEntry;
import no.uib.cipr.matrix.io.MatrixInfo;
import no.uib.cipr.matrix.io.MatrixSize;
import no.uib.cipr.matrix.io.MatrixVectorReader;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class DenseMatrix
extends AbstractDenseMatrix {
    public DenseMatrix(MatrixVectorReader r) throws IOException {
        block10: {
            int i;
            MatrixInfo info;
            block9: {
                super(0, 0);
                info = null;
                info = r.hasInfo() ? r.readMatrixInfo() : new MatrixInfo(true, MatrixInfo.MatrixField.Real, MatrixInfo.MatrixSymmetry.General);
                MatrixSize size = r.readMatrixSize(info);
                this.numRows = size.numRows();
                this.numColumns = size.numColumns();
                this.data = new double[this.numRows * this.numColumns];
                if (info.isPattern()) {
                    throw new UnsupportedOperationException("Pattern matrices are not supported");
                }
                if (info.isComplex()) {
                    throw new UnsupportedOperationException("Complex matrices are not supported");
                }
                if (info.isCoordinate()) {
                    int nz = size.numEntries();
                    int[] row = new int[nz];
                    int[] column = new int[nz];
                    double[] entry = new double[nz];
                    r.readCoordinate(row, column, entry);
                    r.add(-1, row);
                    r.add(-1, column);
                    for (int i2 = 0; i2 < nz; ++i2) {
                        this.set(row[i2], column[i2], entry[i2]);
                    }
                } else {
                    r.readArray(this.data);
                }
                if (!info.isSymmetric()) break block9;
                for (i = 0; i < this.numRows; ++i) {
                    for (int j = 0; j < i; ++j) {
                        this.set(j, i, this.get(i, j));
                    }
                }
                break block10;
            }
            if (!info.isSkewSymmetric()) break block10;
            for (i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < i; ++j) {
                    this.set(j, i, -this.get(i, j));
                }
            }
        }
    }

    public DenseMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
    }

    public DenseMatrix(Matrix A2) {
        super(A2);
    }

    public DenseMatrix(Matrix A2, boolean deep) {
        super(A2, deep);
    }

    public DenseMatrix(Vector x, boolean deep) {
        super(x.size(), 1);
        if (deep) {
            for (VectorEntry e : x) {
                this.set(e.index(), 0, e.get());
            }
        } else {
            if (!(x instanceof DenseVector)) {
                throw new IllegalArgumentException("x must be a DenseVector");
            }
            this.data = ((DenseVector)x).getData();
        }
    }

    public DenseMatrix(Vector x) {
        this(x, true);
    }

    public DenseMatrix(Vector[] x) {
        super(x[0].size(), x.length);
        for (Vector v : x) {
            if (v.size() == this.numRows) continue;
            throw new IllegalArgumentException("All vectors must be of the same size");
        }
        for (int j = 0; j < x.length; ++j) {
            for (VectorEntry e : x[j]) {
                this.set(e.index(), j, e.get());
            }
        }
    }

    public DenseMatrix(double[][] values) {
        super(values.length, values[0].length);
        for (int i = 0; i < values.length; ++i) {
            if (values[i].length != this.numColumns) {
                throw new IllegalArgumentException("Array cannot be jagged");
            }
            for (int j = 0; j < values[i].length; ++j) {
                this.set(i, j, values[i][j]);
            }
        }
    }

    @Override
    public DenseMatrix copy() {
        return new DenseMatrix(this);
    }

    @Override
    void copy(Matrix A2) {
        for (MatrixEntry e : A2) {
            this.set(e.row(), e.column(), e.get());
        }
    }

    @Override
    public Matrix multAdd(double alpha, Matrix B2, Matrix C2) {
        if (!(B2 instanceof DenseMatrix) || !(C2 instanceof DenseMatrix)) {
            return super.multAdd(alpha, B2, C2);
        }
        this.checkMultAdd(B2, C2);
        double[] Bd = ((DenseMatrix)B2).getData();
        double[] Cd = ((DenseMatrix)C2).getData();
        BLAS.getInstance().dgemm(Transpose.NoTranspose.netlib(), Transpose.NoTranspose.netlib(), C2.numRows(), C2.numColumns(), this.numColumns, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B2.numRows()), 1.0, Cd, Math.max(1, C2.numRows()));
        return C2;
    }

    @Override
    public Matrix transAmultAdd(double alpha, Matrix B2, Matrix C2) {
        if (!(B2 instanceof DenseMatrix) || !(C2 instanceof DenseMatrix)) {
            return super.transAmultAdd(alpha, B2, C2);
        }
        this.checkTransAmultAdd(B2, C2);
        double[] Bd = ((DenseMatrix)B2).getData();
        double[] Cd = ((DenseMatrix)C2).getData();
        BLAS.getInstance().dgemm(Transpose.Transpose.netlib(), Transpose.NoTranspose.netlib(), C2.numRows(), C2.numColumns(), this.numRows, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B2.numRows()), 1.0, Cd, Math.max(1, C2.numRows()));
        return C2;
    }

    @Override
    public Matrix transBmultAdd(double alpha, Matrix B2, Matrix C2) {
        if (!(B2 instanceof DenseMatrix) || !(C2 instanceof DenseMatrix)) {
            return super.transBmultAdd(alpha, B2, C2);
        }
        this.checkTransBmultAdd(B2, C2);
        double[] Bd = ((DenseMatrix)B2).getData();
        double[] Cd = ((DenseMatrix)C2).getData();
        BLAS.getInstance().dgemm(Transpose.NoTranspose.netlib(), Transpose.Transpose.netlib(), C2.numRows(), C2.numColumns(), this.numColumns, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B2.numRows()), 1.0, Cd, Math.max(1, C2.numRows()));
        return C2;
    }

    @Override
    public Matrix transABmultAdd(double alpha, Matrix B2, Matrix C2) {
        if (!(B2 instanceof DenseMatrix) || !(C2 instanceof DenseMatrix)) {
            return super.transABmultAdd(alpha, B2, C2);
        }
        this.checkTransABmultAdd(B2, C2);
        double[] Bd = ((DenseMatrix)B2).getData();
        double[] Cd = ((DenseMatrix)C2).getData();
        BLAS.getInstance().dgemm(Transpose.Transpose.netlib(), Transpose.Transpose.netlib(), C2.numRows(), C2.numColumns(), this.numRows, alpha, this.data, Math.max(1, this.numRows), Bd, Math.max(1, B2.numRows()), 1.0, Cd, Math.max(1, C2.numRows()));
        return C2;
    }

    @Override
    public Matrix rank1(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.rank1(alpha, x, y);
        }
        this.checkRank1(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dger(this.numRows, this.numColumns, alpha, xd, 1, yd, 1, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dgemv(Transpose.NoTranspose.netlib(), this.numRows, this.numColumns, alpha, this.data, Math.max(this.numRows, 1), xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.transMultAdd(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dgemv(Transpose.Transpose.netlib(), this.numRows, this.numColumns, alpha, this.data, Math.max(this.numRows, 1), xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Matrix solve(Matrix B2, Matrix X) {
        if (this.numRows != B2.numRows()) {
            throw new IllegalArgumentException("numRows != B.numRows() (" + this.numRows + " != " + B2.numRows() + ")");
        }
        if (this.numColumns != X.numRows()) {
            throw new IllegalArgumentException("numColumns != X.numRows() (" + this.numColumns + " != " + X.numRows() + ")");
        }
        if (X.numColumns() != B2.numColumns()) {
            throw new IllegalArgumentException("X.numColumns() != B.numColumns() (" + X.numColumns() + " != " + B2.numColumns() + ")");
        }
        if (this.isSquare()) {
            return this.LUsolve(B2, X);
        }
        return this.QRsolve(B2, X, Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B2 = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B2, X);
        return x;
    }

    @Override
    public Matrix transSolve(Matrix B2, Matrix X) {
        if (this.numColumns != B2.numRows()) {
            throw new IllegalArgumentException("numColumns != B.numRows() (" + this.numColumns + " != " + B2.numRows() + ")");
        }
        if (this.numRows != X.numRows()) {
            throw new IllegalArgumentException("numRows != X.numRows() (" + this.numRows + " != " + X.numRows() + ")");
        }
        if (X.numColumns() != B2.numColumns()) {
            throw new IllegalArgumentException("X.numColumns() != B.numColumns() (" + X.numColumns() + " != " + B2.numColumns() + ")");
        }
        return this.QRsolve(B2, X, Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        DenseMatrix B2 = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.transSolve(B2, X);
        return x;
    }

    Matrix LUsolve(Matrix B2, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        int[] piv = new int[this.numRows];
        intW info = new intW(0);
        LAPACK.getInstance().dgesv(this.numRows, B2.numColumns(), (double[])this.data.clone(), Matrices.ld(this.numRows), piv, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    Matrix QRsolve(Matrix B2, Matrix X, Transpose trans) {
        int nrhs = B2.numColumns();
        DenseMatrix Xtmp = new DenseMatrix(Math.max(this.numRows, this.numColumns), nrhs);
        int M = trans == Transpose.NoTranspose ? this.numRows : this.numColumns;
        for (int j = 0; j < nrhs; ++j) {
            for (int i = 0; i < M; ++i) {
                Xtmp.set(i, j, B2.get(i, j));
            }
        }
        double[] newData = (double[])this.data.clone();
        double[] work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dgels(trans.netlib(), this.numRows, this.numColumns, nrhs, newData, Matrices.ld(this.numRows), Xtmp.getData(), Matrices.ld(this.numRows, this.numColumns), work, -1, info);
        int lwork = -1;
        lwork = info.val != 0 ? Math.max(1, Math.min(this.numRows, this.numColumns) + Math.max(Math.min(this.numRows, this.numColumns), nrhs)) : Math.max((int)work[0], 1);
        work = new double[lwork];
        info.val = 0;
        LAPACK.getInstance().dgels(trans.netlib(), this.numRows, this.numColumns, nrhs, newData, Matrices.ld(this.numRows), Xtmp.getData(), Matrices.ld(this.numRows, this.numColumns), work, lwork, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        int N = trans == Transpose.NoTranspose ? this.numColumns : this.numRows;
        for (int j = 0; j < nrhs; ++j) {
            for (int i = 0; i < N; ++i) {
                X.set(i, j, Xtmp.get(i, j));
            }
        }
        return X;
    }
}

