/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.BandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UnitLowerTriangBandMatrix;
import no.uib.cipr.matrix.UpperTriangBandMatrix;
import org.netlib.lapack.LAPACK;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class BandLU {
    private final int n;
    private final int kl;
    private final int ku;
    private final BandMatrix LU;
    private final int[] ipiv;
    private boolean singular;

    public BandLU(int n, int kl, int ku) {
        this.n = n;
        this.kl = kl;
        this.ku = ku;
        this.LU = new BandMatrix(n, kl, ku + kl);
        this.ipiv = new int[n];
    }

    public static BandLU factorize(BandMatrix A2) {
        return new BandLU(A2.numRows(), A2.kl, A2.ku).factor(A2, false);
    }

    public BandLU factor(BandMatrix A2, boolean inplace) {
        if (inplace) {
            return this.factor(A2);
        }
        return this.factor(new BandMatrix(A2, this.kl, this.kl + this.ku));
    }

    public BandLU factor(BandMatrix A2) {
        if (!A2.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        if (this.n != A2.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        if (A2.ku != this.ku + this.kl) {
            throw new IllegalArgumentException("A.ku != ku + kl");
        }
        this.singular = false;
        intW info = new intW(0);
        LAPACK.getInstance().dgbtrf(this.n, this.n, this.kl, this.ku, A2.getData(), 2 * this.kl + this.ku + 1, this.ipiv, info);
        if (info.val > 0) {
            this.singular = true;
        } else if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        this.LU.set(A2);
        return this;
    }

    public UnitLowerTriangBandMatrix getL() {
        return new UnitLowerTriangBandMatrix((Matrix)this.LU, this.LU.numSubDiagonals(), false);
    }

    public UpperTriangBandMatrix getU() {
        return new UpperTriangBandMatrix((Matrix)this.LU, this.LU.numSuperDiagonals(), false);
    }

    public BandMatrix getLU() {
        return this.LU;
    }

    public int[] getPivots() {
        return this.ipiv;
    }

    public boolean isSingular() {
        return this.singular;
    }

    public double rcond(Matrix A2, Matrix.Norm norm) {
        if (norm != Matrix.Norm.One && norm != Matrix.Norm.Infinity) {
            throw new IllegalArgumentException("Only the 1 or the Infinity norms are supported");
        }
        if (A2.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        if (!A2.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        double anorm = A2.norm(norm);
        double[] work = new double[3 * this.n];
        int[] lwork = new int[this.n];
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        LAPACK.getInstance().dgbcon(norm.netlib(), this.n, this.kl, this.ku, this.LU.getData(), Matrices.ld(2 * this.kl + this.ku + 1), this.ipiv, anorm, rcond, work, lwork, info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return rcond.val;
    }

    public DenseMatrix solve(DenseMatrix B2) throws MatrixSingularException {
        return this.solve(B2, Transpose.NoTranspose);
    }

    public DenseMatrix transSolve(DenseMatrix B2) throws MatrixSingularException {
        return this.solve(B2, Transpose.Transpose);
    }

    private DenseMatrix solve(DenseMatrix B2, Transpose trans) throws MatrixSingularException {
        if (this.singular) {
            throw new MatrixSingularException();
        }
        if (B2.numRows() != this.n) {
            throw new IllegalArgumentException("B.numRows() != n");
        }
        intW info = new intW(0);
        LAPACK.getInstance().dgbtrs(trans.netlib(), this.n, this.kl, this.ku, B2.numColumns(), this.LU.getData(), 2 * this.kl + this.ku + 1, this.ipiv, B2.getData(), Matrices.ld(this.n), info);
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return B2;
    }
}

