/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.LowerSPDBandMatrix;
import no.uib.cipr.matrix.LowerTriangBandMatrix;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.UpperSPDBandMatrix;
import no.uib.cipr.matrix.UpperTriangBandMatrix;
import org.netlib.lapack.LAPACK;
import org.netlib.util.doubleW;
import org.netlib.util.intW;

public class BandCholesky {
    private final int n;
    private final int kd;
    private LowerTriangBandMatrix Cl;
    private UpperTriangBandMatrix Cu;
    private boolean notspd;
    private final boolean upper;

    public BandCholesky(int n, int kd, boolean upper) {
        this.n = n;
        this.kd = kd;
        this.upper = upper;
        if (upper) {
            this.Cu = new UpperTriangBandMatrix(n, kd);
        } else {
            this.Cl = new LowerTriangBandMatrix(n, kd);
        }
    }

    public static BandCholesky factorize(LowerSPDBandMatrix A2) {
        return new BandCholesky(A2.numRows(), A2.kl, false).factor(A2);
    }

    public static BandCholesky factorize(UpperSPDBandMatrix A2) {
        return new BandCholesky(A2.numRows(), A2.ku, true).factor(A2);
    }

    public BandCholesky factor(LowerSPDBandMatrix A2) {
        if (this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for upper matrices");
        }
        return this.decompose(A2);
    }

    public BandCholesky factor(UpperSPDBandMatrix A2) {
        if (!this.upper) {
            throw new IllegalArgumentException("Cholesky decomposition constructed for lower matrices");
        }
        return this.decompose(A2);
    }

    private BandCholesky decompose(AbstractBandMatrix A2) {
        if (this.n != A2.numRows()) {
            throw new IllegalArgumentException("n != A.numRows()");
        }
        if (this.upper && A2.ku != this.kd) {
            throw new IllegalArgumentException("A.ku != kd");
        }
        if (!this.upper && A2.kl != this.kd) {
            throw new IllegalArgumentException("A.kl != kd");
        }
        this.notspd = false;
        intW info = new intW(0);
        if (this.upper) {
            LAPACK.getInstance().dpbtrf(UpLo.Upper.netlib(), this.n, this.kd, A2.getData(), Matrices.ld(this.kd + 1), info);
        } else {
            LAPACK.getInstance().dpbtrf(UpLo.Lower.netlib(), this.n, this.kd, A2.getData(), Matrices.ld(this.kd + 1), info);
        }
        if (info.val > 0) {
            this.notspd = true;
        } else if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        if (this.upper) {
            this.Cu.set(A2);
        } else {
            this.Cl.set(A2);
        }
        return this;
    }

    public LowerTriangBandMatrix getL() {
        if (!this.upper) {
            return this.Cl;
        }
        throw new UnsupportedOperationException();
    }

    public UpperTriangBandMatrix getU() {
        if (this.upper) {
            return this.Cu;
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSPD() {
        return !this.notspd;
    }

    public double rcond(Matrix A2) {
        if (A2.numRows() != this.n) {
            throw new IllegalArgumentException("A.numRows() != n");
        }
        if (!A2.isSquare()) {
            throw new IllegalArgumentException("!A.isSquare()");
        }
        double anorm = A2.norm(Matrix.Norm.One);
        double[] work = new double[3 * this.n];
        int[] lwork = new int[this.n];
        intW info = new intW(0);
        doubleW rcond = new doubleW(0.0);
        if (this.upper) {
            LAPACK.getInstance().dpbcon(UpLo.Upper.netlib(), this.n, this.kd, this.Cu.getData(), Matrices.ld(this.kd + 1), anorm, rcond, work, lwork, info);
        } else {
            LAPACK.getInstance().dpbcon(UpLo.Lower.netlib(), this.n, this.kd, this.Cl.getData(), Matrices.ld(this.kd + 1), anorm, rcond, work, lwork, info);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return rcond.val;
    }

    public DenseMatrix solve(DenseMatrix B2) throws MatrixNotSPDException {
        if (this.notspd) {
            throw new MatrixNotSPDException();
        }
        if (B2.numRows() != this.n) {
            throw new IllegalArgumentException("B.numRows() != n");
        }
        intW info = new intW(0);
        if (this.upper) {
            LAPACK.getInstance().dpbtrs(UpLo.Upper.netlib(), this.n, this.kd, B2.numColumns(), this.Cu.getData(), Matrices.ld(this.kd + 1), B2.getData(), Matrices.ld(this.n), info);
        } else {
            LAPACK.getInstance().dpbtrs(UpLo.Lower.netlib(), this.n, this.kd, B2.numColumns(), this.Cl.getData(), Matrices.ld(this.kd + 1), B2.getData(), Matrices.ld(this.n), info);
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return B2;
    }
}

