/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import no.uib.cipr.matrix.AbstractDenseMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Side;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

abstract class AbstractSymmDenseMatrix
extends AbstractDenseMatrix {
    private UpLo uplo;

    AbstractSymmDenseMatrix(int n, UpLo uplo) {
        super(n, n);
        this.uplo = uplo;
    }

    AbstractSymmDenseMatrix(Matrix A2, UpLo uplo) {
        this(A2, true, uplo);
    }

    AbstractSymmDenseMatrix(Matrix A2, boolean deep, UpLo uplo) {
        super(A2, deep);
        if (!this.isSquare()) {
            throw new IllegalArgumentException("Symmetric matrix must be square");
        }
        this.uplo = uplo;
    }

    @Override
    public Matrix multAdd(double alpha, Matrix B2, Matrix C2) {
        if (!(B2 instanceof DenseMatrix) || !(C2 instanceof DenseMatrix)) {
            return super.multAdd(alpha, B2, C2);
        }
        this.checkMultAdd(B2, C2);
        double[] Bd = ((DenseMatrix)B2).getData();
        double[] Cd = ((DenseMatrix)C2).getData();
        BLAS.getInstance().dsymm(Side.Left.netlib(), this.uplo.netlib(), C2.numRows(), C2.numColumns(), alpha, this.data, Math.max(1, C2.numRows()), Bd, Math.max(1, C2.numRows()), 1.0, Cd, Math.max(1, C2.numRows()));
        return C2;
    }

    @Override
    public Matrix transAmultAdd(double alpha, Matrix B2, Matrix C2) {
        return this.multAdd(alpha, B2, C2);
    }

    @Override
    public Matrix rank1(double alpha, Vector x, Vector y) {
        if (x != y) {
            throw new IllegalArgumentException("x != y");
        }
        if (!(x instanceof DenseVector)) {
            return super.rank1(alpha, x, y);
        }
        this.checkRank1(x, y);
        double[] xd = ((DenseVector)x).getData();
        BLAS.getInstance().dsyr(this.uplo.netlib(), this.numRows, alpha, xd, 1, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Matrix rank2(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.rank2(alpha, x, y);
        }
        this.checkRank2(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dsyr2(this.uplo.netlib(), this.numRows, alpha, xd, 1, yd, 1, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dsymv(this.uplo.netlib(), this.numRows, alpha, this.data, Math.max(1, this.numRows), xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        return this.multAdd(alpha, x, y);
    }

    @Override
    public Matrix rank1(double alpha, Matrix C2) {
        if (!(C2 instanceof DenseMatrix)) {
            return super.rank1(alpha, C2);
        }
        this.checkRank1(C2);
        double[] Cd = ((DenseMatrix)C2).getData();
        BLAS.getInstance().dsyrk(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.numRows, C2.numColumns(), alpha, Cd, Math.max(1, this.numRows), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Matrix transRank1(double alpha, Matrix C2) {
        if (!(C2 instanceof DenseMatrix)) {
            return super.transRank1(alpha, C2);
        }
        this.checkTransRank1(C2);
        double[] Cd = ((DenseMatrix)C2).getData();
        BLAS.getInstance().dsyrk(this.uplo.netlib(), Transpose.Transpose.netlib(), this.numRows, this.numRows, alpha, Cd, Math.max(1, this.numRows), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Matrix rank2(double alpha, Matrix B2, Matrix C2) {
        if (!(B2 instanceof DenseMatrix) || !(C2 instanceof DenseMatrix)) {
            return super.rank2(alpha, B2, C2);
        }
        this.checkRank2(B2, C2);
        double[] Bd = ((DenseMatrix)B2).getData();
        double[] Cd = ((DenseMatrix)C2).getData();
        BLAS.getInstance().dsyr2k(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.numRows, B2.numColumns(), alpha, Bd, Math.max(1, this.numRows), Cd, Math.max(1, this.numRows), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Matrix transRank2(double alpha, Matrix B2, Matrix C2) {
        if (!(B2 instanceof DenseMatrix) || !(C2 instanceof DenseMatrix)) {
            return super.transRank2(alpha, B2, C2);
        }
        this.checkTransRank2(B2, C2);
        double[] Bd = ((DenseMatrix)B2).getData();
        double[] Cd = ((DenseMatrix)C2).getData();
        BLAS.getInstance().dsyr2k(this.uplo.netlib(), Transpose.Transpose.netlib(), this.numRows, B2.numRows(), alpha, Bd, Math.max(1, B2.numRows()), Cd, Math.max(1, B2.numRows()), 1.0, this.data, Math.max(1, this.numRows));
        return this;
    }

    @Override
    public Matrix solve(Matrix B2, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        double[] newData = (double[])this.data.clone();
        int[] ipiv = new int[this.numRows];
        double[] work = new double[1];
        intW info = new intW(0);
        LAPACK.getInstance().dsysv(this.uplo.netlib(), this.numRows, X.numColumns(), newData, Matrices.ld(this.numRows), ipiv, Xd, Matrices.ld(this.numRows), work, -1, info);
        int lwork = -1;
        lwork = info.val != 0 ? 1 : Math.max((int)work[0], 1);
        work = new double[lwork];
        info.val = 0;
        LAPACK.getInstance().dsysv(this.uplo.netlib(), this.numRows, X.numColumns(), newData, Matrices.ld(this.numRows), ipiv, Xd, Matrices.ld(this.numRows), work, lwork, info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B2 = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B2, X);
        return x;
    }

    @Override
    public Matrix transSolve(Matrix B2, Matrix X) {
        return this.solve(B2, X);
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        return this.solve(b, x);
    }

    Matrix SPDsolve(Matrix B2, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        intW info = new intW(0);
        LAPACK.getInstance().dposv(this.uplo.netlib(), this.numRows, X.numColumns(), (double[])this.data.clone(), Matrices.ld(this.numRows), Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixNotSPDException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Matrix transpose() {
        return this;
    }
}

