/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Iterator;
import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.BandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixEntry;
import no.uib.cipr.matrix.MatrixNotSPDException;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.blas.BLAS;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

abstract class AbstractSymmBandMatrix
extends AbstractBandMatrix {
    private UpLo uplo;
    int kd;

    AbstractSymmBandMatrix(int n, int kl, int ku, UpLo uplo) {
        super(n, kl, ku);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
    }

    AbstractSymmBandMatrix(Matrix A2, int kl, int ku, UpLo uplo) {
        this(A2, kl, ku, true, uplo);
    }

    AbstractSymmBandMatrix(Matrix A2, int kl, int ku, boolean deep, UpLo uplo) {
        super(A2, kl, ku, deep);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
    }

    @Override
    public Vector multAdd(double alpha, Vector x, Vector y) {
        if (!(x instanceof DenseVector) || !(y instanceof DenseVector)) {
            return super.multAdd(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] xd = ((DenseVector)x).getData();
        double[] yd = ((DenseVector)y).getData();
        BLAS.getInstance().dsbmv(this.uplo.netlib(), this.numRows, this.kd, alpha, this.data, this.kd + 1, xd, 1, 1.0, yd, 1);
        return y;
    }

    @Override
    public Vector transMultAdd(double alpha, Vector x, Vector y) {
        return this.multAdd(alpha, x, y);
    }

    @Override
    public Iterator<MatrixEntry> iterator() {
        return new AbstractBandMatrix.BandMatrixIterator(this.kd, this.kd);
    }

    @Override
    public Matrix solve(Matrix B2, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        BandMatrix Af = new BandMatrix(this, this.kd, this.kd + this.kd);
        int[] ipiv = new int[this.numRows];
        intW info = new intW(0);
        LAPACK.getInstance().dgbsv(this.numRows, this.kd, this.kd, X.numColumns(), Af.getData(), Matrices.ld(2 * this.kd + this.kd + 1), ipiv, Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B2 = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B2, X);
        return x;
    }

    @Override
    public Matrix transSolve(Matrix B2, Matrix X) {
        return this.solve(B2, X);
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        return this.solve(b, x);
    }

    Matrix SPDsolve(Matrix B2, Matrix X) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B2, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B2);
        intW info = new intW(0);
        LAPACK.getInstance().dpbsv(this.uplo.netlib(), this.numRows, this.kd, X.numColumns(), (double[])this.data.clone(), Matrices.ld(this.kd + 1), Xd, Matrices.ld(this.numRows), info);
        if (info.val > 0) {
            throw new MatrixNotSPDException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }

    @Override
    public Matrix transpose() {
        return this;
    }
}

