/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import java.util.Arrays;
import no.uib.cipr.matrix.AbstractMatrix;
import no.uib.cipr.matrix.Matrix;

abstract class AbstractDenseMatrix
extends AbstractMatrix {
    double[] data;

    public AbstractDenseMatrix(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.data = new double[numRows * numColumns];
    }

    public AbstractDenseMatrix(Matrix A2) {
        this(A2, true);
    }

    public AbstractDenseMatrix(Matrix A2, boolean deep) {
        super(A2);
        if (deep) {
            this.data = new double[this.numRows * this.numColumns];
            this.copy(A2);
        } else {
            this.data = ((AbstractDenseMatrix)A2).getData();
        }
    }

    abstract void copy(Matrix var1);

    public double[] getData() {
        return this.data;
    }

    @Override
    public void add(int row, int column, double value) {
        int n = this.getIndex(row, column);
        this.data[n] = this.data[n] + value;
    }

    @Override
    public void set(int row, int column, double value) {
        this.data[this.getIndex((int)row, (int)column)] = value;
    }

    @Override
    public double get(int row, int column) {
        return this.data[this.getIndex(row, column)];
    }

    int getIndex(int row, int column) {
        this.check(row, column);
        return row + column * this.numRows;
    }

    @Override
    public Matrix set(Matrix B2) {
        if (!(B2 instanceof AbstractDenseMatrix)) {
            return super.set(B2);
        }
        this.checkSize(B2);
        double[] Bd = ((AbstractDenseMatrix)B2).getData();
        if (Bd == this.data) {
            return this;
        }
        System.arraycopy(Bd, 0, this.data, 0, this.data.length);
        return this;
    }

    @Override
    public Matrix zero() {
        Arrays.fill(this.data, 0.0);
        return this;
    }
}

