/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import net.sf.jlinkgrammar.DictNode;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.Disjunct;
import net.sf.jlinkgrammar.Exp;
import net.sf.jlinkgrammar.XNode;

public class Word {
    public String string;
    public XNode x;
    public Disjunct d;
    public boolean firstupper;
    public boolean is_conjunction = false;

    private void special_string(String s2, Dictionary dict) {
        if (dict.boolean_dictionary_lookup(s2)) {
            XNode e = this.x = Word.build_word_expressions(s2, dict);
            while (e != null) {
                e.string = this.string;
                e = e.next;
            }
        } else {
            throw new RuntimeException("Can't build expressions. To process this sentence your dictionary needs the word \"" + s2 + "\"");
        }
    }

    public static XNode build_word_expressions(String s2, Dictionary dict) {
        DictNode dn = dict.dictionary_lookup(s2);
        XNode x = null;
        while (dn != null) {
            XNode y = new XNode();
            y.next = x;
            x = y;
            x.exp = Exp.copy_Exp(dn.exp);
            x.string = dn.string;
            dn = dn.right;
        }
        return x;
    }

    public Word(String s2, Dictionary dict) {
        this.string = s2;
        if (dict.boolean_dictionary_lookup(s2)) {
            this.x = Word.build_word_expressions(s2, dict);
        } else if (Character.isUpperCase(s2.charAt(0)) && Dictionary.is_s_word(s2) && dict.pl_capitalized_word_defined) {
            this.special_string("PL-CAPITALIZED-WORDS", dict);
        } else if (Character.isUpperCase(s2.charAt(0)) && dict.capitalized_word_defined) {
            this.special_string("CAPITALIZED-WORDS", dict);
        } else if (Dictionary.is_number(s2) && dict.number_word_defined) {
            this.special_string("NUMBERS", dict);
        } else if (Dictionary.ishyphenated(s2) && dict.hyphenated_word_defined) {
            this.special_string("HYPHENATED-WORDS", dict);
        } else if (Dictionary.is_ing_word(s2) && dict.ing_word_defined) {
            this.guessed_string(s2, "ING-WORDS", dict);
        } else if (Dictionary.is_s_word(s2) && dict.s_word_defined) {
            this.guessed_string(s2, "S-WORDS", dict);
        } else if (Dictionary.is_ed_word(s2) && dict.ed_word_defined) {
            this.guessed_string(s2, "ED-WORDS", dict);
        } else if (Dictionary.is_ly_word(s2) && dict.ly_word_defined) {
            this.guessed_string(s2, "LY-WORDS", dict);
        } else if (dict.unknown_word_defined && dict.use_unknown_word) {
            this.handle_unknown_word(s2, dict);
        } else {
            throw new RuntimeException("I should have found that word.");
        }
    }

    private void guessed_string(String s2, String type, Dictionary dict) {
        if (dict.boolean_dictionary_lookup(type)) {
            XNode e = this.x = Word.build_word_expressions(type, dict);
            if (Dictionary.is_s_word(s2)) {
                while (e != null) {
                    int t = e.string.indexOf(46);
                    e.string = t >= 0 ? s2 + "[!]." + s2.substring(t + 1) : s2 + "[!]";
                    e = e.next;
                }
            } else {
                e.string = Dictionary.is_ed_word(s2) ? s2 + "[!].v" : (Dictionary.is_ing_word(s2) ? s2 + "[!].g" : (Dictionary.is_ly_word(s2) ? s2 + "[!].e" : s2 + "[!]"));
            }
        } else {
            throw new RuntimeException("Can't build expressions. To process this sentence your dictionary needs the word \"" + type + "\"");
        }
    }

    private void handle_unknown_word(String s2, Dictionary dict) {
        XNode d = this.x = Word.build_word_expressions("UNKNOWN-WORD", dict);
        while (d != null) {
            int t = d.string.indexOf(46);
            StringBuffer str = new StringBuffer();
            if (t >= 0) {
                str.append(s2 + "[?]." + d.string.substring(t + 1));
            } else {
                str.append(s2 + "[?]");
            }
            d.string = str.toString();
            d = d.next;
        }
    }
}

