/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.util.Arrays;
import java.util.Comparator;
import net.sf.jlinkgrammar.CONList;
import net.sf.jlinkgrammar.CONNode;
import net.sf.jlinkgrammar.Connector;
import net.sf.jlinkgrammar.DISList;
import net.sf.jlinkgrammar.DISNode;
import net.sf.jlinkgrammar.Disjunct;
import net.sf.jlinkgrammar.Link;
import net.sf.jlinkgrammar.ListOfLinks;
import net.sf.jlinkgrammar.MatchNode;
import net.sf.jlinkgrammar.MyRandom;
import net.sf.jlinkgrammar.ParseChoice;
import net.sf.jlinkgrammar.ParseOptions;
import net.sf.jlinkgrammar.ParseSet;
import net.sf.jlinkgrammar.Sentence;
import net.sf.jlinkgrammar.XTableConnector;

public class ParseInfo {
    int x_table_size;
    XTableConnector[] x_table;
    ParseSet parse_set;
    int N_words;
    Disjunct[] chosen_disjuncts = new Disjunct[250];
    int N_links;
    Link[] link_array = new Link[497];
    static ListOfLinks[] word_links = new ListOfLinks[250];
    static int[] dfs_root_word = new int[250];
    static int[] dfs_height = new int[250];
    static Integer[] height_perm = new Integer[250];

    void initialize_links() {
        this.N_links = 0;
        for (int i = 0; i < this.N_words; ++i) {
            this.chosen_disjuncts[i] = null;
        }
    }

    void list_links(ParseSet set, int index) {
        int n;
        if (set == null || set.first == null) {
            return;
        }
        ParseChoice pc = set.first;
        while (pc != null && index >= (n = pc.set[0].count * pc.set[1].count)) {
            index -= n;
            pc = pc.next;
        }
        if (pc == null) {
            throw new RuntimeException("walked off the end in list_links");
        }
        this.issue_links_for_choice(pc);
        this.list_links(pc.set[0], index % pc.set[0].count);
        this.list_links(pc.set[1], index / pc.set[0].count);
    }

    void list_random_links(ParseSet set) {
        if (set == null || set.first == null) {
            return;
        }
        int num_pc = 0;
        ParseChoice pc = set.first;
        while (pc != null) {
            ++num_pc;
            pc = pc.next;
        }
        int new_index = MyRandom.my_random() % num_pc;
        pc = set.first;
        for (num_pc = 0; pc != null && new_index != num_pc; ++num_pc) {
            pc = pc.next;
        }
        if (pc == null) {
            throw new RuntimeException("Couldn't get a random parse choice");
        }
        this.issue_links_for_choice(pc);
        this.list_random_links(pc.set[0]);
        this.list_random_links(pc.set[1]);
    }

    void issue_links_for_choice(ParseChoice pc) {
        if (pc.link[0].lc != null) {
            this.issue_link(pc.ld, pc.md, pc.link[0]);
        }
        if (pc.link[1].lc != null) {
            this.issue_link(pc.md, pc.rd, pc.link[1]);
        }
    }

    void issue_link(Disjunct ld, Disjunct rd, Link link) {
        if (this.N_links > 496) {
            throw new RuntimeException("Too many links");
        }
        this.link_array[this.N_links] = link;
        ++this.N_links;
        this.chosen_disjuncts[link.l] = ld;
        this.chosen_disjuncts[link.r] = rd;
    }

    int link_cost() {
        int lcost = 0;
        for (int i = 0; i < this.N_links; ++i) {
            lcost += this.cost_for_length(this.link_array[i].r - this.link_array[i].l);
        }
        return lcost;
    }

    int null_cost() {
        return 0;
    }

    int unused_word_cost() {
        int lcost = 0;
        for (int i = 0; i < this.N_words; ++i) {
            if (this.chosen_disjuncts[i] != null) continue;
            ++lcost;
        }
        return lcost;
    }

    int disjunct_cost() {
        int lcost = 0;
        for (int i = 0; i < this.N_words; ++i) {
            if (this.chosen_disjuncts[i] == null) continue;
            lcost += this.chosen_disjuncts[i].cost;
        }
        return lcost;
    }

    private int cost_for_length(int length) {
        return length - 1;
    }

    void build_digraph() {
        int i;
        for (i = 0; i < this.N_words; ++i) {
            ParseInfo.word_links[i] = null;
        }
        for (int link = 0; link < this.N_links; ++link) {
            Link lp = this.link_array[link];
            i = lp.lc.label;
            if (i < -1) continue;
            ListOfLinks lol = new ListOfLinks();
            lol.next = word_links[lp.l];
            ParseInfo.word_links[lp.l] = lol;
            lol.link = link;
            lol.word = lp.r;
            i = lp.lc.priority;
            lol.dir = i == 0 ? 0 : (i == 2 ? 1 : -1);
            lol = new ListOfLinks();
            lol.next = word_links[lp.r];
            ParseInfo.word_links[lp.r] = lol;
            lol.link = link;
            lol.word = lp.l;
            i = lp.rc.priority;
            lol.dir = i == 0 ? 0 : (i == 2 ? 1 : -1);
        }
    }

    DISNode build_DIS_CON_tree() {
        int w;
        for (w = 0; w < this.N_words; ++w) {
            ParseInfo.dfs_height[w] = 0;
        }
        for (w = 0; w < this.N_words; ++w) {
            this.height_dfs(w, 250);
        }
        for (w = 0; w < this.N_words; ++w) {
            ParseInfo.height_perm[w] = new Integer(w);
        }
        Arrays.sort(height_perm, 0, this.N_words, new Comparator(){

            public int compare(Object o1, Object o2) {
                return dfs_height[(Integer)o2] - dfs_height[(Integer)o1];
            }
        });
        for (w = 0; w < this.N_words; ++w) {
            ParseInfo.dfs_root_word[w] = -1;
        }
        DISNode dnroot = null;
        for (int xw = 0; xw < this.N_words; ++xw) {
            w = height_perm[xw];
            if (dfs_root_word[w] != -1) continue;
            DISNode dn = ParseInfo.build_DISNode(w);
            if (dnroot == null) {
                dnroot = dn;
                continue;
            }
            CONList child = dn.cl;
            while (child != null) {
                CONList xchild = child.next;
                child.next = dnroot.cl;
                dnroot.cl = child;
                child = xchild;
            }
            ListOfLinks lol = dn.lol;
            while (lol != null) {
                ListOfLinks xlol = lol.next;
                lol.next = dnroot.lol;
                dnroot.lol = lol;
                lol = xlol;
            }
        }
        return dnroot;
    }

    boolean verify_set() {
        boolean overflowed = false;
        if (this.x_table == null) {
            throw new RuntimeException("called verify_set when x_table==null");
        }
        for (int i = 0; i < this.x_table_size; ++i) {
            XTableConnector t = this.x_table[i];
            while (t != null) {
                overflowed = overflowed || this.verify_set_node(t.set);
                t = t.next;
            }
        }
        return overflowed;
    }

    boolean verify_set_node(ParseSet set) {
        if (set == null || set.first == null) {
            return false;
        }
        int n = 0;
        double dn = 0;
        ParseChoice pc = set.first;
        while (pc != null) {
            n += pc.set[0].count * pc.set[1].count;
            dn += (double)pc.set[0].count * (double)pc.set[1].count;
            pc = pc.next;
        }
        if (n != set.count) {
            throw new RuntimeException("verify_set failed");
        }
        return n < 0 || n != (int)dn;
    }

    ParseSet parse_set(Sentence sent, Disjunct ld, Disjunct rd, int lw, int rw, Connector le, Connector re, int cost, ParseOptions opts) {
        ParseSet[] ls = new ParseSet[4];
        ParseSet[] rs = new ParseSet[4];
        if (cost < 0) {
            throw new RuntimeException("parse_set() called with cost < 0.");
        }
        int count = Sentence.table_lookup(lw, rw, le, re, cost);
        if (count == 0 || count == -1) {
            return null;
        }
        XTableConnector xt = this.x_table_pointer(lw, rw, le, re, cost);
        if (xt != null) {
            return xt.set;
        }
        xt = this.x_table_store(lw, rw, le, re, cost, ParseSet.empty_set());
        xt.set.count = count;
        if (rw == 1 + lw) {
            return xt.set;
        }
        if (le == null && re == null) {
            ParseChoice a_choice;
            if (!opts.islands_ok && lw != -1) {
                return xt.set;
            }
            if (cost == 0) {
                return xt.set;
            }
            int w = lw + 1;
            Disjunct dis = sent.word.get((int)w).d;
            while (dis != null) {
                if (dis.left == null) {
                    rs[0] = this.parse_set(sent, dis, null, w, rw, dis.right, null, cost - 1, opts);
                    if (rs[0] != null) {
                        a_choice = new ParseChoice(ParseSet.dummy_set, lw, w, null, null, rs[0], w, rw, null, null, null, null, null);
                        xt.set.put_choice_in_set(a_choice);
                    }
                }
                dis = dis.next;
            }
            rs[0] = this.parse_set(sent, null, null, w, rw, null, null, cost - 1, opts);
            if (rs[0] != null) {
                a_choice = new ParseChoice(ParseSet.dummy_set, lw, w, null, null, rs[0], w, rw, null, null, null, null, null);
                xt.set.put_choice_in_set(a_choice);
            }
            return xt.set;
        }
        int start_word = le == null ? lw + 1 : le.word;
        int end_word = re == null ? rw - 1 : re.word;
        for (int w = start_word; w <= end_word; ++w) {
            MatchNode m3 = Sentence.form_match_list(w, le, lw, re, rw);
            while (m3 != null) {
                Disjunct d = m3.d;
                for (int lcost = 0; lcost <= cost; ++lcost) {
                    ParseSet lset;
                    ParseSet rset;
                    ParseChoice a_choice;
                    int i;
                    int rcost = cost - lcost;
                    boolean Lmatch = le != null && d.left != null && Connector.match(sent, le, d.left, lw, w);
                    boolean Rmatch = d.right != null && re != null && Connector.match(sent, d.right, re, w, rw);
                    for (i = 0; i < 4; ++i) {
                        rs[i] = null;
                        ls[i] = null;
                    }
                    if (Lmatch) {
                        ls[0] = this.parse_set(sent, ld, d, lw, w, le.next, d.left.next, lcost, opts);
                        if (le.multi) {
                            ls[1] = this.parse_set(sent, ld, d, lw, w, le, d.left.next, lcost, opts);
                        }
                        if (d.left.multi) {
                            ls[2] = this.parse_set(sent, ld, d, lw, w, le.next, d.left, lcost, opts);
                        }
                        if (le.multi && d.left.multi) {
                            ls[3] = this.parse_set(sent, ld, d, lw, w, le, d.left, lcost, opts);
                        }
                    }
                    if (Rmatch) {
                        rs[0] = this.parse_set(sent, d, rd, w, rw, d.right.next, re.next, rcost, opts);
                        if (d.right.multi) {
                            rs[1] = this.parse_set(sent, d, rd, w, rw, d.right, re.next, rcost, opts);
                        }
                        if (re.multi) {
                            rs[2] = this.parse_set(sent, d, rd, w, rw, d.right.next, re, rcost, opts);
                        }
                        if (d.right.multi && re.multi) {
                            rs[3] = this.parse_set(sent, d, rd, w, rw, d.right, re, rcost, opts);
                        }
                    }
                    for (i = 0; i < 4; ++i) {
                        if (ls[i] == null) continue;
                        for (int j = 0; j < 4; ++j) {
                            if (rs[j] == null) continue;
                            a_choice = new ParseChoice(ls[i], lw, w, le, d.left, rs[j], w, rw, d.right, re, ld, d, rd);
                            xt.set.put_choice_in_set(a_choice);
                        }
                    }
                    if ((ls[0] != null || ls[1] != null || ls[2] != null || ls[3] != null) && (rset = this.parse_set(sent, d, rd, w, rw, d.right, re, rcost, opts)) != null) {
                        for (i = 0; i < 4; ++i) {
                            if (ls[i] == null) continue;
                            a_choice = new ParseChoice(ls[i], lw, w, le, d.left, rset, w, rw, null, re, ld, d, rd);
                            xt.set.put_choice_in_set(a_choice);
                        }
                    }
                    if (le != null || rs[0] == null && rs[1] == null && rs[2] == null && rs[3] == null || (lset = this.parse_set(sent, ld, d, lw, w, le, d.left, lcost, opts)) == null) continue;
                    for (i = 0; i < 4; ++i) {
                        if (rs[i] == null) continue;
                        a_choice = new ParseChoice(lset, lw, w, null, d.left, rs[i], w, rw, d.right, re, ld, d, rd);
                        xt.set.put_choice_in_set(a_choice);
                    }
                }
                m3 = m3.next;
            }
        }
        xt.set.current = xt.set.first;
        return xt.set;
    }

    void free_x_table() {
        this.x_table_size = 0;
        this.x_table = null;
    }

    XTableConnector x_table_pointer(int lw, int rw, Connector le, Connector re, int cost) {
        XTableConnector t = this.x_table[this.x_hash(lw, rw, le, re, cost)];
        while (t != null) {
            if (t.lw == lw && t.rw == rw && t.le == le && t.re == re && t.cost == cost) {
                return t;
            }
            t = t.next;
        }
        return null;
    }

    XTableConnector x_table_store(int lw, int rw, Connector le, Connector re, int cost, ParseSet set) {
        XTableConnector t;
        XTableConnector n = new XTableConnector();
        n.set = set;
        n.lw = lw;
        n.rw = rw;
        n.le = le;
        n.re = re;
        n.cost = cost;
        int h2 = this.x_hash(lw, rw, le, re, cost);
        n.next = t = this.x_table[h2];
        this.x_table[h2] = n;
        return n;
    }

    void x_table_update(int lw, int rw, Connector le, Connector re, int cost, ParseSet set) {
        XTableConnector t = this.x_table_pointer(lw, rw, le, re, cost);
        if (t == null) {
            throw new RuntimeException("This entry is supposed to be in the x_table.");
        }
        t.set = set;
    }

    int x_hash(int lw, int rw, Connector le, Connector re, int cost) {
        int i = 0;
        i = i + (i << 1) + MyRandom.randtable[lw + i & 0xFF];
        i = i + (i << 1) + MyRandom.randtable[rw + i & 0xFF];
        i = i + (i << 1) + MyRandom.randtable[((le == null ? 0 : le.hashCode()) + i) % (this.x_table_size + 1) & 0xFF];
        i = i + (i << 1) + MyRandom.randtable[((re == null ? 0 : re.hashCode()) + i) % (this.x_table_size + 1) & 0xFF];
        i = i + (i << 1) + MyRandom.randtable[cost + i & 0xFF];
        return i & this.x_table_size - 1;
    }

    void height_dfs(int w, int height) {
        if (dfs_height[w] != 0) {
            return;
        }
        ParseInfo.dfs_height[w] = height;
        ListOfLinks lol = word_links[w];
        while (lol != null) {
            this.height_dfs(lol.word, height - lol.dir);
            lol = lol.next;
        }
    }

    static DISNode build_DISNode(int w) {
        DISNode dn = new DISNode();
        dn.word = w;
        dn.lol = null;
        dn.cl = ParseInfo.c_dfs(w, dn, null);
        return dn;
    }

    static CONList c_dfs(int w, DISNode start_dn, CONList c) {
        if (dfs_root_word[w] != -1) {
            if (dfs_root_word[w] != start_dn.word) {
                Sentence.structure_violation = true;
            }
            return c;
        }
        ParseInfo.dfs_root_word[w] = start_dn.word;
        ListOfLinks lol = word_links[w];
        while (lol != null) {
            if (lol.dir < 0) {
                if (dfs_root_word[lol.word] == -1) {
                    Sentence.structure_violation = true;
                }
            } else if (lol.dir == 0) {
                ListOfLinks lolx = new ListOfLinks();
                lolx.next = start_dn.lol;
                lolx.link = lol.link;
                start_dn.lol = lolx;
                c = ParseInfo.c_dfs(lol.word, start_dn, c);
            }
            lol = lol.next;
        }
        if (ParseInfo.is_CON_word(w)) {
            CONList cx = new CONList();
            cx.next = c;
            c = cx;
            c.cn = ParseInfo.build_CONNode(w);
        }
        return c;
    }

    static boolean is_CON_word(int w) {
        ListOfLinks lol = word_links[w];
        while (lol != null) {
            if (lol.dir == 1) {
                return true;
            }
            lol = lol.next;
        }
        return false;
    }

    static CONNode build_CONNode(int w) {
        DISList d = null;
        ListOfLinks lol = word_links[w];
        while (lol != null) {
            if (lol.dir == 1) {
                DISList dx = new DISList();
                dx.next = d;
                d = dx;
                d.dn = ParseInfo.build_DISNode(lol.word);
            }
            lol = lol.next;
        }
        CONNode a = new CONNode();
        a.dl = a.current = d;
        a.word = w;
        return a;
    }
}

