/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import net.sf.jlinkgrammar.PPKnowledge;
import net.sf.jlinkgrammar.PPLabelNode;

public class PPLexTable {
    public String[] labels = new String[512];
    public PPLabelNode[] nodes_of_label = new PPLabelNode[512];
    public PPLabelNode[] last_node_of_label = new PPLabelNode[512];
    public PPLabelNode current_node_of_active_label;
    public int idx_of_active_label;
    private int yylineno;

    PPLexTable() {
        for (int i = 0; i < 512; ++i) {
            this.nodes_of_label[i] = null;
            this.last_node_of_label[i] = null;
            this.labels[i] = null;
        }
    }

    public boolean pp_lexer_set_label(String label) {
        this.idx_of_active_label = this.get_index_of_label(label);
        if (this.idx_of_active_label == -1) {
            return false;
        }
        this.current_node_of_active_label = this.nodes_of_label[this.idx_of_active_label];
        return true;
    }

    private int get_index_of_label(String label) {
        int i = 0;
        while (this.labels[i] != null) {
            if (this.labels[i].equals(label)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int pp_lexer_count_tokens_of_label() {
        if (this.idx_of_active_label == -1) {
            throw new RuntimeException("pp_lexer: current label is invalid");
        }
        int n = 0;
        PPLabelNode p = this.nodes_of_label[this.idx_of_active_label];
        while (p != null) {
            p = p.next;
            ++n;
        }
        return n;
    }

    public String pp_lexer_get_next_token_of_label() {
        if (this.current_node_of_active_label == null) {
            return null;
        }
        String p = this.current_node_of_active_label.str;
        this.current_node_of_active_label = this.current_node_of_active_label.next;
        return p;
    }

    public void set_label(String label) {
        int i = 0;
        while (this.labels[i] != null && !this.labels[i].equals(label)) {
            ++i;
        }
        if (this.labels[i] != null) {
            throw new RuntimeException("pp_lexer: label " + label + " multiply defined!");
        }
        if (i == 511) {
            throw new RuntimeException("pp_lexer: too many labels. Raise PP_LEXER_MAX_LABELS");
        }
        this.labels[i] = label;
        this.idx_of_active_label = i;
    }

    public void add_string_to_label(String str) {
        if (this.idx_of_active_label == -1) {
            throw new RuntimeException("pp_lexer: invalid syntax (line " + this.yylineno + ")");
        }
        if (str.length() > 0 && str.charAt(0) == '@') {
            this.add_set_of_strings_to_label(str.substring(1));
            return;
        }
        PPLexTable.check_string(str);
        PPLabelNode new_node = new PPLabelNode();
        new_node.str = str;
        new_node.next = null;
        if (this.last_node_of_label[this.idx_of_active_label] == null) {
            this.nodes_of_label[this.idx_of_active_label] = new_node;
            this.last_node_of_label[this.idx_of_active_label] = new_node;
        } else {
            this.last_node_of_label[this.idx_of_active_label].next = new_node;
            this.last_node_of_label[this.idx_of_active_label] = new_node;
        }
    }

    public void add_set_of_strings_to_label(String label_of_set) {
        if (this.idx_of_active_label == -1) {
            throw new RuntimeException("pp_lexer: invalid syntax (line " + this.yylineno + ")");
        }
        int idx_of_label_of_set = this.get_index_of_label(label_of_set);
        if (idx_of_label_of_set == -1) {
            throw new RuntimeException("pp_lexer: label " + label_of_set + " must be defined before it's referred to (line " + this.yylineno + ")");
        }
        PPLabelNode p = this.nodes_of_label[idx_of_label_of_set];
        while (p != null) {
            this.add_string_to_label(p.str);
            p = p.next;
        }
    }

    static void check_string(String str) {
        if (str.length() > 1 && str.indexOf(44) >= 0) {
            throw new RuntimeException("pp_lexer: string " + str + " contains a comma, which is a no-no.");
        }
    }

    public String[] pp_lexer_get_next_group_of_tokens_of_label() {
        PPLabelNode p = this.current_node_of_active_label;
        int n = 0;
        while (p != null && !p.str.equals(",")) {
            ++n;
            p = p.next;
        }
        String[] tokens = new String[n];
        p = this.current_node_of_active_label;
        n = 0;
        while (p != null && !p.str.equals(",")) {
            tokens[n] = p.str;
            ++n;
            p = p.next;
        }
        this.current_node_of_active_label = p;
        if (p != null) {
            this.current_node_of_active_label = p.next;
        }
        return tokens;
    }

    public int pp_lexer_count_commas_of_label() {
        if (this.idx_of_active_label == -1) {
            throw new RuntimeException("pp_lexer: current label is invalid");
        }
        int n = 0;
        PPLabelNode p = this.nodes_of_label[this.idx_of_active_label];
        while (p != null) {
            if (p.str.equals(",")) {
                ++n;
            }
            p = p.next;
        }
        return n;
    }

    public void yylex(PPKnowledge ppknowledge, Reader f) throws IOException {
        BufferedReader r = new BufferedReader(f);
        String line = r.readLine();
        this.yylineno = 0;
        StringBuffer token = new StringBuffer();
        while (line != null) {
            boolean quoteMode = false;
            for (int i = 0; i < line.length(); ++i) {
                if (quoteMode) {
                    if (line.charAt(i) == '\"') {
                        quoteMode = false;
                        this.add_string_to_label(token.toString());
                        token.setLength(0);
                        continue;
                    }
                    token.append(line.charAt(i));
                    continue;
                }
                if (line.charAt(i) == ';') {
                    if (token.length() <= 0) break;
                    this.add_string_to_label(token.toString());
                    token.setLength(0);
                    break;
                }
                if (line.charAt(i) == ':') {
                    this.set_label(token.toString());
                    token.setLength(0);
                    continue;
                }
                if (line.charAt(i) == ',') {
                    if (token.length() > 0) {
                        this.add_string_to_label(token.toString());
                        token.setLength(0);
                    }
                    this.add_string_to_label(token.toString());
                    continue;
                }
                if (line.charAt(i) == '\"') {
                    if (token.length() > 0) {
                        this.add_string_to_label(token.toString());
                        token.setLength(0);
                    }
                    quoteMode = true;
                    continue;
                }
                if (line.charAt(i) == ' ' || line.charAt(i) == '\t') {
                    if (token.length() <= 0) continue;
                    this.add_string_to_label(token.toString());
                    token.setLength(0);
                    continue;
                }
                token.append(line.charAt(i));
            }
            if (quoteMode) {
                throw new RuntimeException("post_process: open string at line " + this.yylineno);
            }
            if (token.length() > 0) {
                this.add_string_to_label(token.toString());
                token.setLength(0);
            }
            line = r.readLine();
            ++this.yylineno;
        }
    }
}

