/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.io.IOException;
import java.io.Reader;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.PPLexTable;
import net.sf.jlinkgrammar.PPLinkset;
import net.sf.jlinkgrammar.PPRule;
import net.sf.jlinkgrammar.ParseOptions;
import net.sf.jlinkgrammar.StartingLinkAndDomain;

public class PPKnowledge {
    PPLexTable lt;
    String path;
    PPLinkset domain_starter_links;
    PPLinkset urfl_domain_starter_links;
    PPLinkset urfl_only_domain_starter_links;
    PPLinkset domain_contains_links;
    PPLinkset must_form_a_cycle_links;
    PPLinkset restricted_links;
    PPLinkset ignore_these_links;
    PPLinkset left_domain_starter_links;
    PPRule[] connected_rules;
    PPRule[] form_a_cycle_rules;
    PPRule[] contains_one_rules;
    PPRule[] contains_none_rules;
    PPRule[] bounded_rules;
    int n_connected_rules;
    int n_form_a_cycle_rules;
    int n_contains_one_rules;
    int n_contains_none_rules;
    int n_bounded_rules;
    PPLinkset set_of_links_starting_bounded_domain;
    StartingLinkAndDomain[] starting_link_lookup_table;
    int nStartingLinks;

    public PPKnowledge(ParseOptions opts, String dictname, String path) throws IOException {
        Reader f = Dictionary.dictopen(opts, dictname, path);
        if (f == null) {
            throw new RuntimeException("pp_lexer_open: passed a null file");
        }
        this.lt = new PPLexTable();
        Reader f1 = f;
        this.lt.yylex(this, f1);
        this.lt.idx_of_active_label = -1;
        f.close();
        this.path = path;
        this.read_starting_link_table();
        this.read_link_sets(opts);
        this.read_rules(opts);
        this.initialize_set_of_links_starting_bounded_domain();
    }

    private void read_rules(ParseOptions opts) {
        this.read_form_a_cycle_rules(opts, "FORM_A_CYCLE_RULES");
        this.read_connected_rule(opts, "CONNECTED_RULES");
        this.read_bounded_rules(opts, "BOUNDED_RULES");
        this.contains_one_rules = this.read_contains_rules(opts, "CONTAINS_ONE_RULES");
        this.n_contains_one_rules = this.contains_one_rules.length - 1;
        this.contains_none_rules = this.read_contains_rules(opts, "CONTAINS_NONE_RULES");
        this.n_contains_none_rules = this.contains_none_rules.length - 1;
    }

    private void read_connected_rule(ParseOptions opts, String label) {
        this.connected_rules = new PPRule[1];
        this.connected_rules[0] = new PPRule();
        if (!this.lt.pp_lexer_set_label(label)) {
            this.connected_rules[0].msg = null;
            if (opts.verbosity > 0) {
                opts.out.println("PP warning: Not using 'link is connected' rule");
            }
            return;
        }
        if (this.lt.pp_lexer_count_tokens_of_label() > 1) {
            throw new RuntimeException("post_process: Invalid syntax in " + label);
        }
        this.connected_rules[0].msg = this.lt.pp_lexer_get_next_token_of_label();
    }

    private void read_form_a_cycle_rules(ParseOptions opts, String label) {
        if (!this.lt.pp_lexer_set_label(label)) {
            this.n_form_a_cycle_rules = 0;
            if (opts.verbosity > 0) {
                opts.out.println("PP warning: Not using any 'form a cycle' rules");
            }
        } else {
            int n_commas = this.lt.pp_lexer_count_commas_of_label();
            this.n_form_a_cycle_rules = (n_commas + 1) / 2;
        }
        this.form_a_cycle_rules = new PPRule[1 + this.n_form_a_cycle_rules];
        for (int r = 0; r < this.n_form_a_cycle_rules; ++r) {
            String[] tokens = this.lt.pp_lexer_get_next_group_of_tokens_of_label();
            int n_tokens = tokens.length;
            if (n_tokens <= 0) {
                throw new RuntimeException("syntax error in knowledge file");
            }
            PPLinkset lsHandle = PPLinkset.PPLinkset_open(n_tokens);
            for (int i = 0; i < n_tokens; ++i) {
                PPLinkset.PPLinkset_add(lsHandle, tokens[i]);
            }
            this.form_a_cycle_rules[r] = new PPRule();
            this.form_a_cycle_rules[r].link_set = lsHandle;
            tokens = this.lt.pp_lexer_get_next_group_of_tokens_of_label();
            n_tokens = tokens.length;
            if (n_tokens > 1) {
                throw new RuntimeException("post_process: Invalid syntax: rule " + (r + 1) + " of " + label);
            }
            this.form_a_cycle_rules[r].msg = tokens[0];
        }
        this.form_a_cycle_rules[this.n_form_a_cycle_rules] = new PPRule();
        this.form_a_cycle_rules[this.n_form_a_cycle_rules].msg = null;
    }

    private void read_bounded_rules(ParseOptions opts, String label) {
        if (!this.lt.pp_lexer_set_label(label)) {
            this.n_bounded_rules = 0;
            if (opts.verbosity > 0) {
                opts.out.println("PP warning: Not using any 'bounded' rules");
            }
        } else {
            int n_commas = this.lt.pp_lexer_count_commas_of_label();
            this.n_bounded_rules = (n_commas + 1) / 2;
        }
        this.bounded_rules = new PPRule[1 + this.n_bounded_rules];
        for (int r = 0; r < this.n_bounded_rules; ++r) {
            String[] tokens = this.lt.pp_lexer_get_next_group_of_tokens_of_label();
            int n_tokens = tokens.length;
            if (n_tokens != 1) {
                throw new RuntimeException("post_process: Invalid syntax: rule " + (r + 1) + " of " + label);
            }
            this.bounded_rules[r] = new PPRule();
            this.bounded_rules[r].domain = tokens[0].charAt(0);
            tokens = this.lt.pp_lexer_get_next_group_of_tokens_of_label();
            n_tokens = tokens.length;
            if (n_tokens != 1) {
                throw new RuntimeException("post_process: Invalid syntax: rule " + (r + 1) + " of " + label);
            }
            this.bounded_rules[r].msg = tokens[0];
        }
        this.bounded_rules[this.n_bounded_rules] = new PPRule();
        this.bounded_rules[this.n_bounded_rules].msg = null;
    }

    private PPRule[] read_contains_rules(ParseOptions opts, String label) {
        int nRules;
        if (!this.lt.pp_lexer_set_label(label)) {
            nRules = 0;
            if (opts.verbosity > 0) {
                opts.out.println("PP warning: Not using any " + label + " rules");
            }
        } else {
            int n_commas = this.lt.pp_lexer_count_commas_of_label();
            nRules = (n_commas + 1) / 3;
        }
        PPRule[] rules = new PPRule[1 + nRules];
        for (int r = 0; r < nRules; ++r) {
            String[] tokens = this.lt.pp_lexer_get_next_group_of_tokens_of_label();
            int n_tokens = tokens.length;
            if (n_tokens > 1) {
                throw new RuntimeException("post_process: Invalid syntax in " + label + " (rule " + (r + 1) + ")");
            }
            rules[r] = new PPRule();
            rules[r].selector = tokens[0];
            tokens = this.lt.pp_lexer_get_next_group_of_tokens_of_label();
            n_tokens = tokens.length;
            rules[r].link_set = PPLinkset.PPLinkset_open(n_tokens);
            rules[r].link_set_size = n_tokens;
            rules[r].link_array = new String[1 + n_tokens];
            for (int i = 0; i < n_tokens; ++i) {
                String p = tokens[i];
                PPLinkset.PPLinkset_add(rules[r].link_set, p);
                rules[r].link_array[i] = p;
            }
            rules[r].link_array[i] = null;
            tokens = this.lt.pp_lexer_get_next_group_of_tokens_of_label();
            n_tokens = tokens.length;
            if (n_tokens > 1) {
                throw new RuntimeException("post_process: Invalid syntax in " + label + " (rule " + (r + 1) + ")");
            }
            rules[r].msg = tokens[0];
        }
        rules[nRules] = new PPRule();
        rules[nRules].msg = null;
        return rules;
    }

    private void initialize_set_of_links_starting_bounded_domain() {
        this.set_of_links_starting_bounded_domain = PPLinkset.PPLinkset_open(1024);
        int i = 0;
        while (this.bounded_rules[i].msg != null) {
            int d;
            int domain_of_rule = this.bounded_rules[i].domain;
            int j = 0;
            while ((d = this.starting_link_lookup_table[j].domain) != -1) {
                if (d == domain_of_rule) {
                    PPLinkset.PPLinkset_add(this.set_of_links_starting_bounded_domain, this.starting_link_lookup_table[j].starting_link);
                }
                ++j;
            }
            ++i;
        }
    }

    private PPLinkset read_link_set(ParseOptions opts, String label) {
        int n_strings;
        if (!this.lt.pp_lexer_set_label(label)) {
            if (opts.verbosity > 0) {
                opts.out.println("PP warning: Link set " + label + " not defined: assuming empty.");
            }
            n_strings = 0;
        } else {
            n_strings = this.lt.pp_lexer_count_tokens_of_label();
        }
        PPLinkset ls = PPLinkset.PPLinkset_open(n_strings);
        for (int i = 0; i < n_strings; ++i) {
            PPLinkset.PPLinkset_add(ls, this.lt.pp_lexer_get_next_token_of_label());
        }
        return ls;
    }

    private void read_link_sets(ParseOptions opts) {
        this.domain_starter_links = this.read_link_set(opts, "DOMAIN_STARTER_LINKS");
        this.urfl_domain_starter_links = this.read_link_set(opts, "URFL_DOMAIN_STARTER_LINKS");
        this.domain_contains_links = this.read_link_set(opts, "DOMAIN_CONTAINS_LINKS");
        this.ignore_these_links = this.read_link_set(opts, "IGNORE_THESE_LINKS");
        this.restricted_links = this.read_link_set(opts, "RESTRICTED_LINKS");
        this.must_form_a_cycle_links = this.read_link_set(opts, "MUST_FORM_A_CYCLE_LINKS");
        this.urfl_only_domain_starter_links = this.read_link_set(opts, "URFL_ONLY_DOMAIN_STARTER_LINKS");
        this.left_domain_starter_links = this.read_link_set(opts, "LEFT_DOMAIN_STARTER_LINKS");
    }

    private void read_starting_link_table() {
        String label = "STARTING_LINK_TYPE_TABLE";
        if (!this.lt.pp_lexer_set_label(label)) {
            throw new RuntimeException("post_process: Couldn't find starting link table " + label);
        }
        int n_tokens = this.lt.pp_lexer_count_tokens_of_label();
        if (n_tokens % 2 != 0) {
            throw new RuntimeException("post_process: Link table must have format [<link> <domain name>]+");
        }
        this.nStartingLinks = n_tokens / 2;
        this.starting_link_lookup_table = new StartingLinkAndDomain[1 + this.nStartingLinks];
        for (int i = 0; i < this.nStartingLinks; ++i) {
            this.starting_link_lookup_table[i] = new StartingLinkAndDomain();
            this.starting_link_lookup_table[i].starting_link = this.lt.pp_lexer_get_next_token_of_label();
            String p = this.lt.pp_lexer_get_next_token_of_label();
            PPKnowledge.check_domain_is_legal(p);
            this.starting_link_lookup_table[i].domain = p.charAt(0);
        }
        this.starting_link_lookup_table[this.nStartingLinks] = new StartingLinkAndDomain();
        this.starting_link_lookup_table[this.nStartingLinks].domain = -1;
    }

    static void check_domain_is_legal(String p) {
        if (p.length() > 1) {
            throw new RuntimeException("post_process: Domain (" + p + ") must be a single character");
        }
    }
}

