/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.util.ArrayList;
import java.util.StringTokenizer;
import net.sf.jlinkgrammar.CNode;
import net.sf.jlinkgrammar.Constituent;
import net.sf.jlinkgrammar.DISNode;
import net.sf.jlinkgrammar.DTypeList;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.Domain;
import net.sf.jlinkgrammar.GlobalBean;
import net.sf.jlinkgrammar.Link;
import net.sf.jlinkgrammar.LinkageInfo;
import net.sf.jlinkgrammar.ListOfLinks;
import net.sf.jlinkgrammar.MyRandom;
import net.sf.jlinkgrammar.PPInfo;
import net.sf.jlinkgrammar.PPNode;
import net.sf.jlinkgrammar.ParseInfo;
import net.sf.jlinkgrammar.ParseOptions;
import net.sf.jlinkgrammar.Postprocessor;
import net.sf.jlinkgrammar.Sentence;
import net.sf.jlinkgrammar.Sublinkage;

public class Linkage {
    private int num_words;
    public ArrayList<String> word = new ArrayList();
    public LinkageInfo info;
    public int num_sublinkages;
    public int current;
    public Sublinkage[] sublinkage;
    public boolean unionized;
    public Sentence sent;
    public ParseOptions opts;
    private static int[][] word_used = new int[16][250];
    private static int[] link_heights = new int[497];
    private static int[] row_starts = new int[250];
    private static int N_rows;
    private static int N_words_to_print;
    private static int[] center;
    private static Constituent[] constituent;
    private static int[] templist;
    private static int r_limit;
    public static LinkageAndList[] andlist;
    public static int[] wordtype;
    public static char[][] picture;
    public static char[][] xpicture;

    public void setSentence(Sentence sent) {
        this.sent = sent;
    }

    public void setParseOptions(ParseOptions opts) {
        this.opts = opts;
    }

    public Linkage(int k, Sentence sent, ParseOptions opts) {
        int i;
        if (k >= sent.num_linkages_post_processed || k < 0) {
            throw new RuntimeException("index out of range");
        }
        for (i = 0; i < constituent.length; ++i) {
            Linkage.constituent[i] = new Constituent();
        }
        for (i = 0; i < andlist.length; ++i) {
            Linkage.andlist[i] = new LinkageAndList();
        }
        this.current = 0;
        this.num_sublinkages = 0;
        this.sublinkage = null;
        this.unionized = false;
        this.sent = sent;
        this.opts = opts;
        this.info = sent.link_info[k];
        Linkage.extract_links(sent.link_info[k].index, sent.null_count, sent.parse_info);
        this.compute_chosen_words(sent);
        if (sent.set_has_fat_down()) {
            this.extract_fat_linkage(sent, opts);
        } else {
            this.extract_thin_linkage(sent, opts);
        }
        if (sent.dict.postprocessor != null) {
            this.linkage_post_process(sent.dict.postprocessor);
        }
    }

    void compute_chosen_words(Sentence sent) {
        int i;
        ParseInfo pi = sent.parse_info;
        this.num_words = sent.size();
        String[] chosen_words = new String[250];
        for (i = 0; i < sent.word.size(); ++i) {
            String t;
            chosen_words[i] = sent.word.get((int)i).string;
            if (pi.chosen_disjuncts[i] == null) {
                chosen_words[i] = t = "[" + chosen_words[i] + "]";
                continue;
            }
            if (!this.opts.display_word_subscripts) continue;
            t = pi.chosen_disjuncts[i].string;
            if (Dictionary.is_idiom_word(t)) {
                int idx = t.indexOf(46);
                if (idx >= 0) {
                    t = t.substring(0, idx);
                }
                chosen_words[i] = t;
                continue;
            }
            chosen_words[i] = t;
        }
        if (sent.dict.left_wall_defined) {
            chosen_words[0] = "LEFT-WALL";
        }
        if (sent.dict.right_wall_defined) {
            chosen_words[sent.size() - 1] = "RIGHT-WALL";
        }
        for (i = 0; i < sent.size(); ++i) {
            this.word.add(chosen_words[i]);
        }
    }

    static void extract_links(int index, int cost, ParseInfo pi) {
        pi.initialize_links();
        if (index < 0) {
            MyRandom.my_random_initialize(index);
            pi.list_random_links(pi.parse_set);
            MyRandom.my_random_finalize();
        } else {
            pi.list_links(pi.parse_set, index);
        }
    }

    void extract_thin_linkage(Sentence sent, ParseOptions opts) {
        ParseInfo pi = sent.parse_info;
        this.sublinkage = new Sublinkage[1];
        this.sublinkage[0] = new Sublinkage(pi);
        sent.compute_link_names();
        for (int i = 0; i < pi.N_links; ++i) {
            this.sublinkage[0].link[i] = pi.link_array[i];
        }
        this.num_sublinkages = 1;
    }

    public void extract_fat_linkage(Sentence sent, ParseOptions opts) {
        int i;
        ParseInfo pi = sent.parse_info;
        Sublinkage sublinkage = new Sublinkage(pi);
        pi.build_digraph();
        Sentence.structure_violation = false;
        DISNode d_root = pi.build_DIS_CON_tree();
        if (Sentence.structure_violation) {
            int i2;
            sent.compute_link_names();
            for (i2 = 0; i2 < pi.N_links; ++i2) {
                sublinkage.link[i2] = pi.link_array[i2];
            }
            this.num_sublinkages = 1;
            this.sublinkage = new Sublinkage[1];
            this.sublinkage[0] = new Sublinkage(pi);
            for (i2 = 0; i2 < pi.N_links; ++i2) {
                this.sublinkage[0].link[i2] = sublinkage.link[i2];
            }
            return;
        }
        this.num_sublinkages = 0;
        do {
            ++this.num_sublinkages;
        } while (d_root.advance_DIS());
        this.sublinkage = new Sublinkage[this.num_sublinkages];
        for (i = 0; i < this.num_sublinkages; ++i) {
            this.sublinkage[i] = new Sublinkage();
            this.sublinkage[i].pp_info = null;
            this.sublinkage[i].violation = null;
        }
        sent.compute_link_names();
        int idx = 0;
        do {
            for (i = 0; i < pi.N_links; ++i) {
                sent.patch_array[i].changed = false;
                sent.patch_array[i].used = false;
                sent.patch_array[i].newl = pi.link_array[i].l;
                sent.patch_array[i].newr = pi.link_array[i].r;
                sublinkage.link[i] = new Link();
                sublinkage.link[i].l = pi.link_array[i].l;
                sublinkage.link[i].lc = pi.link_array[i].lc;
                sublinkage.link[i].r = pi.link_array[i].r;
                sublinkage.link[i].rc = pi.link_array[i].rc;
                sublinkage.link[i].name = pi.link_array[i].name;
            }
            sent.fill_patch_array_DIS(d_root, null);
            for (i = 0; i < pi.N_links; ++i) {
                if (sent.patch_array[i].changed || sent.patch_array[i].used) {
                    sublinkage.link[i].l = sent.patch_array[i].newl;
                    sublinkage.link[i].r = sent.patch_array[i].newr;
                    continue;
                }
                if (ParseInfo.dfs_root_word[pi.link_array[i].l] == -1 || ParseInfo.dfs_root_word[pi.link_array[i].r] == -1) continue;
                sublinkage.link[i].l = -1;
            }
            sent.compute_pp_link_array_connectors(sublinkage);
            sent.compute_pp_link_names(sublinkage);
            int N_thin_links = 0;
            for (i = 0; i < pi.N_links; ++i) {
                if (sublinkage.link[i].l == -1) continue;
                ++N_thin_links;
            }
            this.sublinkage[idx].num_links = N_thin_links;
            this.sublinkage[idx].link = new Link[N_thin_links];
            this.sublinkage[idx].pp_info = null;
            this.sublinkage[idx].violation = null;
            int j = 0;
            for (i = 0; i < pi.N_links; ++i) {
                if (sublinkage.link[i].l == -1) continue;
                this.sublinkage[idx].link[j++] = sublinkage.link[i];
            }
            ++idx;
        } while (d_root.advance_DIS());
    }

    public int linkage_unused_word_cost() {
        return this.info.unused_word_cost;
    }

    public int linkage_disjunct_cost() {
        return this.info.disjunct_cost;
    }

    public int linkage_and_cost() {
        return this.info.and_cost;
    }

    public int linkage_link_cost() {
        return this.info.link_cost;
    }

    public int linkage_get_num_sublinkages() {
        return this.num_sublinkages;
    }

    public int linkage_get_num_words() {
        return this.num_words;
    }

    public int linkage_get_num_links() {
        return this.sublinkage[this.current].num_links;
    }

    private boolean verify_link_index(int index) {
        return index >= 0 && index < this.sublinkage[this.current].num_links;
    }

    public boolean linkage_set_current_sublinkage(int index) {
        if (index < 0 || index >= this.num_sublinkages) {
            return false;
        }
        this.current = index;
        return true;
    }

    public Sentence linkage_get_sentence() {
        return this.sent;
    }

    boolean links_are_equal(Link l, Link m3) {
        return l.l == m3.l && l.r == m3.r && l.name.equals(m3.name);
    }

    boolean link_already_appears(Link link, int a) {
        for (int i = 0; i < a; ++i) {
            for (int j = 0; j < this.sublinkage[i].num_links; ++j) {
                if (!this.links_are_equal(this.sublinkage[i].link[j], link)) continue;
                return true;
            }
        }
        return false;
    }

    Sublinkage unionize_linkage() {
        Link link;
        int j;
        int i;
        int num_in_union = 0;
        Sublinkage u = new Sublinkage();
        for (i = 0; i < this.num_sublinkages; ++i) {
            for (j = 0; j < this.sublinkage[i].num_links; ++j) {
                link = this.sublinkage[i].link[j];
                if (this.link_already_appears(link, i)) continue;
                ++num_in_union;
            }
        }
        u.num_links = num_in_union;
        u.link = new Link[num_in_union];
        u.pp_info = new PPInfo[num_in_union];
        u.violation = null;
        num_in_union = 0;
        for (i = 0; i < this.num_sublinkages; ++i) {
            for (j = 0; j < this.sublinkage[i].num_links; ++j) {
                link = this.sublinkage[i].link[j];
                if (this.link_already_appears(link, i)) continue;
                u.link[num_in_union] = link;
                u.pp_info[num_in_union] = this.sublinkage[i].pp_info[j];
                String p = this.sublinkage[i].violation;
                if (p != null && u.violation == null) {
                    u.violation = p;
                }
                ++num_in_union;
            }
        }
        return u;
    }

    public int linkage_compute_union() {
        int i;
        int num_subs = this.num_sublinkages;
        if (this.unionized) {
            this.current = this.num_sublinkages - 1;
            return 0;
        }
        if (num_subs == 1) {
            this.unionized = true;
            return 1;
        }
        Sublinkage[] new_sublinkage = new Sublinkage[num_subs + 1];
        for (i = 0; i < num_subs; ++i) {
            new_sublinkage[i] = this.sublinkage[i];
        }
        this.sublinkage = new_sublinkage;
        this.sublinkage[num_subs] = this.unionize_linkage();
        this.sublinkage[num_subs].pp_data.N_domains = 0;
        this.sublinkage[num_subs].pp_data.length = 0;
        this.sublinkage[num_subs].pp_data.links_to_ignore = null;
        for (i = 0; i < 250; ++i) {
            this.sublinkage[num_subs].pp_data.word_links[i] = null;
        }
        ++this.num_sublinkages;
        this.unionized = true;
        this.current = this.num_sublinkages - 1;
        return 1;
    }

    public void process_linkage(ParseOptions opts) {
        String string;
        int first_sublinkage;
        if (opts.parse_options_get_display_union()) {
            this.linkage_compute_union();
            first_sublinkage = this.linkage_get_num_sublinkages() - 1;
        } else {
            first_sublinkage = 0;
        }
        for (int j = first_sublinkage; j < this.linkage_get_num_sublinkages(); ++j) {
            this.linkage_set_current_sublinkage(j);
            if (opts.parse_options_get_display_on()) {
                string = this.linkage_print_diagram();
                opts.out.println(string);
            }
            if (opts.parse_options_get_display_links()) {
                string = this.linkage_print_links_and_domains();
                opts.out.print(string);
            }
            if (!opts.parse_options_get_display_postscript()) continue;
            string = this.linkage_print_postscript(0);
            opts.out.println(string);
        }
        int mode = opts.parse_options_get_display_constituents();
        if (mode != 0) {
            string = this.linkage_print_constituent_tree(mode);
            if (string != null) {
                opts.out.println(string);
            } else {
                opts.out.println("Can't generate constituents.");
                opts.out.println("Constituent processing has been turned off.");
            }
        }
    }

    public String linkage_get_word(int w) {
        return this.word.get(w);
    }

    public String linkage_get_link_label(int index) {
        if (!this.verify_link_index(index)) {
            return null;
        }
        Link link = this.sublinkage[this.current].link[index];
        return link.name;
    }

    public String linkage_get_link_llabel(int index) {
        if (!this.verify_link_index(index)) {
            return null;
        }
        Link link = this.sublinkage[this.current].link[index];
        return link.lc.string;
    }

    public String linkage_get_link_rlabel(int index) {
        if (!this.verify_link_index(index)) {
            return null;
        }
        Link link = this.sublinkage[this.current].link[index];
        return link.rc.string;
    }

    public int linkage_get_link_rword(int index) {
        if (!this.verify_link_index(index)) {
            return -1;
        }
        Link link = this.sublinkage[this.current].link[index];
        return link.r;
    }

    public int linkage_get_link_lword(int index) {
        if (!this.verify_link_index(index)) {
            return -1;
        }
        Link link = this.sublinkage[this.current].link[index];
        return link.l;
    }

    public int linkage_get_link_num_domains(int index) {
        if (!this.verify_link_index(index)) {
            return -1;
        }
        PPInfo pp_info = this.sublinkage[this.current].pp_info[index];
        return pp_info.num_domains;
    }

    public String[] linkage_get_link_domain_names(int index) {
        if (!this.verify_link_index(index)) {
            return null;
        }
        PPInfo pp_info = this.sublinkage[this.current].pp_info[index];
        return pp_info.domain_name;
    }

    public String linkage_get_violation_name() {
        return this.sublinkage[this.current].violation;
    }

    public boolean linkage_is_canonical() {
        return this.info.canonical;
    }

    public boolean linkage_is_improper() {
        return this.info.improper_fat_linkage;
    }

    public boolean linkage_has_inconsistent_domains() {
        return this.info.inconsistent_domains;
    }

    public String linkage_print_links_and_domains() {
        int link;
        int N_links = this.linkage_get_num_links();
        StringBuffer s2 = new StringBuffer();
        int longest = 0;
        for (link = 0; link < N_links; ++link) {
            if (this.linkage_get_link_lword(link) == -1 || this.linkage_get_link_num_domains(link) <= longest) continue;
            longest = this.linkage_get_link_num_domains(link);
        }
        for (link = 0; link < N_links; ++link) {
            int j;
            if (this.linkage_get_link_lword(link) == -1) continue;
            String[] dname = this.linkage_get_link_domain_names(link);
            for (j = 0; j < this.linkage_get_link_num_domains(link); ++j) {
                s2.append("(");
                s2.append(dname[j]);
                s2.append(")");
            }
            while (j < longest) {
                s2.append("    ");
                ++j;
            }
            s2.append("   ");
            this.print_a_link(s2, link);
        }
        s2.append("\n");
        if (this.linkage_get_violation_name() != null) {
            s2.append("P.P. violations:\n");
            s2.append("        ");
            s2.append(this.linkage_get_violation_name());
            s2.append("\n\n");
        }
        String links_string = s2.toString();
        return links_string;
    }

    public void print_a_link(StringBuffer s2, int link) {
        Sentence sent = this.linkage_get_sentence();
        Dictionary dict = sent.dict;
        int l = this.linkage_get_link_lword(link);
        int r = this.linkage_get_link_rword(link);
        String label = this.linkage_get_link_label(link);
        String llabel = this.linkage_get_link_llabel(link);
        String rlabel = this.linkage_get_link_rlabel(link);
        if (l == 0 && dict.left_wall_defined) {
            GlobalBean.left_append_string(s2, "LEFT-WALL", "               ");
        } else if (l == this.linkage_get_num_words() - 1 && dict.right_wall_defined) {
            GlobalBean.left_append_string(s2, "RIGHT-WALL", "               ");
        } else {
            GlobalBean.left_append_string(s2, this.linkage_get_word(l), "               ");
        }
        GlobalBean.left_append_string(s2, llabel, "     ");
        s2.append("   <---");
        GlobalBean.left_append_string(s2, label, "-----");
        s2.append("->  ");
        GlobalBean.left_append_string(s2, rlabel, "     ");
        s2.append("     ");
        s2.append(this.linkage_get_word(r));
        s2.append("\n");
    }

    public String build_linkage_postscript_string() {
        int j;
        boolean suppressor_used;
        boolean print_word_0 = false;
        boolean print_word_N = false;
        Sublinkage sublinkage = this.sublinkage[this.current];
        int N_links = sublinkage.num_links;
        Link[] ppla = sublinkage.link;
        Dictionary dict = this.sent.dict;
        StringBuffer string = new StringBuffer();
        int N_wall_connectors = 0;
        if (dict.left_wall_defined) {
            suppressor_used = false;
            if (!this.opts.display_walls) {
                for (j = 0; j < N_links; ++j) {
                    if (ppla[j].l != 0 || ppla[j].r == this.num_words - 1) continue;
                    ++N_wall_connectors;
                    if (!ppla[j].lc.string.equals("Wd")) continue;
                    suppressor_used = true;
                }
            }
            print_word_0 = !suppressor_used && N_wall_connectors != 0 || N_wall_connectors > 1 || this.opts.display_walls;
        } else {
            print_word_0 = true;
        }
        N_wall_connectors = 0;
        if (dict.right_wall_defined) {
            suppressor_used = false;
            for (j = 0; j < N_links; ++j) {
                if (ppla[j].r != this.num_words - 1) continue;
                ++N_wall_connectors;
                if (!ppla[j].lc.string.equals("RW")) continue;
                suppressor_used = true;
            }
            print_word_N = !suppressor_used && N_wall_connectors != 0 || N_wall_connectors > 1 || this.opts.display_walls;
        } else {
            print_word_N = true;
        }
        int d = print_word_0 ? 0 : 1;
        int i = 0;
        N_words_to_print = this.num_words;
        if (!print_word_N) {
            --N_words_to_print;
        }
        string.append("[");
        for (j = d; j < N_words_to_print; ++j) {
            if (i % 10 == 0 && i > 0) {
                string.append("\n");
            }
            ++i;
            string.append("(");
            string.append(this.word.get(j));
            string.append(")");
        }
        string.append("]");
        string.append("\n");
        string.append("[");
        j = 0;
        for (int link = 0; link < N_links; ++link) {
            if (!print_word_0 && ppla[link].l == 0 || !print_word_N && ppla[link].r == this.num_words - 1 || ppla[link].l == -1) continue;
            if (j % 7 == 0 && j > 0) {
                string.append("\n");
            }
            ++j;
            string.append("[");
            string.append(ppla[link].l - d);
            string.append(" ");
            string.append(ppla[link].r - d);
            string.append(" ");
            string.append(link_heights[link]);
            if (ppla[link].lc.label < 0) {
                string.append(" (");
                string.append(ppla[link].name);
                string.append(")]");
                continue;
            }
            string.append(" ()]");
        }
        string.append("]");
        string.append("\n");
        string.append("[");
        for (j = 0; j < N_rows; ++j) {
            if (j > 0) {
                string.append(" ");
                string.append(row_starts[j]);
                continue;
            }
            string.append(row_starts[j]);
        }
        string.append("]\n");
        String ps_string = string.toString();
        return ps_string;
    }

    public void set_centers(boolean print_word_0) {
        int tot = 0;
        for (int i = print_word_0 ? 0 : 1; i < N_words_to_print; ++i) {
            int len = this.word.get(i).length();
            Linkage.center[i] = tot + len / 2;
            tot += len + 1;
        }
    }

    public String linkage_print_diagram() {
        int i;
        int sss;
        int ttt;
        int row;
        int k;
        int j;
        boolean suppressor_used;
        boolean print_word_0 = false;
        boolean print_word_N = false;
        Sublinkage sublinkage = this.sublinkage[this.current];
        int N_links = sublinkage.num_links;
        Link[] ppla = sublinkage.link;
        Dictionary dict = this.sent.dict;
        int x_screen_width = this.opts.parse_options_get_screen_width();
        StringBuffer string = new StringBuffer();
        int N_wall_connectors = 0;
        if (dict.left_wall_defined) {
            suppressor_used = false;
            if (!this.opts.display_walls) {
                for (j = 0; j < N_links; ++j) {
                    if (ppla[j].l != 0 || ppla[j].r == this.num_words - 1) continue;
                    ++N_wall_connectors;
                    if (!ppla[j].lc.string.equals("Wd")) continue;
                    suppressor_used = true;
                }
            }
            print_word_0 = !suppressor_used && N_wall_connectors != 0 || N_wall_connectors > 1 || this.opts.display_walls;
        } else {
            print_word_0 = true;
        }
        N_wall_connectors = 0;
        if (dict.right_wall_defined) {
            suppressor_used = false;
            for (j = 0; j < N_links; ++j) {
                if (ppla[j].r != this.num_words - 1) continue;
                ++N_wall_connectors;
                if (!ppla[j].lc.string.equals("RW")) continue;
                suppressor_used = true;
            }
            print_word_N = !suppressor_used && N_wall_connectors != 0 || N_wall_connectors > 1 || this.opts.display_walls;
        } else {
            print_word_N = true;
        }
        N_words_to_print = this.num_words;
        if (!print_word_N) {
            --N_words_to_print;
        }
        this.set_centers(print_word_0);
        int line_len = center[N_words_to_print - 1] + 1;
        for (k = 0; k < 30; ++k) {
            for (j = 0; j < line_len; ++j) {
                Linkage.picture[k][j] = 32;
            }
            Linkage.picture[k][line_len] = '\u0000';
        }
        int top_row = 0;
        for (int link_length = 1; link_length < N_words_to_print; ++link_length) {
            for (j = 0; j < N_links; ++j) {
                if (ppla[j].l == -1 || ppla[j].r - ppla[j].l != link_length || !print_word_0 && ppla[j].l == 0 || !print_word_N && ppla[j].r == this.num_words - 1) continue;
                int cl = center[ppla[j].l];
                int cr = center[ppla[j].r];
                for (row = 0; row < 30; ++row) {
                    for (k = cl + 1; k < cr && picture[row][k] == ' '; ++k) {
                    }
                    if (k == cr) break;
                }
                Linkage.link_heights[j] = row;
                if (2 * row + 2 > 29) {
                    string.append("The diagram is too high.\n");
                    return string.toString();
                }
                if (row > top_row) {
                    top_row = row;
                }
                Linkage.picture[row][cl] = 43;
                Linkage.picture[row][cr] = 43;
                for (k = cl + 1; k < cr; ++k) {
                    Linkage.picture[row][k] = 45;
                }
                String s2 = ppla[j].name;
                if (this.opts.display_link_subscripts) {
                    if (!Character.isLetter(s2.charAt(0))) {
                        s2 = "";
                    }
                } else if (!Character.isUpperCase(s2.charAt(0))) {
                    s2 = "";
                }
                String connector = s2;
                if (this.opts.display_link_subscripts) {
                    k = connector.length();
                } else {
                    for (k = 0; k < connector.length() && Character.isUpperCase(connector.charAt(k)); ++k) {
                    }
                }
                ttt = (cl + cr - k) / 2 + 1 <= cl ? cl + 1 : (cl + cr - k) / 2 + 1;
                s2 = connector;
                if (this.opts.display_link_subscripts) {
                    for (sss = 0; sss < s2.length() && picture[row][ttt] == '-'; ++sss) {
                        Linkage.picture[row][ttt] = s2.charAt(sss);
                        ++ttt;
                    }
                } else {
                    while (sss < s2.length() && Character.isUpperCase(s2.charAt(sss)) && picture[row][ttt] == '-') {
                        Linkage.picture[row][ttt] = s2.charAt(sss);
                        ++ttt;
                        ++sss;
                    }
                }
                for (k = 0; k < row; ++k) {
                    if (picture[k][cl] == ' ') {
                        Linkage.picture[k][cl] = 124;
                    }
                    if (picture[k][cr] != ' ') continue;
                    Linkage.picture[k][cr] = 124;
                }
            }
        }
        sss = 0;
        for (k = print_word_0 ? 0 : 1; k < N_words_to_print; ++k) {
            ttt = 0;
            i = 0;
            while (ttt < this.word.get(k).length()) {
                Linkage.xpicture[0][sss] = this.word.get(k).charAt(ttt);
                ++sss;
                ++ttt;
                ++i;
            }
            Linkage.xpicture[0][sss] = 32;
            ++sss;
        }
        Linkage.xpicture[0][sss] = '\u0000';
        if (this.opts.display_short) {
            k = 0;
            while (picture[0][k] != '\u0000') {
                Linkage.xpicture[1][k] = picture[0][k] == '+' || picture[0][k] == '|' ? 124 : 32;
                ++k;
            }
            Linkage.xpicture[1][k] = '\u0000';
            for (row = 0; row <= top_row; ++row) {
                k = 0;
                while (picture[row][k] != '\u0000') {
                    Linkage.xpicture[row + 2][k] = picture[row][k];
                    ++k;
                }
            }
            top_row += 2;
        } else {
            for (row = 0; row <= top_row; ++row) {
                k = 0;
                while (picture[row][k] != '\u0000') {
                    Linkage.xpicture[2 * row + 2][k] = picture[row][k];
                    ++k;
                }
                k = 0;
                while (picture[row][k] != '\u0000') {
                    Linkage.xpicture[2 * row + 1][k] = picture[row][k] == '+' || picture[row][k] == '|' ? 124 : 32;
                    ++k;
                }
                Linkage.xpicture[2 * row + 1][k] = '\u0000';
            }
            top_row = 2 * top_row + 2;
        }
        i = print_word_0 ? 0 : 1;
        k = 0;
        N_rows = 0;
        Linkage.row_starts[Linkage.N_rows] = 0;
        ++N_rows;
        while (i < N_words_to_print) {
            string.append("\n");
            int width = 0;
            do {
                width += this.word.get(i).length() + 1;
            } while (++i < N_words_to_print && this.word.get(i).length() + 1 + 1 < x_screen_width);
            Linkage.row_starts[Linkage.N_rows] = i - (print_word_0 ? 0 : 1);
            if (i < N_words_to_print) {
                ++N_rows;
            }
            for (row = top_row; row >= 0; --row) {
                boolean flag = true;
                for (j = k; flag && j < k + width && xpicture[row][j] != '\u0000'; ++j) {
                    flag = flag && xpicture[row][j] == ' ';
                }
                if (flag) continue;
                for (j = k; j < k + width && xpicture[row][j] != '\u0000'; ++j) {
                    string.append(xpicture[row][j]);
                }
                string.append("\n");
            }
            string.append("\n");
            k += width;
        }
        String gr_string = string.toString();
        return gr_string;
    }

    public String linkage_print_constituent_tree(int mode) {
        if (mode == 0 || this.sent.dict.constituent_pp == null) {
            return null;
        }
        if (mode == 1 || mode == 3) {
            StringBuffer cs = new StringBuffer();
            CNode root = this.linkage_constituent_tree();
            this.print_tree(cs, mode == 1, root, 0, 0);
            cs.append("\n");
            return cs.toString();
        }
        if (mode == 2) {
            return this.print_flat_constituents();
        }
        throw new RuntimeException("Illegal mode in linkage_print_constituent_tree");
    }

    int token_type(String token) {
        if (token.charAt(0) == '[' && token.length() > 1) {
            return 0;
        }
        if (token.length() > 1 && token.charAt(token.length() - 1) == ']') {
            return 1;
        }
        return 2;
    }

    public CNode parse_string(CNode n, StringTokenizer tok) {
        CNode last_child = null;
        while (tok.hasMoreTokens()) {
            CNode m3;
            String q = tok.nextToken();
            switch (this.token_type(q)) {
                case 1: {
                    q = q.substring(0, q.length() - 1);
                    if (!q.equals(n.label)) {
                        throw new RuntimeException("Constituent tree: Labels do not match.");
                    }
                    return n;
                }
                case 0: {
                    m3 = new CNode(q.substring(1));
                    m3 = this.parse_string(m3, tok);
                    break;
                }
                case 2: {
                    m3 = new CNode(q);
                    break;
                }
                default: {
                    throw new RuntimeException("Constituent tree: Illegal token type");
                }
            }
            if (n.child == null) {
                last_child = n.child = m3;
                continue;
            }
            last_child.next = m3;
            last_child = m3;
        }
        throw new RuntimeException("Constituent tree: Constituent did not close");
    }

    public CNode linkage_constituent_tree() {
        String p = this.print_flat_constituents();
        StringTokenizer tok = new StringTokenizer(p);
        String q = tok.nextToken();
        if (this.token_type(q) != 0) {
            throw new RuntimeException("Illegal beginning of string");
        }
        CNode root = new CNode(q.substring(1));
        root = this.parse_string(root, tok);
        this.assign_spans(root, 0);
        return root;
    }

    private int assign_spans(CNode n, int start) {
        int num_words = 0;
        CNode m3 = null;
        if (n == null) {
            return 0;
        }
        n.start = start;
        if (n.child == null) {
            n.end = start;
            return 1;
        }
        m3 = n.child;
        while (m3 != null) {
            num_words += this.assign_spans(m3, start + num_words);
            m3 = m3.next;
        }
        n.end = start + num_words - 1;
        return num_words;
    }

    public String linkage_print_postscript(int mode) {
        String ps = this.build_linkage_postscript_string();
        return this.header(mode) + ps + this.trailer(mode);
    }

    private void count_words_used() {
        int num_subl = this.num_sublinkages;
        if (this.unionized && num_subl > 1) {
            --num_subl;
        }
        if (this.opts.verbosity >= 2) {
            this.opts.out.println("Number of sublinkages = " + num_subl);
        }
        for (int i = 0; i < num_subl; ++i) {
            int w;
            for (w = 0; w < this.num_words; ++w) {
                Linkage.word_used[i][w] = 0;
            }
            this.current = i;
            for (int link = 0; link < this.linkage_get_num_links(); ++link) {
                Linkage.word_used[i][this.linkage_get_link_lword((int)link)] = 1;
                Linkage.word_used[i][this.linkage_get_link_rword((int)link)] = 1;
            }
            if (this.opts.verbosity < 2) continue;
            this.opts.out.print("Sublinkage " + i + ": ");
            for (w = 0; w < this.num_words; ++w) {
                if (word_used[i][w] == 0) {
                    this.opts.out.print("0 ");
                }
                if (word_used[i][w] != 1) continue;
                this.opts.out.print("1 ");
            }
            this.opts.out.println();
        }
    }

    private String print_flat_constituents() {
        Sentence sent = this.linkage_get_sentence();
        Postprocessor pp = sent.dict.constituent_pp;
        int numcon_total = 0;
        this.count_words_used();
        int num_subl = this.num_sublinkages;
        if (num_subl > 16) {
            num_subl = 16;
            if (this.opts.verbosity >= 2) {
                this.opts.out.println("Number of sublinkages exceeds maximum: only considering first 16 sublinkages");
            }
        }
        if (this.unionized && num_subl > 1) {
            --num_subl;
        }
        for (int s2 = 0; s2 < num_subl; ++s2) {
            this.linkage_set_current_sublinkage(s2);
            this.linkage_post_process(pp);
            this.num_words = this.linkage_get_num_words();
            this.generate_misc_word_info();
            int numcon_subl = this.read_constituents_from_domains(numcon_total, s2);
            numcon_total += numcon_subl;
        }
        numcon_total = this.merge_constituents(numcon_total);
        numcon_total = this.last_minute_fixes(numcon_total);
        String q = this.exprint_constituent_structure(numcon_total);
        return q;
    }

    private int add_constituent(int cons, Domain domain, int l, int r, String name) {
        int c = cons;
        ++c;
        if (l < 1) {
            l = 1;
        }
        if (r > r_limit) {
            r = r_limit;
        }
        if (l > r) {
            throw new RuntimeException("negative constituent length!");
        }
        Linkage.constituent[c].left = l;
        Linkage.constituent[c].right = r;
        Linkage.constituent[c].domain_type = domain.type;
        Linkage.constituent[c].start_link = this.linkage_get_link_label(domain.start_link);
        Linkage.constituent[c].start_num = domain.start_link;
        Linkage.constituent[c].type = name;
        return c;
    }

    private String cons_of_domain(int domain_type) {
        switch (domain_type) {
            case 97: {
                return "ADJP";
            }
            case 98: {
                return "SBAR";
            }
            case 99: {
                return "VP";
            }
            case 100: {
                return "QP";
            }
            case 101: {
                return "ADVP";
            }
            case 102: {
                return "SBAR";
            }
            case 103: {
                return "PP";
            }
            case 104: {
                return "QP";
            }
            case 105: {
                return "ADVP";
            }
            case 107: {
                return "PRT";
            }
            case 110: {
                return "NP";
            }
            case 112: {
                return "PP";
            }
            case 113: {
                return "SINV";
            }
            case 115: {
                return "S";
            }
            case 116: {
                return "VP";
            }
            case 117: {
                return "ADJP";
            }
            case 118: {
                return "VP";
            }
            case 121: {
                return "NP";
            }
            case 122: {
                return "VP";
            }
        }
        throw new RuntimeException("Illegal domain: " + domain_type);
    }

    private String exprint_constituent_structure(int numcon_total) {
        int c;
        int[] leftdone = new int[1024];
        int[] rightdone = new int[1024];
        StringBuffer cs = new StringBuffer();
        if (numcon_total >= 1024) {
            throw new RuntimeException("Too many constituents");
        }
        for (c = 0; c < numcon_total; ++c) {
            leftdone[c] = 0;
            rightdone[c] = 0;
        }
        if (this.opts.verbosity >= 2) {
            this.opts.out.println();
        }
        block1: for (int w = 1; w < this.num_words; ++w) {
            int best;
            while (true) {
                best = -1;
                int bestright = -1;
                for (c = 0; c < numcon_total; ++c) {
                    if (Linkage.constituent[c].left != w || leftdone[c] != 0 || Linkage.constituent[c].valid != 1 || Linkage.constituent[c].right < bestright) continue;
                    best = c;
                    bestright = Linkage.constituent[c].right;
                }
                if (best == -1) break;
                leftdone[best] = 1;
                if (Linkage.constituent[best].aux == 1) continue;
                cs.append('[');
                cs.append(Linkage.constituent[best].type);
                cs.append(" ");
            }
            if (w < this.num_words - 1) {
                String s2 = this.sent.word.get((int)w).string;
                if (this.sent.word.get((int)w).firstupper) {
                    cs.append(Character.toUpperCase(s2.charAt(0)));
                    cs.append(s2.substring(1));
                } else {
                    cs.append(s2);
                }
                cs.append(" ");
            }
            while (true) {
                best = -1;
                int bestleft = -1;
                for (c = 0; c < numcon_total; ++c) {
                    if (Linkage.constituent[c].right != w || rightdone[c] != 0 || Linkage.constituent[c].valid != 1 || Linkage.constituent[c].left <= bestleft) continue;
                    best = c;
                    bestleft = Linkage.constituent[c].left;
                }
                if (best == -1) continue block1;
                rightdone[best] = 1;
                if (Linkage.constituent[best].aux == 1) continue;
                cs.append(Linkage.constituent[best].type);
                cs.append(']');
                cs.append(" ");
            }
        }
        cs.append("\n");
        return cs.toString();
    }

    private int gen_comp(int numcon_total, int numcon_subl, String ctype1, String ctype2, String ctype3, int x) {
        int c = numcon_total + numcon_subl;
        for (int c1 = numcon_total; c1 < numcon_total + numcon_subl; ++c1) {
            if (x == 4 && !Postprocessor.post_process_match("MX#*", Linkage.constituent[c1].start_link) || x == 2 && Linkage.constituent[c1].domain_type == 116 || Linkage.constituent[c1].domain_type == 122 || (x == 1 || x == 2) && (!Postprocessor.post_process_match("S", Linkage.constituent[c1].start_link) && !Postprocessor.post_process_match("SX", Linkage.constituent[c1].start_link) && !Postprocessor.post_process_match("SF", Linkage.constituent[c1].start_link) || Postprocessor.post_process_match("S##w", Linkage.constituent[c1].start_link)) || x == 3 && !Postprocessor.post_process_match("Rn", Linkage.constituent[c1].start_link) && !Postprocessor.post_process_match("R*", Linkage.constituent[c1].start_link) && !Postprocessor.post_process_match("MX#r", Linkage.constituent[c1].start_link) && !Postprocessor.post_process_match("Mr", Linkage.constituent[c1].start_link) && !Postprocessor.post_process_match("MX#d", Linkage.constituent[c1].start_link) || x == 5 && Linkage.constituent[c1].domain_type != 102 || x == 6 && Linkage.constituent[c1].domain_type != 103 || x == 7 && !Postprocessor.post_process_match("SI", Linkage.constituent[c1].start_link) || x == 8 && !Postprocessor.post_process_match("M", Linkage.constituent[c1].start_link) || x == 9 && !Postprocessor.post_process_match("COp", Linkage.constituent[c1].start_link) || !Linkage.constituent[c1].type.equals(ctype1)) continue;
            if (this.opts.verbosity >= 2) {
                this.opts.out.print("Generating complement constituent for c " + c1 + " of type " + ctype1);
            }
            boolean done = false;
            for (int w2 = Linkage.constituent[c1].left; !done && w2 >= 0; --w2) {
                for (int w3 = Linkage.constituent[c1].right; w3 < this.num_words; ++w3) {
                    for (int c2 = numcon_total; !done && c2 < numcon_total + numcon_subl; ++c2) {
                        int w;
                        if (Linkage.constituent[c2].left != w2 || Linkage.constituent[c2].right != w3 || c2 == c1 || !Linkage.constituent[c2].type.equals(ctype2)) continue;
                        if (x == 5 || x == 6 || x == 9) {
                            w = Linkage.constituent[c1].right + 1;
                            while (word_used[this.current][w] != 1) {
                                ++w;
                            }
                            if (w > Linkage.constituent[c2].right) {
                                done = true;
                                continue;
                            }
                            Linkage.constituent[c].left = w;
                            Linkage.constituent[c].right = Linkage.constituent[c2].right;
                        } else {
                            w = Linkage.constituent[c1].left - 1;
                            while (word_used[this.current][w] != 1) {
                                --w;
                            }
                            if (w < Linkage.constituent[c2].left) {
                                done = true;
                                continue;
                            }
                            Linkage.constituent[c].right = w;
                            Linkage.constituent[c].left = Linkage.constituent[c2].left;
                        }
                        this.adjust_for_left_comma(c1);
                        this.adjust_for_right_comma(c1);
                        Linkage.constituent[c].type = ctype3;
                        Linkage.constituent[c].domain_type = 120;
                        Linkage.constituent[c].start_link = "XX";
                        Linkage.constituent[c].start_num = Linkage.constituent[c1].start_num;
                        if (this.opts.verbosity >= 2) {
                            this.opts.out.print("Larger c found: c " + c2 + " (" + ctype2 + "); ");
                            this.opts.out.println("Adding constituent:");
                            this.print_constituent(c);
                        }
                        if (++c >= 1024) {
                            throw new RuntimeException("Too many constituents");
                        }
                        done = true;
                    }
                }
            }
            if (this.opts.verbosity < 2 || done) continue;
            this.opts.out.println("No constituent added, because no larger " + ctype2 + " was found");
        }
        numcon_subl = c - numcon_total;
        return numcon_subl;
    }

    public void adjust_subordinate_clauses(int numcon_total, int numcon_subl) {
        for (int c = numcon_total; c < numcon_total + numcon_subl; ++c) {
            if (!Postprocessor.post_process_match("MVs", Linkage.constituent[c].start_link) && !Postprocessor.post_process_match("MVg", Linkage.constituent[c].start_link)) continue;
            boolean done = false;
            block1: for (int w2 = Linkage.constituent[c].left - 1; !done && w2 >= 0; --w2) {
                for (int c2 = numcon_total; c2 < numcon_total + numcon_subl; ++c2) {
                    if (Linkage.constituent[c2].left != w2 || Linkage.constituent[c2].right < Linkage.constituent[c].right) continue;
                    if (Linkage.constituent[c2].type.equals("S") || Linkage.constituent[c2].type.equals("NP")) {
                        done = true;
                        continue block1;
                    }
                    if (Linkage.constituent[c2].domain_type != 118 && Linkage.constituent[c2].domain_type != 97) continue;
                    int w = Linkage.constituent[c].left - 1;
                    while (word_used[this.current][w] != 1) {
                        --w;
                    }
                    Linkage.constituent[c2].right = w;
                    if (this.opts.verbosity >= 2) {
                        this.opts.out.println("Adjusting constituent " + c2 + ":");
                    }
                    this.print_constituent(c2);
                }
            }
            if (!this.word.get(Linkage.constituent[c].left).equals(",")) continue;
            ++Linkage.constituent[c].left;
        }
    }

    private void print_constituent(int c) {
        if (this.opts.verbosity < 2) {
            return;
        }
        this.opts.out.print("  c " + c + " " + Linkage.constituent[c].type + " [" + Linkage.constituent[c].domain_type + "] (" + Linkage.constituent[c].left + "-" + Linkage.constituent[c].right + "): ");
        for (int w = Linkage.constituent[c].left; w <= Linkage.constituent[c].right; ++w) {
            this.opts.out.print(this.word.get(w));
            this.opts.out.print(" ");
        }
        this.opts.out.println();
    }

    private void adjust_for_left_comma(int c) {
        int w = Linkage.constituent[c].left;
        if (this.word.get(Linkage.constituent[c].left).equals(",")) {
            ++w;
            while (word_used[this.current][w] != 1) {
                ++w;
            }
        }
        Linkage.constituent[c].left = w;
    }

    private void adjust_for_right_comma(int c) {
        int w = Linkage.constituent[c].right;
        if (this.word.get(Linkage.constituent[c].right).equals(",") || this.word.get(Linkage.constituent[c].right).equals("RIGHT-WALL")) {
            --w;
            while (word_used[this.current][w] != 1) {
                --w;
            }
        }
        Linkage.constituent[c].right = w;
    }

    private void print_tree(StringBuffer cs, boolean indent, CNode n, int o1, int o2) {
        int i;
        if (n == null) {
            return;
        }
        if (indent) {
            for (i = 0; i < o1; ++i) {
                cs.append(" ");
            }
        }
        cs.append("(");
        cs.append(n.label);
        cs.append(" ");
        int child_offset = o2 + n.label.length() + 2;
        CNode m3 = n.child;
        while (m3 != null) {
            if (m3.child == null) {
                cs.append(m3.label);
                if (m3.next != null && m3.next.child == null) {
                    cs.append(" ");
                }
            } else {
                if (m3 != n.child) {
                    if (indent) {
                        cs.append("\n");
                    } else {
                        cs.append(" ");
                    }
                    this.print_tree(cs, indent, m3, child_offset, child_offset);
                } else {
                    this.print_tree(cs, indent, m3, 0, child_offset);
                }
                if (m3.next != null && m3.next.child == null) {
                    if (indent) {
                        cs.append("\n");
                        for (i = 0; i < child_offset; ++i) {
                            cs.append(" ");
                        }
                    } else {
                        cs.append(" ");
                    }
                }
            }
            m3 = m3.next;
        }
        cs.append(")");
    }

    private int read_constituents_from_domains(int numcon_total, int s2) {
        boolean adjustment_made;
        int numcon_subl = 0;
        r_limit = this.num_words - 2;
        Sublinkage subl = this.sublinkage[s2];
        int d = 0;
        int c = numcon_total;
        while (d < subl.pp_data.N_domains) {
            int w;
            int rightmost;
            int leftmost;
            int leftlimit;
            Domain domain = subl.pp_data.domain_array[d];
            int rootleft = this.linkage_get_link_lword(domain.start_link);
            if (domain.type == 99 || domain.type == 100 || domain.type == 101 || domain.type == 102 || domain.type == 103 || domain.type == 117 || domain.type == 121) {
                leftlimit = 0;
                leftmost = this.linkage_get_link_lword(domain.start_link);
                rightmost = this.linkage_get_link_lword(domain.start_link);
            } else {
                leftlimit = this.linkage_get_link_lword(domain.start_link) + 1;
                leftmost = this.linkage_get_link_rword(domain.start_link);
                rightmost = this.linkage_get_link_rword(domain.start_link);
            }
            ListOfLinks dlink = domain.lol;
            while (dlink != null) {
                int l = dlink.link;
                if (this.linkage_get_link_lword(l) < leftmost && this.linkage_get_link_lword(l) >= leftlimit) {
                    leftmost = this.linkage_get_link_lword(l);
                }
                if (this.linkage_get_link_rword(l) > rightmost) {
                    rightmost = this.linkage_get_link_rword(l);
                }
                dlink = dlink.next;
            }
            --c;
            c = this.add_constituent(c, domain, leftmost, rightmost, this.cons_of_domain(domain.type));
            if (domain.type == 122) {
                c = this.add_constituent(c, domain, leftmost, rightmost, "S");
            }
            if (domain.type == 99) {
                c = this.add_constituent(c, domain, leftmost, rightmost, "S");
            }
            if (Postprocessor.post_process_match("Ce*", Linkage.constituent[c].start_link) || Postprocessor.post_process_match("Rn", Linkage.constituent[c].start_link)) {
                c = this.add_constituent(c, domain, leftmost, rightmost, "SBAR");
            }
            if (Postprocessor.post_process_match("R*", Linkage.constituent[c].start_link) || Postprocessor.post_process_match("MX#r", Linkage.constituent[c].start_link)) {
                w = leftmost;
                if (this.word.get(w).equals(",")) {
                    ++w;
                }
                c = this.add_constituent(c, domain, w, w, "WHNP");
            }
            if (Postprocessor.post_process_match("Mj", Linkage.constituent[c].start_link)) {
                w = leftmost;
                if (this.word.get(w).equals(",")) {
                    ++w;
                }
                c = this.add_constituent(c, domain, w, w + 1, "WHPP");
                c = this.add_constituent(c, domain, w + 1, w + 1, "WHNP");
            }
            if (Postprocessor.post_process_match("Ss#d", Linkage.constituent[c].start_link) || Postprocessor.post_process_match("B#d", Linkage.constituent[c].start_link)) {
                c = this.add_constituent(c, domain, rootleft, rootleft, "WHNP");
                c = this.add_constituent(c, domain, rootleft, Linkage.constituent[c - 1].right, "SBAR");
            }
            if (Postprocessor.post_process_match("CP", Linkage.constituent[c].start_link)) {
                if (this.word.get(leftmost).equals(",")) {
                    ++Linkage.constituent[c].left;
                }
                c = this.add_constituent(c, domain, 1, this.num_words - 1, "S");
            }
            if (Postprocessor.post_process_match("MVs", Linkage.constituent[c].start_link) || domain.type == 102) {
                w = Linkage.constituent[c].left;
                if (this.word.get(w).equals(",")) {
                    ++w;
                }
                if (this.word.get(w).equals("when")) {
                    c = this.add_constituent(c, domain, w, w, "WHADVP");
                }
            }
            if (domain.type == 116) {
                c = this.add_constituent(c, domain, leftmost, rightmost, "S");
            }
            if (Postprocessor.post_process_match("QI", Linkage.constituent[c].start_link) || Postprocessor.post_process_match("Mr", Linkage.constituent[c].start_link) || Postprocessor.post_process_match("MX#d", Linkage.constituent[c].start_link)) {
                String name;
                w = leftmost;
                if (this.word.get(w).equals(",")) {
                    ++w;
                }
                if (wordtype[w] == 0) {
                    name = "WHADVP";
                } else if (wordtype[w] == 3) {
                    name = "WHNP";
                } else if (wordtype[w] == 4) {
                    name = "WHNP";
                } else {
                    throw new RuntimeException("Unexpected word type");
                }
                c = this.add_constituent(c, domain, w, w, name);
                if (wordtype[w] == 4) {
                    int w2;
                    for (w2 = w + 1; w2 < r_limit - 1 && wordtype[w2] != 1 && wordtype[w2] != 2; ++w2) {
                    }
                    Linkage.constituent[c].right = w2 - 1;
                    c = this.add_constituent(c, domain, w2, rightmost, "S");
                }
            }
            if (Linkage.constituent[c].domain_type == 0) {
                throw new RuntimeException("Error: no domain type assigned to constituent\n");
            }
            if (Linkage.constituent[c].start_link == null) {
                throw new RuntimeException("Error: no type assigned to constituent\n");
            }
            ++d;
            ++c;
        }
        numcon_subl = c - numcon_total;
        if (this.opts.verbosity >= 2) {
            this.opts.out.println("Constituents added at first stage for subl " + this.current + ":");
        }
        for (c = numcon_total; c < numcon_total + numcon_subl; ++c) {
            this.print_constituent(c);
        }
        numcon_subl = this.gen_comp(numcon_total, numcon_subl, "SBAR", "S", "S", 5);
        numcon_subl = this.gen_comp(numcon_total, numcon_subl, "PP", "S", "S", 6);
        numcon_subl = this.gen_comp(numcon_total, numcon_subl, "S", "S", "S", 9);
        numcon_subl = this.gen_comp(numcon_total, numcon_subl, "VP", "S", "NP", 1);
        numcon_subl = this.gen_comp(numcon_total, numcon_subl, "SBAR", "NP", "NP", 3);
        numcon_subl = this.gen_comp(numcon_total, numcon_subl, "VP", "NP", "NP", 8);
        numcon_subl = this.gen_comp(numcon_total, numcon_subl, "PP", "NP", "NP", 8);
        numcon_subl = this.gen_comp(numcon_total, numcon_subl, "NP", "NP", "NP", 4);
        numcon_subl = this.gen_comp(numcon_total, numcon_subl, "NP", "SINV", "VP", 7);
        this.adjust_subordinate_clauses(numcon_total, numcon_subl);
        for (c = numcon_total; c < numcon_total + numcon_subl; ++c) {
            if (Linkage.constituent[c].domain_type != 112 || !this.word.get(Linkage.constituent[c].left).equals(",")) continue;
            ++Linkage.constituent[c].left;
        }
        do {
            adjustment_made = false;
            for (c = numcon_total; c < numcon_total + numcon_subl; ++c) {
                for (int c2 = numcon_total; c2 < numcon_total + numcon_subl; ++c2) {
                    if (Linkage.constituent[c].left >= Linkage.constituent[c2].left || Linkage.constituent[c].right >= Linkage.constituent[c2].right || Linkage.constituent[c].right < Linkage.constituent[c2].left) continue;
                    if (this.word.get(Linkage.constituent[c2].right).equals(",") || this.word.get(Linkage.constituent[c2].right).equals("RIGHT-WALL")) {
                        if (this.opts.verbosity >= 2) {
                            this.opts.out.println("Adjusting " + c2 + " to fix comma overlap");
                        }
                        this.adjust_for_right_comma(c2);
                        adjustment_made = true;
                        continue;
                    }
                    if (this.word.get(Linkage.constituent[c].left).equals(",")) {
                        if (this.opts.verbosity >= 2) {
                            this.opts.out.println("Adjusting c " + c + " to fix comma overlap");
                        }
                        this.adjust_for_left_comma(c);
                        adjustment_made = true;
                        continue;
                    }
                    if (this.opts.verbosity >= 2) {
                        this.opts.out.println("WARNING: the constituents aren't nested! Adjusting them.(" + c + ", " + c2 + ")");
                    }
                    Linkage.constituent[c].left = Linkage.constituent[c2].left;
                }
            }
        } while (adjustment_made);
        for (c = numcon_total; c < numcon_total + numcon_subl; ++c) {
            Linkage.constituent[c].subl = this.current;
            Linkage.constituent[c].aux = Linkage.constituent[c].domain_type == 118 && wordtype[this.linkage_get_link_rword(Linkage.constituent[c].start_num)] == 2 || Linkage.constituent[c].domain_type == 116 && Linkage.constituent[c].type.equals("VP") ? 1 : 0;
        }
        for (c = numcon_total; c < numcon_total + numcon_subl; ++c) {
            Linkage.constituent[c].subl = this.current;
            Linkage.constituent[c].aux = 0;
        }
        return numcon_subl;
    }

    private int find_next_element(int start, int numcon_total, int num_elements, int num_lists) {
        int a;
        boolean addedone = false;
        for (int c = start + 1; c < numcon_total; ++c) {
            if (Linkage.constituent[c].valid == 0 || !Linkage.constituent[Linkage.templist[0]].type.equals(Linkage.constituent[c].type)) continue;
            boolean ok = true;
            for (a = 0; a < num_elements; ++a) {
                if (Linkage.constituent[c].subl == Linkage.constituent[Linkage.templist[a]].subl) {
                    ok = false;
                }
                if (Linkage.constituent[c].left < Linkage.constituent[Linkage.templist[a]].left && Linkage.constituent[c].right > Linkage.constituent[Linkage.templist[a]].left || Linkage.constituent[c].right > Linkage.constituent[Linkage.templist[a]].right && Linkage.constituent[c].left < Linkage.constituent[Linkage.templist[a]].right || Linkage.constituent[c].right > Linkage.constituent[Linkage.templist[a]].right && Linkage.constituent[c].left < Linkage.constituent[Linkage.templist[a]].right || Linkage.constituent[c].left > Linkage.constituent[Linkage.templist[a]].left && Linkage.constituent[c].right < Linkage.constituent[Linkage.templist[a]].right) {
                    ok = false;
                }
                for (int c2 = 0; c2 < numcon_total; ++c2) {
                    if (Linkage.constituent[c2].canon != Linkage.constituent[c].canon) continue;
                    for (int c3 = 0; c3 < numcon_total; ++c3) {
                        if (Linkage.constituent[c3].canon != Linkage.constituent[Linkage.templist[a]].canon || Linkage.constituent[c3].subl != Linkage.constituent[c2].subl) continue;
                        ok = false;
                    }
                }
            }
            if (!ok) continue;
            Linkage.templist[num_elements] = c;
            addedone = true;
            num_lists = this.find_next_element(c, numcon_total, num_elements + 1, num_lists);
        }
        if (!addedone && num_elements > 1) {
            for (a = 0; a < num_elements; ++a) {
                Linkage.andlist[num_lists].e[a] = templist[a];
                Linkage.andlist[num_lists].num = num_elements;
            }
            ++num_lists;
        }
        return num_lists;
    }

    public static boolean uppercompare(String s2, String t) {
        for (int i = 0; i < s2.length() && i < t.length() && (Character.isUpperCase(s2.charAt(i)) || Character.isUpperCase(t.charAt(i))); ++i) {
            if (s2.charAt(i) == t.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private void generate_misc_word_info() {
        int w1;
        for (w1 = 0; w1 < this.num_words; ++w1) {
            Linkage.wordtype[w1] = 0;
        }
        for (int l1 = 0; l1 < this.linkage_get_num_links(); ++l1) {
            String label2;
            int w2;
            int l2;
            w1 = this.linkage_get_link_rword(l1);
            String label1 = this.linkage_get_link_label(l1);
            if (Linkage.uppercompare(label1, "S") || Linkage.uppercompare(label1, "SX") || Linkage.uppercompare(label1, "SF")) {
                Linkage.wordtype[w1] = 1;
                for (l2 = 0; l2 < this.linkage_get_num_links(); ++l2) {
                    w2 = this.linkage_get_link_lword(l2);
                    label2 = this.linkage_get_link_label(l2);
                    if (w1 != w2 || !Postprocessor.post_process_match("Pg#b", label2) && !Linkage.uppercompare(label2, "I") && !Linkage.uppercompare(label2, "PP") && !Postprocessor.post_process_match("Pv", label2)) continue;
                    Linkage.wordtype[w1] = 2;
                }
            }
            if (Postprocessor.post_process_match("QI#d", label1)) {
                Linkage.wordtype[w1] = 4;
                for (l2 = 0; l2 < this.linkage_get_num_links(); ++l2) {
                    w2 = this.linkage_get_link_lword(l2);
                    label2 = this.linkage_get_link_label(l2);
                    if (w1 != w2 || !Postprocessor.post_process_match("D##w", label2)) continue;
                    Linkage.wordtype[w1] = 4;
                }
            }
            if (Postprocessor.post_process_match("Mr", label1)) {
                Linkage.wordtype[w1] = 4;
            }
            if (!Postprocessor.post_process_match("MX#d", label1)) continue;
            Linkage.wordtype[w1] = 4;
        }
    }

    private int last_minute_fixes(int numcon_total) {
        boolean adjustment_made;
        int c;
        int newcon_total = 0;
        for (c = 0; c < numcon_total; ++c) {
            if (Linkage.uppercompare(Linkage.constituent[c].start_link, "CP")) {
                Linkage.constituent[c].valid = 0;
            }
            if (Linkage.uppercompare(Linkage.constituent[c].start_link, "YS") || Linkage.uppercompare(Linkage.constituent[c].start_link, "YP")) {
                ++Linkage.constituent[c].right;
            }
            if (Linkage.constituent[c].start_link.equals("MVpn")) {
                Linkage.constituent[c].type = "NP";
            }
            if (Linkage.constituent[c].start_link.equals("COn")) {
                Linkage.constituent[c].type = "NP";
            }
            if (Linkage.constituent[c].start_link.equals("Mpn")) {
                Linkage.constituent[c].type = "NP";
            }
            if (Linkage.constituent[c].start_link.equals("Wdc") && Linkage.constituent[c].left == 2) {
                Linkage.constituent[c].valid = 0;
            }
            if ((Postprocessor.post_process_match("A", Linkage.constituent[c].start_link) || Linkage.constituent[c].domain_type == 100 || Linkage.constituent[c].domain_type == 104) && Linkage.constituent[c].right - Linkage.constituent[c].left == 0) {
                Linkage.constituent[c].valid = 0;
            }
            if (Linkage.constituent[c].domain_type == 104 && this.word.get(Linkage.constituent[c].left - 1).equals("$")) {
                --Linkage.constituent[c].left;
            }
            if (Linkage.constituent[c].aux == 2) {
                Linkage.constituent[c].type = "X";
            }
            if (Linkage.constituent[c].aux != 1) continue;
            Linkage.constituent[c].valid = 0;
        }
        numcon_total += newcon_total;
        for (c = 0; c < numcon_total; ++c) {
            if (Linkage.constituent[c].right != this.num_words - 3 || Linkage.constituent[c].left != 1 || !Linkage.constituent[c].type.equals("S") || !this.sent.word.get((int)(this.num_words - 2)).string.equals(".")) continue;
            ++Linkage.constituent[c].right;
        }
        int lastword = this.num_words - 2;
        boolean global_leftend_found = false;
        boolean global_rightend_found = false;
        for (c = 0; c < numcon_total; ++c) {
            if (Linkage.constituent[c].left != 1 || !Linkage.constituent[c].type.equals("S") || Linkage.constituent[c].valid != 1) continue;
            global_leftend_found = true;
        }
        for (c = 0; c < numcon_total; ++c) {
            if (Linkage.constituent[c].right < lastword || !Linkage.constituent[c].type.equals("S") || Linkage.constituent[c].valid != 1) continue;
            global_rightend_found = true;
        }
        if (!global_leftend_found || !global_rightend_found) {
            c = numcon_total++;
            Linkage.constituent[c].left = 1;
            Linkage.constituent[c].right = this.num_words - 1;
            Linkage.constituent[c].type = "S";
            Linkage.constituent[c].valid = 1;
            Linkage.constituent[c].domain_type = 120;
            if (this.opts.verbosity >= 2) {
                this.opts.out.println("Adding global sentence constituent:");
            }
            this.print_constituent(c);
        }
        do {
            adjustment_made = false;
            for (c = 0; c < numcon_total; ++c) {
                if (Linkage.constituent[c].valid == 0) continue;
                for (int c2 = 0; c2 < numcon_total; ++c2) {
                    if (Linkage.constituent[c2].valid == 0 || Linkage.constituent[c].left >= Linkage.constituent[c2].left || Linkage.constituent[c].right >= Linkage.constituent[c2].right || Linkage.constituent[c].right < Linkage.constituent[c2].left) continue;
                    if (this.opts.verbosity >= 2) {
                        this.opts.out.println("WARNING: the constituents aren't nested! Adjusting them. (" + c + ", " + c2 + ")");
                    }
                    Linkage.constituent[c].left = Linkage.constituent[c2].left;
                }
            }
        } while (adjustment_made);
        return numcon_total;
    }

    private int merge_constituents(int numcon_total) {
        int a2;
        int n2;
        int a;
        int n;
        int c3;
        boolean ok;
        int c1;
        int c2 = 0;
        for (c1 = 0; c1 < numcon_total; ++c1) {
            Linkage.constituent[c1].valid = 1;
            if (Linkage.constituent[c1].right < Linkage.constituent[c1].left) {
                if (this.opts.verbosity >= 2) {
                    this.opts.out.println("WARNING: Constituent " + c1 + " has negative length. Deleting it.");
                }
                Linkage.constituent[c1].valid = 0;
            }
            Linkage.constituent[c1].canon = c1;
        }
        for (c1 = 0; c1 < numcon_total; ++c1) {
            if (Linkage.constituent[c1].canon != c1) continue;
            for (c2 = c1 + 1; c2 < numcon_total; ++c2) {
                if (Linkage.constituent[c1].left != Linkage.constituent[c2].left || Linkage.constituent[c1].right != Linkage.constituent[c2].right || !Linkage.constituent[c1].type.equals(Linkage.constituent[c2].type)) continue;
                Linkage.constituent[c2].canon = c1;
            }
        }
        for (c1 = 0; c1 < numcon_total; ++c1) {
            if (Linkage.constituent[c1].valid == 0) continue;
            for (c2 = 0; c2 < numcon_total; ++c2) {
                if (Linkage.constituent[c2].subl == Linkage.constituent[c1].subl) continue;
                ok = true;
                for (c3 = 0; c3 < numcon_total; ++c3) {
                    if (Linkage.constituent[c2].canon != Linkage.constituent[c3].canon || Linkage.constituent[c3].subl != Linkage.constituent[c1].subl) continue;
                    ok = false;
                }
                for (c3 = 0; c3 < numcon_total; ++c3) {
                    if (Linkage.constituent[c1].canon != Linkage.constituent[c3].canon || Linkage.constituent[c3].subl != Linkage.constituent[c2].subl) continue;
                    ok = false;
                }
                if (!ok) continue;
                if (Linkage.constituent[c1].left == Linkage.constituent[c2].left && Linkage.constituent[c1].right > Linkage.constituent[c2].right && Linkage.constituent[c1].type.equals(Linkage.constituent[c2].type)) {
                    Linkage.constituent[c2].valid = 0;
                }
                if (Linkage.constituent[c1].left >= Linkage.constituent[c2].left || Linkage.constituent[c1].right != Linkage.constituent[c2].right || !Linkage.constituent[c1].type.equals(Linkage.constituent[c2].type)) continue;
                Linkage.constituent[c2].valid = 0;
            }
        }
        for (c1 = 0; c1 < numcon_total; ++c1) {
            if (Linkage.constituent[c1].valid == 0) continue;
            for (c2 = c1 + 1; c2 < numcon_total; ++c2) {
                if (Linkage.constituent[c2].canon != Linkage.constituent[c1].canon) continue;
                Linkage.constituent[c2].valid = 0;
            }
        }
        int num_lists = 0;
        for (c1 = 0; c1 < numcon_total; ++c1) {
            if (Linkage.constituent[c1].valid == 0) continue;
            int num_elements = 1;
            Linkage.templist[0] = c1;
            num_lists = this.find_next_element(c1, numcon_total, num_elements, num_lists);
        }
        if (this.opts.verbosity >= 2) {
            this.opts.out.println("And-lists:");
            for (n = 0; n < num_lists; ++n) {
                this.opts.out.print("  " + n + ": ");
                for (a = 0; a < Linkage.andlist[n].num; ++a) {
                    this.opts.out.print("" + Linkage.andlist[n].e[a] + " ");
                }
                this.opts.out.println();
            }
        }
        for (n = 0; n < num_lists; ++n) {
            Linkage.andlist[n].valid = true;
            for (n2 = 0; n2 < num_lists; ++n2) {
                if (n2 == n || Linkage.andlist[n2].num < Linkage.andlist[n].num) continue;
                boolean listmatch = true;
                for (a = 0; a < Linkage.andlist[n].num; ++a) {
                    boolean match = false;
                    for (a2 = 0; a2 < Linkage.andlist[n2].num; ++a2) {
                        if (Linkage.andlist[n2].e[a2] != Linkage.andlist[n].e[a]) continue;
                        match = true;
                    }
                    if (match) continue;
                    listmatch = false;
                }
                if (!listmatch) continue;
                Linkage.andlist[n].valid = false;
            }
        }
        for (n = 0; n < num_lists; ++n) {
            if (!Linkage.andlist[n].valid) continue;
            for (a = 0; a < Linkage.andlist[n].num && Linkage.andlist[n].valid; ++a) {
                for (n2 = 0; n2 < num_lists && Linkage.andlist[n].valid; ++n2) {
                    if (n2 == n || !Linkage.andlist[n2].valid) continue;
                    for (a2 = 0; a2 < Linkage.andlist[n2].num && Linkage.andlist[n].valid; ++a2) {
                        int a3;
                        c1 = Linkage.andlist[n].e[a];
                        c2 = Linkage.andlist[n2].e[a2];
                        if (c1 == c2 || Linkage.constituent[c2].left > Linkage.constituent[c1].left || Linkage.constituent[c2].right < Linkage.constituent[c1].right) continue;
                        if (this.opts.verbosity >= 2) {
                            this.opts.out.println("Found that c" + c2 + " in list " + n2 + "  is bigger than c" + c1 + " in list " + n);
                        }
                        ok = true;
                        for (a3 = 0; a3 < Linkage.andlist[n].num; ++a3) {
                            c3 = Linkage.andlist[n].e[a3];
                            if (Linkage.constituent[c2].left <= Linkage.constituent[c3].left && Linkage.constituent[c2].right >= Linkage.constituent[c3].right) continue;
                            ok = false;
                        }
                        if (ok) continue;
                        Linkage.andlist[n].valid = false;
                        if (this.opts.verbosity < 2) continue;
                        this.opts.out.print("Eliminating andlist, n=" + n + ", a=" + a + ", n2=" + n2 + ", a2=" + a2 + ": ");
                        for (a3 = 0; a3 < Linkage.andlist[n].num; ++a3) {
                            this.opts.out.print("" + Linkage.andlist[n].e[a3] + " ");
                        }
                        this.opts.out.println();
                    }
                }
            }
        }
        if (this.opts.verbosity >= 2) {
            this.opts.out.println("And-lists after pruning:");
            for (n = 0; n < num_lists; ++n) {
                if (!Linkage.andlist[n].valid) continue;
                this.opts.out.print("  " + n + ": ");
                for (a = 0; a < Linkage.andlist[n].num; ++a) {
                    this.opts.out.print("" + Linkage.andlist[n].e[a] + " ");
                }
                this.opts.out.println();
            }
        }
        c1 = numcon_total;
        for (n = 0; n < num_lists; ++n) {
            if (!Linkage.andlist[n].valid) continue;
            int leftend = 256;
            int rightend = -1;
            for (a = 0; a < Linkage.andlist[n].num; ++a) {
                c2 = Linkage.andlist[n].e[a];
                if (Linkage.constituent[c2].left < leftend) {
                    leftend = Linkage.constituent[c2].left;
                }
                if (Linkage.constituent[c2].right <= rightend) continue;
                rightend = Linkage.constituent[c2].right;
            }
            Linkage.constituent[c1].left = leftend;
            Linkage.constituent[c1].right = rightend;
            Linkage.constituent[c1].type = Linkage.constituent[c2].type;
            Linkage.constituent[c1].domain_type = 120;
            Linkage.constituent[c1].valid = 1;
            Linkage.constituent[c1].start_link = Linkage.constituent[c2].start_link;
            Linkage.constituent[c1].start_num = Linkage.constituent[c2].start_num;
            for (a = 0; a < Linkage.andlist[n].num; ++a) {
                c2 = Linkage.andlist[n].e[a];
                if (Linkage.constituent[c2].aux != 1 && Linkage.constituent[c2].aux != 2) continue;
                Linkage.constituent[c1].aux = 2;
                Linkage.constituent[c2].aux = 2;
            }
            if (this.opts.verbosity >= 2) {
                this.opts.out.println("Adding constituent:");
            }
            this.print_constituent(c1);
            ++c1;
        }
        numcon_total = c1;
        return numcon_total;
    }

    public void linkage_post_process(Postprocessor postprocessor) {
        int N_sublinkages = this.linkage_get_num_sublinkages();
        for (int i = 0; i < N_sublinkages; ++i) {
            PPNode pp;
            int j;
            Sublinkage subl = this.sublinkage[i];
            subl.pp_info = new PPInfo[subl.num_links];
            for (j = 0; j < subl.num_links; ++j) {
                subl.pp_info[j] = new PPInfo();
                subl.pp_info[j].num_domains = 0;
                subl.pp_info[j].domain_name = null;
            }
            if (subl.violation != null) {
                subl.violation = null;
            }
            if ((pp = this.info.improper_fat_linkage ? null : this.sent.post_process(postprocessor, this.opts, subl, false)) == null) {
                for (j = 0; j < subl.num_links; ++j) {
                    subl.pp_info[j].num_domains = 0;
                    subl.pp_info[j].domain_name = null;
                }
                continue;
            }
            for (j = 0; j < subl.num_links; ++j) {
                int k = 0;
                DTypeList d = pp.d_type_array[j];
                while (d != null) {
                    ++k;
                    d = d.next;
                }
                subl.pp_info[j].num_domains = k;
                if (k > 0) {
                    subl.pp_info[j].domain_name = new String[k];
                }
                k = 0;
                d = pp.d_type_array[j];
                while (d != null) {
                    char[] c = new char[]{(char)d.type};
                    subl.pp_info[j].domain_name[k] = new String(c);
                    ++k;
                    d = d.next;
                }
            }
            subl.pp_data = postprocessor.pp_data;
            if (pp.violation == null) continue;
            subl.violation = pp.violation;
        }
        Postprocessor.post_process_close_sentence(postprocessor);
    }

    public String trailer(int mode) {
        String trailer_string = "diagram\n\n%%EndDocument\n";
        if (mode == 1) {
            return trailer_string;
        }
        return "";
    }

    public String header(int mode) {
        String header_string = "%!PS-Adobe-2.0 EPSF-1.2\n%%Pages: 1\n%%BoundingBox: 0 -20 500 200\n%%EndComments\n%%BeginDocument: \n\n% compute size of diagram by adding\n% #rows x 8.5\n% (#rows -1) x 10\n% \\sum maxheight x 10\n/nulllink () def                     % The symbol of a null link\n/wordfontsize 11 def      % the size of the word font\n/labelfontsize 9 def      % the size of the connector label font\n/ex 10 def  % the horizontal radius of all the links\n/ey 10 def  % the height of the level 0 links\n/ed 10 def  % amount to add to this height per level\n/radius 10 def % radius for rounded arcs\n/row-spacing 10 def % the space between successive rows of the diagram\n\n/gap wordfontsize .5 mul def  % the gap between words\n/top-of-words wordfontsize .85 mul def\n             % the delta y above where the text is written where\n             % the major axis of the ellipse is located\n/label-gap labelfontsize .1 mul def\n\n/xwordfontsize 10 def      % the size of the word font\n/xlabelfontsize 10 def      % the size of the connector label font\n/xex 10 def  % the horizontal radius of all the links\n/xey 10 def  % the height of the level 0 links\n/xed 10 def  % amount to add to this height per level\n/xradius 10 def % radius for rounded arcs\n/xrow-spacing 10 def % the space between successive rows of the diagram\n/xgap wordfontsize .5 mul def  % the gap between words\n\n/centerpage 6.5 72 mul 2 div def\n  % this number of points from the left margin is the center of page\n\n/rightpage 6.5 72 mul def\n  % number of points from the left margin is the the right margin\n\n/show-string-centered-dict 5 dict def\n\n/show-string-centered {\n  show-string-centered-dict begin\n  /string exch def\n  /ycenter exch def\n  /xcenter exch def\n  xcenter string stringwidth pop 2 div sub\n  ycenter labelfontsize .3 mul sub\n  moveto\n  string show\n  end\n} def\n\n/clear-word-box {\n  show-string-centered-dict begin\n  /string exch def\n  /ycenter exch def\n  /xcenter exch def\n  newpath\n  /urx string stringwidth pop 2 div def\n  /ury labelfontsize .3 mul def\n  xcenter urx sub ycenter ury sub moveto\n  xcenter urx add ycenter ury sub lineto\n  xcenter urx add ycenter ury add lineto\n  xcenter urx sub ycenter ury add lineto\n  closepath\n  1 setgray fill\n  0 setgray\n  end\n} def\n\n/diagram-sentence-dict 20 dict def\n\n/diagram-sentence-circle\n{diagram-sentence-dict begin  \n   /links exch def\n   /words exch def\n   /n words length def\n   /Times-Roman findfont wordfontsize scalefont setfont\n   /x 0 def\n   /y 0 def\n\n   /left-ends [x dup words {stringwidth pop add gap add dup}\n                        forall pop pop] def\n   /right-ends [x words {stringwidth pop add dup gap add} forall pop] def\n   /centers [0 1 n 1 sub {/i exch def\n             left-ends i get\n             right-ends i get\n             add 2 div\n           } for ] def\n\n   x y moveto\n   words {show gap 0 rmoveto} forall\n\n   .5 setlinewidth \n\n   links {dup 0 get /leftword exch def\n          dup 1 get /rightword exch def\n          dup 2 get /level exch def\n          3 get /string exch def\n          newpath\n          string nulllink eq {[2] 1 setdash}{[] 0 setdash} ifelse\n%          string nulllink eq {.8 setgray}{0 setgray} ifelse\n          centers leftword get\n     y top-of-words add\n          moveto\n      \n          centers rightword get\n          centers leftword get\n          sub 2  div dup\n          radius \n          lt {/radiusx exch def}{pop /radiusx radius def} ifelse\n  \n          \n \n          centers leftword get\n     y top-of-words add ey ed level mul add add\n          centers rightword get\n     y top-of-words add ey ed level mul add add\n     radiusx\n          arcto\n          4 {pop} repeat\n     centers rightword get\n          y top-of-words add ey ed level mul add add\n     centers rightword get\n     y top-of-words add\n     radiusx\n     arcto\n          4 {pop} repeat\n     centers rightword get\n     y top-of-words add\n     lineto\n\n     stroke\n\n          /radius-y    ey ed level mul add   def\n\n     /center-arc-x\n        centers leftword get centers rightword get add 2 div\n     def\n     \n          /center-arc-y\n             y top-of-words radius-y add add\n     def\n\n          /Courier-Bold findfont labelfontsize scalefont setfont \n     center-arc-x center-arc-y string clear-word-box\n     center-arc-x center-arc-y string show-string-centered\n          } forall\n     end\n  } def\n\n/diagramdict 20 dict def\n\n/diagram\n{diagramdict begin\n   /break-words exch def\n   /links exch def\n   /words exch def\n   /n words length def\n   /n-rows break-words length def\n   /Times-Roman findfont wordfontsize scalefont setfont\n\n   /left-ends [0 dup words {stringwidth pop add gap add dup}\n                        forall pop pop] def\n   /right-ends [0 words {stringwidth pop add dup gap add} forall pop] def\n\n   /lwindows [ break-words {left-ends exch get gap 2 div sub } forall ] def\n   /rwindows [1 1 n-rows 1 sub {/i exch def\n             lwindows i get } for\n                 right-ends n 1 sub get gap 2 div add\n         ] def\n\n\n    /max 0 def\n    0 1 links length 1 sub {\n   /i exch def\n   /t links i get 2 get def\n   t max gt {/max t def} if\n      } for\n\n    /max-height ed max mul ey add top-of-words add row-spacing add def\n    /total-height n-rows max-height mul row-spacing sub def\n\n    /max-width 0 def            % compute the widest window\n    0 1 n-rows 1 sub {\n        /i exch def\n        /t rwindows i get lwindows i get sub def\n        t max-width gt {/max-width t def} if\n      } for\n\n    centerpage max-width 2 div sub 0 translate  % centers it\n   % rightpage max-width sub 0 translate      % right justified\n                        % Delete both of these to make it left justified\n\n   n-rows 1 sub -1 0\n     {/i exch def\n   gsave\n   newpath\n        %/centering centerpage rwindows i get lwindows i get sub 2 div sub def\n               % this line causes each row to be centered\n        /centering 0 def\n               % set centering to 0 to prevent centering of each row \n\n   centering -100 moveto  % -100 because some letters go below zero\n        centering max-height n-rows mul lineto\n        rwindows i get lwindows i get sub centering add\n                       max-height n-rows mul lineto\n        rwindows i get lwindows i get sub centering add\n                       -100 lineto\n   closepath\n        clip\n   lwindows i get neg n-rows i sub 1 sub max-height mul translate\n        centerpage centering 0 translate\n        words links diagram-sentence-circle\n   grestore\n     } for\n     end\n} def \n\n/diagramx\n{diagramdict begin\n   /break-words exch def\n   /links exch def\n   /words exch def\n   /n words length def\n   /n-rows break-words length def\n   /Times-Roman findfont xwordfontsize scalefont setfont\n\n   /left-ends [0 dup words {stringwidth pop add gap add dup}\n                        forall pop pop] def\n   /right-ends [0 words {stringwidth pop add dup gap add} forall pop] def\n\n   /lwindows [ break-words {left-ends exch get gap 2 div sub } forall ] def\n   /rwindows [1 1 n-rows 1 sub {/i exch def\n             lwindows i get } for\n                 right-ends n 1 sub get xgap 2 div add\n         ] def\n\n\n    /max 0 def\n    0 1 links length 1 sub {\n   /i exch def\n   /t links i get 2 get def\n   t max gt {/max t def} if\n      } for\n\n    /max-height xed max mul xey add top-of-words add xrow-spacing add def\n    /total-height n-rows max-height mul xrow-spacing sub def\n\n    /max-width 0 def            % compute the widest window\n    0 1 n-rows 1 sub {\n        /i exch def\n        /t rwindows i get lwindows i get sub def\n        t max-width gt {/max-width t def} if\n      } for\n\n    centerpage max-width 2 div sub 0 translate  % centers it\n   % rightpage max-width sub 0 translate      % right justified\n                        % Delete both of these to make it left justified\n\n   n-rows 1 sub -1 0\n     {/i exch def\n   gsave\n   newpath\n        %/centering centerpage rwindows i get lwindows i get sub 2 div sub def\n               % this line causes each row to be centered\n        /centering 0 def\n               % set centering to 0 to prevent centering of each row \n\n   centering -100 moveto  % -100 because some letters go below zero\n        centering max-height n-rows mul lineto\n        rwindows i get lwindows i get sub centering add\n                       max-height n-rows mul lineto\n        rwindows i get lwindows i get sub centering add\n                       -100 lineto\n   closepath\n        clip\n   lwindows i get neg n-rows i sub 1 sub max-height mul translate\n        centerpage centering 0 translate\n        words links diagram-sentence-circle\n   grestore\n     } for\n     end\n} def \n\n/ldiagram\n{diagramdict begin\n   /break-words exch def\n   /links exch def\n   /words exch def\n   /n words length def\n   /n-rows break-words length def\n   /Times-Roman findfont wordfontsize scalefont setfont\n\n   /left-ends [0 dup words {stringwidth pop add gap add dup}\n                        forall pop pop] def\n   /right-ends [0 words {stringwidth pop add dup gap add} forall pop] def\n\n   /lwindows [ break-words {left-ends exch get gap 2 div sub } forall ] def\n   /rwindows [1 1 n-rows 1 sub {/i exch def\n             lwindows i get } for\n                 right-ends n 1 sub get gap 2 div add\n         ] def\n\n\n    /max 0 def\n    0 1 links length 1 sub {\n   /i exch def\n   /t links i get 2 get def\n   t max gt {/max t def} if\n      } for\n\n    /max-height ed max mul ey add top-of-words add row-spacing add def\n    /total-height n-rows max-height mul row-spacing sub def\n\n    /max-width 0 def            % compute the widest window\n    0 1 n-rows 1 sub {\n        /i exch def\n        /t rwindows i get lwindows i get sub def\n        t max-width gt {/max-width t def} if\n      } for\n\n   % centerpage max-width 2 div sub 0 translate  % centers it\n   % rightpage max-width sub 0 translate      % right justified\n                        % Delete both of these to make it left justified\n\n   n-rows 1 sub -1 0\n     {/i exch def\n   gsave\n   newpath\n        %/centering centerpage rwindows i get lwindows i get sub 2 div sub def\n               % this line causes each row to be centered\n        /centering 0 def\n               % set centering to 0 to prevent centering of each row \n\n   centering -100 moveto  % -100 because some letters go below zero\n        centering max-height n-rows mul lineto\n        rwindows i get lwindows i get sub centering add\n                       max-height n-rows mul lineto\n        rwindows i get lwindows i get sub centering add\n                       -100 lineto\n   closepath\n        clip\n   lwindows i get neg n-rows i sub 1 sub max-height mul translate\n        centerpage centering 0 translate\n        words links diagram-sentence-circle\n   grestore\n     } for\n     end\n} def \n";
        if (mode == 1) {
            return header_string;
        }
        return "";
    }

    static {
        center = new int[250];
        constituent = new Constituent[1024];
        templist = new int[100];
        r_limit = 0;
        andlist = new LinkageAndList[1024];
        wordtype = new int[250];
        picture = new char[30][1500];
        xpicture = new char[30][1500];
    }

    static class LinkageAndList {
        int num;
        int[] e = new int[10];
        boolean valid;

        LinkageAndList() {
        }
    }
}

