/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import net.sf.jlinkgrammar.Dictionary;
import net.sf.jlinkgrammar.Linkage;
import net.sf.jlinkgrammar.ParseOptions;
import net.sf.jlinkgrammar.Sentence;

public class GlobalBean {
    public static final int NEGATIVECOST = -1000000;
    public static final int NOCUTOFF = 1000;
    public static final String LEFT_WALL_DISPLAY = "LEFT-WALL";
    public static final String LEFT_WALL_SUPPRESS = "Wd";
    public static final String RIGHT_WALL_DISPLAY = "RIGHT-WALL";
    static final String RIGHT_WALL_SUPPRESS = "RW";
    public static final String LEFT_WALL_WORD = "LEFT-WALL";
    public static final String RIGHT_WALL_WORD = "RIGHT-WALL";
    public static final String POSTPROCESS_WORD = "POSTPROCESS";
    public static final String ANDABLE_CONNECTORS_WORD = "ANDABLE-CONNECTORS";
    public static final String UNLIMITED_CONNECTORS_WORD = "UNLIMITED-CONNECTORS";
    public static final String PROPER_WORD = "CAPITALIZED-WORDS";
    public static final String PL_PROPER_WORD = "PL-CAPITALIZED-WORDS";
    public static final String HYPHENATED_WORD = "HYPHENATED-WORDS";
    public static final String NUMBER_WORD = "NUMBERS";
    public static final String ING_WORD = "ING-WORDS";
    public static final String S_WORD = "S-WORDS";
    public static final String ED_WORD = "ED-WORDS";
    public static final String LY_WORD = "LY-WORDS";
    public static final String UNKNOWN_WORD = "UNKNOWN-WORD";
    public static final int MAX_PATH_NAME = 400;
    public static final int MAX_WORD = 60;
    public static final int MAX_LINE = 1500;
    public static final int MAX_SENTENCE = 250;
    public static final int MAX_LINKS = 497;
    public static final int MAX_TOKEN_LENGTH = 50;
    public static final int MAX_DISJUNCT_COST = 10000;
    public static final int DOWN_priority = 2;
    public static final int UP_priority = 1;
    public static final int THIN_priority = 0;
    public static final int NORMAL_LABEL = -1;
    public static final int UNLIMITED_LEN = 255;
    public static final int SHORT_LEN = 6;
    public static final int NO_WORD = 255;
    public static final int OR_type = 0;
    public static final int AND_type = 1;
    public static final int CONNECTOR_type = 2;
    public static final int GENTLE = 1;
    public static final int RUTHLESS = 0;
    public static final int PP_LEXER_MAX_LABELS = 512;
    public static final int VDAL = 1;
    public static final int HT_SIZE = 1024;
    public static final int RTSIZE = 256;
    public static final int NODICT = 1;
    public static final int DICTPARSE = 2;
    public static final int WORDFILE = 3;
    public static final int SEPARATE = 4;
    public static final int NOTINDICT = 5;
    public static final int BUILDEXPR = 6;
    public static final int INTERNALERROR = 7;
    public static final int LINKSET_SPARSENESS = 2;
    public static final int LINKSET_MAX_SETS = 512;
    public static final int LINKSET_DEFAULT_SEED = 37;
    public static final int PP_FIRST_PASS = 1;
    public static final int PP_SECOND_PASS = 2;
    public static final int MAXINPUT = 1024;
    public static final int DISPLAY_MAX = 1024;
    public static final char COMMENT_CHAR = '%';
    public static final char UNGRAMMATICAL = '*';
    public static final char PARSE_WITH_DISJUNCT_COST_GT_0 = ':';
    public static final char NO_LABEL = ' ';
    public static final int BAD_WORD = 251;
    public static final int PP_MAX_DOMAINS = 128;
    public static final int LINKSET_SEED_VALUE = 37;
    public static final int PP_MAX_UNIQUE_LINK_NAMES = 1024;
    public static final int LINE_LIMIT = 70;
    public static final String DEFAULTPATH = ".:./data:./data/link:/home/liferay/linkgrammar:/home/liferay/linkgrammar/data:/home/liferay/linkgrammar/data/link";
    public static final int MAX_STRIP = 10;
    public static final int MAX_HEIGHT = 30;
    public static final int COMMA_LABEL = -2;
    public static final int EITHER_LABEL = -3;
    public static final int NEITHER_LABEL = -4;
    public static final int NOT_LABEL = -5;
    public static final int NOTONLY_LABEL = -6;
    public static final int BOTH_LABEL = -7;
    public static final int MAXCONSTITUENTS = 1024;
    public static final int MAXSUBL = 16;
    public static final char OPEN_BRACKET = '[';
    public static final char CLOSE_BRACKET = ']';
    public static final int CType_OPEN = 0;
    public static final int CType_CLOSE = 1;
    public static final int CType_WORD = 2;
    public static final int WType_NONE = 0;
    public static final int WType_STYPE = 1;
    public static final int WType_PTYPE = 2;
    public static final int WType_QTYPE = 3;
    public static final int WType_QDTYPE = 4;
    public static int batch_errors = 0;
    public static boolean input_pending = false;
    public static int input_char;
    public static ParseOptions opts;
    public static int lperrno;
    public static String lperrmsg;
    public static int STAT_N_disjuncts;
    public static int STAT_calls_to_equality_test;

    public static void left_append_string(StringBuffer string, String s2, String t) {
        int j = t.length();
        int k = s2.length();
        for (int i = 0; i < j; ++i) {
            if (i < k) {
                string.append(s2.charAt(i));
                continue;
            }
            string.append(t.charAt(i));
        }
    }

    public static int strip_off_label(StringBuffer input_string) {
        char c = input_string.charAt(0);
        switch (c) {
            case '*': 
            case ':': {
                input_string.setCharAt(0, ' ');
                return c;
            }
        }
        return 32;
    }

    public static boolean special_command(StringBuffer input_string, Dictionary dict) {
        if (input_string.charAt(0) == '\n') {
            return true;
        }
        if (input_string.charAt(0) == '%') {
            return true;
        }
        if (input_string.charAt(0) == '!') {
            opts.issue_special_command(input_string.substring(1), dict);
            return true;
        }
        return false;
    }

    public static void batch_process_some_linkages(int label, Sentence sent, ParseOptions opts) {
        if (GlobalBean.there_was_an_error(label, sent, opts) != 0) {
            if (sent.sentence_num_linkages_found() > 0) {
                Linkage linkage = new Linkage(0, sent, opts);
                linkage.process_linkage(opts);
            }
            opts.out.println("+++++ error " + batch_errors);
        }
    }

    public static int there_was_an_error(int label, Sentence sent, ParseOptions opts) {
        if (sent.sentence_num_valid_linkages() > 0) {
            if (label == 42) {
                opts.out.println("error: parsed ungrammatical sentence");
                ++batch_errors;
                return 42;
            }
            if (sent.sentence_disjunct_cost(0) == 0 && label == 58) {
                opts.out.println("error: cost=0");
                ++batch_errors;
                return 58;
            }
        } else if (label != 42) {
            opts.out.println("error: failed");
            ++batch_errors;
            return 42;
        }
        return 0;
    }

    public static void process_some_linkages(Sentence sent, ParseOptions opts) throws IOException {
        if (opts.verbosity > 0) {
            sent.print_parse_statistics(opts);
        }
        int num_to_query = !opts.parse_options_get_display_bad() ? Math.min(sent.sentence_num_valid_linkages(), 1024) : Math.min(sent.sentence_num_linkages_post_processed(), 1024);
        int num_displayed = 0;
        for (int i = 0; i < num_to_query; ++i) {
            int c;
            if (sent.sentence_num_violations(i) > 0 && !opts.parse_options_get_display_bad()) continue;
            Linkage linkage = new Linkage(i, sent, opts);
            if (opts.verbosity > 0) {
                if (sent.sentence_num_valid_linkages() == 1 && !opts.parse_options_get_display_bad()) {
                    opts.out.print("  Unique linkage, ");
                } else if (opts.parse_options_get_display_bad() && sent.sentence_num_violations(i) > 0) {
                    opts.out.print("  Linkage " + (i + 1) + " (bad), ");
                } else {
                    opts.out.print("  Linkage " + (i + 1) + ", ");
                }
                if (!linkage.linkage_is_canonical()) {
                    opts.out.print("non-canonical, ");
                }
                if (linkage.linkage_is_improper()) {
                    opts.out.print("improper fat linkage, ");
                }
                if (linkage.linkage_has_inconsistent_domains()) {
                    opts.out.print("inconsistent domains, ");
                }
                opts.out.println("cost vector = (UNUSED=" + linkage.linkage_unused_word_cost() + " DIS=" + linkage.linkage_disjunct_cost() + " AND=" + linkage.linkage_and_cost() + " LEN=" + linkage.linkage_link_cost() + ")");
            }
            linkage.process_linkage(opts);
            if (++num_displayed >= num_to_query) continue;
            if (opts.verbosity > 0) {
                opts.out.println("Press RETURN for the next linkage.");
            }
            if ((c = GlobalBean.fget_input_char(System.in, opts)) == 10 || c == 13) continue;
            input_char = c;
            input_pending = true;
            break;
        }
    }

    public static int fget_input_char(InputStream in, ParseOptions opts) throws IOException {
        if (!opts.parse_options_get_batch_mode() && opts.verbosity > 0) {
            opts.out.print("linkparser> ");
        }
        opts.out.flush();
        return in.read();
    }

    public static boolean fget_input_string(StringBuffer input_string, InputStream in, PrintStream out, ParseOptions opts) throws IOException {
        int c;
        input_string.setLength(0);
        if (input_pending) {
            input_pending = false;
            c = input_char;
        } else {
            if (!opts.parse_options_get_batch_mode() && opts.verbosity > 0) {
                out.println("linkparser> ");
            }
            out.flush();
            c = in.read();
        }
        while (c != 10) {
            if (c < 0) {
                return false;
            }
            input_string.append((char)c);
            c = in.read();
        }
        return true;
    }
}

