/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import net.sf.jlinkgrammar.Clause;
import net.sf.jlinkgrammar.Connector;
import net.sf.jlinkgrammar.ConnectorSet;
import net.sf.jlinkgrammar.ExpList;
import net.sf.jlinkgrammar.MyRandom;
import net.sf.jlinkgrammar.Sentence;
import net.sf.jlinkgrammar.TConnector;

public class Exp {
    int type;
    int cost;
    char dir;
    boolean multi;
    ExpList l;
    String string;
    Exp next;

    Exp(Exp e) {
        this.type = e.type;
        this.cost = e.cost;
        this.dir = e.dir;
        this.multi = e.multi;
        this.l = e.l;
        this.string = e.string;
        this.next = e.next;
    }

    Exp() {
    }

    Clause build_Clause(int cost_cutoff) {
        Clause c3;
        ExpList e_list;
        Clause c1;
        Clause c = null;
        if (this.type == 1) {
            c1 = new Clause();
            c1.c = null;
            c1.next = null;
            c1.cost = 0;
            c1.maxcost = 0;
            e_list = this.l;
            while (e_list != null) {
                Clause c2 = e_list.e.build_Clause(cost_cutoff);
                Clause c_head = null;
                c3 = c1;
                while (c3 != null) {
                    Clause c4 = c2;
                    while (c4 != null) {
                        c = new Clause();
                        c.cost = c3.cost + c4.cost;
                        c.maxcost = Math.max(c3.maxcost, c4.maxcost);
                        c.c = TConnector.catenate(c3.c, c4.c);
                        c.next = c_head;
                        c_head = c;
                        c4 = c4.next;
                    }
                    c3 = c3.next;
                }
                c1 = c_head;
                e_list = e_list.next;
            }
            c = c1;
        } else if (this.type == 0) {
            c = null;
            e_list = this.l;
            while (e_list != null) {
                c1 = e_list.e.build_Clause(cost_cutoff);
                while (c1 != null) {
                    c3 = c1.next;
                    c1.next = c;
                    c = c1;
                    c1 = c3;
                }
                e_list = e_list.next;
            }
        } else if (this.type == 2) {
            c = new Clause();
            c.c = this.build_terminal();
            c.cost = 0;
            c.maxcost = 0;
            c.next = null;
        } else {
            throw new RuntimeException("an expression node with no type");
        }
        c1 = c;
        while (c1 != null) {
            c1.cost += this.cost;
            c1.maxcost += this.cost;
            c1 = c1.next;
        }
        return c;
    }

    TConnector build_terminal() {
        TConnector c = new TConnector(this);
        return c;
    }

    int size_of_expression() {
        if (this.type == 2) {
            return 1;
        }
        int size = 0;
        ExpList el = this.l;
        while (el != null) {
            size += el.e.size_of_expression();
            el = el.next;
        }
        return size;
    }

    void insert_connectors(int dir2) {
        Connector dummy = new Connector();
        dummy.init_connector();
        dummy.label = -1;
        dummy.priority = 0;
        if (this.type == 2) {
            if (dir2 == this.dir) {
                dummy.string = this.string;
                Sentence.insert_S(dummy);
            }
        } else {
            ExpList el = this.l;
            while (el != null) {
                el.e.insert_connectors(dir2);
                el = el.next;
            }
        }
    }

    int mark_dead_connectors(Sentence sent, char d) {
        int count;
        block2: {
            block1: {
                Connector dummy = new Connector();
                dummy.init_connector();
                dummy.label = -1;
                dummy.priority = 0;
                count = 0;
                if (this.type != 2) break block1;
                if (this.dir != d) break block2;
                dummy.string = this.string;
                if (sent.matches_S(dummy, d)) break block2;
                this.string = null;
                ++count;
                break block2;
            }
            ExpList el = this.l;
            while (el != null) {
                count += el.e.mark_dead_connectors(sent, d);
                el = el.next;
            }
        }
        return count;
    }

    Exp purge_Exp() {
        if (this.type == 2) {
            if (this.string == null) {
                return null;
            }
            return this;
        }
        if (this.type == 1) {
            if (!Exp.and_purge_ExpList(this.l)) {
                return null;
            }
        } else {
            this.l = this.or_purge_ExpList(this.l);
            if (this.l == null) {
                return null;
            }
        }
        return this;
    }

    static boolean and_purge_ExpList(ExpList l) {
        if (l == null) {
            return true;
        }
        l.e = l.e.purge_Exp();
        if (l.e == null) {
            return false;
        }
        return Exp.and_purge_ExpList(l.next);
    }

    ExpList or_purge_ExpList(ExpList l) {
        if (l == null) {
            return null;
        }
        l.e = l.e.purge_Exp();
        if (l.e == null) {
            ExpList el = this.or_purge_ExpList(l.next);
            return el;
        }
        l.next = this.or_purge_ExpList(l.next);
        return l;
    }

    static Exp copy_Exp(Exp e) {
        if (e == null) {
            return null;
        }
        Exp n = new Exp(e);
        if (e.type != 2) {
            n.l = ExpList.copy_ExpList(e.l);
        }
        return n;
    }

    ConnectorSet connector_set_create() {
        ConnectorSet conset = new ConnectorSet();
        conset.table_size = MyRandom.next_power_of_two_up(this.size_of_expression());
        conset.hash_table = new Connector[conset.table_size];
        for (int i = 0; i < conset.table_size; ++i) {
            conset.hash_table[i] = null;
        }
        this.build_connector_set_from_expression(conset);
        return conset;
    }

    void build_connector_set_from_expression(ConnectorSet conset) {
        if (this.type == 2) {
            Connector c = new Connector();
            c.init_connector();
            c.string = this.string;
            c.label = -1;
            c.priority = 0;
            c.word = this.dir;
            int h2 = conset.connector_set_hash(c.string, c.word);
            c.next = conset.hash_table[h2];
            conset.hash_table[h2] = c;
        } else {
            ExpList el = this.l;
            while (el != null) {
                el.e.build_connector_set_from_expression(conset);
                el = el.next;
            }
        }
    }
}

