/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import edu.northwestern.at.utils.Env;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.StringTokenizer;
import net.sf.jlinkgrammar.ConnectorSet;
import net.sf.jlinkgrammar.DictNode;
import net.sf.jlinkgrammar.Disjunct;
import net.sf.jlinkgrammar.Exp;
import net.sf.jlinkgrammar.ExpList;
import net.sf.jlinkgrammar.GlobalBean;
import net.sf.jlinkgrammar.MyRandom;
import net.sf.jlinkgrammar.PPData;
import net.sf.jlinkgrammar.PPKnowledge;
import net.sf.jlinkgrammar.PPLinkset;
import net.sf.jlinkgrammar.ParseOptions;
import net.sf.jlinkgrammar.Postprocessor;
import net.sf.jlinkgrammar.WordFile;

public class Dictionary {
    public DictNode root;
    public String name;
    public boolean use_unknown_word;
    public boolean unknown_word_defined;
    public boolean capitalized_word_defined;
    public boolean pl_capitalized_word_defined;
    public boolean hyphenated_word_defined;
    public boolean number_word_defined;
    public boolean ing_word_defined;
    public boolean s_word_defined;
    public boolean ed_word_defined;
    public boolean ly_word_defined;
    public boolean left_wall_defined;
    public boolean right_wall_defined;
    public Postprocessor postprocessor;
    public Postprocessor constituent_pp;
    public Dictionary affix_table;
    public boolean andable_defined;
    public ConnectorSet andable_connector_set;
    public ConnectorSet unlimited_connector_set;
    public int max_cost;
    public int num_entries;
    public ParseOptions opts;
    public WordFile word_file_header;
    public Exp exp_list;
    public Reader fp;
    public StringBuffer token = new StringBuffer();
    public boolean is_special;
    public int already_got_it;
    public int line_number;
    DictNode lookup_list = null;
    static boolean rand_table_inited = false;
    static StringBuffer current_name = new StringBuffer("AAAAAAAA");
    static final int CN_size = current_name.length();
    private static final String SPECIAL = "(){};[]&|:";

    private Dictionary(ParseOptions opts, String dict_name, String pp_name, String cons_name, String affix_name, String path) throws IOException {
        if (!rand_table_inited) {
            MyRandom.init_randtable();
            rand_table_inited = true;
        }
        this.opts = opts;
        this.name = dict_name;
        this.num_entries = 0;
        this.is_special = false;
        this.already_got_it = 0;
        this.line_number = 1;
        this.root = null;
        this.word_file_header = null;
        this.exp_list = null;
        this.affix_table = null;
        String dictionary_path_name = path != null ? path : dict_name;
        if (!this.open_dictionary(dictionary_path_name)) {
            throw new RuntimeException("Could not open dictionary " + dict_name);
        }
        this.read_dictionary();
        this.left_wall_defined = this.boolean_dictionary_lookup("LEFT-WALL");
        this.right_wall_defined = this.boolean_dictionary_lookup("RIGHT-WALL");
        this.postprocessor = this.post_process_open(opts, this.name, pp_name);
        this.constituent_pp = this.post_process_open(opts, this.name, cons_name);
        this.affix_table = null;
        if (affix_name != null) {
            this.affix_table = new Dictionary(opts, affix_name, null, null, null, dict_name);
        }
        this.unknown_word_defined = this.boolean_dictionary_lookup("UNKNOWN-WORD");
        this.use_unknown_word = true;
        this.capitalized_word_defined = this.boolean_dictionary_lookup("CAPITALIZED-WORDS");
        this.pl_capitalized_word_defined = this.boolean_dictionary_lookup("PL-CAPITALIZED-WORDS");
        this.hyphenated_word_defined = this.boolean_dictionary_lookup("HYPHENATED-WORDS");
        this.number_word_defined = this.boolean_dictionary_lookup("NUMBERS");
        this.ing_word_defined = this.boolean_dictionary_lookup("ING-WORDS");
        this.s_word_defined = this.boolean_dictionary_lookup("S-WORDS");
        this.ed_word_defined = this.boolean_dictionary_lookup("ED-WORDS");
        this.ly_word_defined = this.boolean_dictionary_lookup("LY-WORDS");
        this.max_cost = 1000;
        DictNode dict_node = this.dictionary_lookup("ANDABLE-CONNECTORS");
        this.andable_connector_set = dict_node != null ? dict_node.exp.connector_set_create() : null;
        dict_node = this.dictionary_lookup("UNLIMITED-CONNECTORS");
        this.unlimited_connector_set = dict_node != null ? dict_node.exp.connector_set_create() : null;
        this.lookup_list = null;
    }

    public Dictionary(ParseOptions opts, String dict_name, String pp_name, String cons_name, String affix_name) throws IOException {
        this(opts, dict_name, pp_name, cons_name, affix_name, null);
    }

    Postprocessor post_process_open(ParseOptions opts, String dictname, String path) throws IOException {
        if (path == null) {
            return null;
        }
        Postprocessor pp = new Postprocessor();
        pp.knowledge = new PPKnowledge(opts, dictname, path);
        pp.set_of_links_of_sentence = PPLinkset.PPLinkset_open(1024);
        pp.set_of_links_in_an_active_rule = PPLinkset.PPLinkset_open(1024);
        pp.relevant_contains_one_rules = new int[pp.knowledge.n_contains_one_rules + 1];
        pp.relevant_contains_none_rules = new int[pp.knowledge.n_contains_none_rules + 1];
        pp.relevant_contains_one_rules[0] = -1;
        pp.relevant_contains_none_rules[0] = -1;
        pp.pp_node = null;
        pp.pp_data = new PPData();
        pp.pp_data.links_to_ignore = null;
        pp.n_local_rules_firing = 0;
        pp.n_global_rules_firing = 0;
        return pp;
    }

    boolean open_dictionary(String dict_path_name) throws IOException {
        this.fp = Dictionary.dictopen(this.opts, dict_path_name, this.name);
        return this.fp != null;
    }

    public void read_dictionary() throws IOException {
        GlobalBean.lperrno = 0;
        if (!this.advance()) {
            this.fp.close();
            throw new RuntimeException(GlobalBean.lperrmsg);
        }
        while (this.token.length() > 0) {
            if (this.read_entry()) continue;
            this.fp.close();
            throw new RuntimeException(GlobalBean.lperrmsg);
        }
        this.fp.close();
    }

    public DictNode dictionary_lookup(String s2) {
        this.lookup_list = null;
        this.rdictionary_lookup(this.root, s2);
        this.prune_lookup_list(s2);
        return this.lookup_list;
    }

    void prune_lookup_list(String s2) {
        DictNode dnx;
        DictNode dn_new = null;
        DictNode dn = this.lookup_list;
        while (dn != null) {
            dnx = dn.right;
            if (this.true_dict_match(dn.string, s2)) {
                dn.right = dn_new;
                dn_new = dn;
            }
            dn = dnx;
        }
        this.lookup_list = null;
        dn = dn_new;
        while (dn != null) {
            dnx = dn.right;
            dn.right = this.lookup_list;
            this.lookup_list = dn;
            dn = dnx;
        }
    }

    void rdictionary_lookup(DictNode dn, String s2) {
        if (dn == null) {
            return;
        }
        int m3 = this.dict_match(s2, dn.string);
        if (m3 >= 0) {
            this.rdictionary_lookup(dn.right, s2);
        }
        if (m3 == 0) {
            DictNode dn_new = new DictNode(dn);
            dn_new.right = this.lookup_list;
            this.lookup_list = dn_new;
        }
        if (m3 <= 0) {
            this.rdictionary_lookup(dn.left, s2);
        }
    }

    boolean boolean_dictionary_lookup(String s2) {
        return this.dictionary_lookup(s2) != null;
    }

    void rabridged_lookup(DictNode dn, String s2) {
        if (dn == null) {
            return;
        }
        int m3 = this.dict_match(s2, dn.string);
        if (m3 >= 0) {
            this.rabridged_lookup(dn.right, s2);
        }
        if (m3 == 0 && !Dictionary.is_idiom_word(dn.string)) {
            DictNode dn_new = new DictNode(dn);
            dn_new.right = this.lookup_list;
            this.lookup_list = dn_new;
        }
        if (m3 <= 0) {
            this.rabridged_lookup(dn.left, s2);
        }
    }

    DictNode abridged_lookup(String s2) {
        this.lookup_list = null;
        this.rabridged_lookup(this.root, s2);
        this.prune_lookup_list(s2);
        return this.lookup_list;
    }

    boolean boolean_abridged_lookup(String s2) {
        return this.abridged_lookup(s2) != null;
    }

    int dict_match(String s2, String t) {
        int i;
        for (i = 0; i < s2.length() && i < t.length() && s2.charAt(i) == t.charAt(i); ++i) {
        }
        if (i < s2.length() && i < t.length() && (s2.charAt(i) == '*' || t.charAt(i) == '*')) {
            return 0;
        }
        return (i >= s2.length() || s2.charAt(i) == '.' ? (char)'\u0000' : s2.charAt(i)) - (i >= t.length() || t.charAt(i) == '.' ? (char)'\u0000' : t.charAt(i));
    }

    boolean true_dict_match(String s2, String t) {
        int ds = s2.lastIndexOf(46);
        int dt = t.lastIndexOf(46);
        if (dt >= 0 && (dt == t.length() - 1 || Character.isDigit(t.charAt(dt + 1)))) {
            dt = -1;
        }
        if (ds >= 0 && (ds == s2.length() - 1 || Character.isDigit(s2.charAt(ds + 1)))) {
            ds = -1;
        }
        if (dt < 0 && ds >= 0) {
            if (t.length() > ds) {
                return false;
            }
            return s2.startsWith(t);
        }
        if (dt >= 0 && ds < 0) {
            if (s2.length() > dt) {
                return false;
            }
            return t.startsWith(s2);
        }
        return s2.equals(t);
    }

    void dict_display_word_info(String s2) {
        DictNode dn = this.dictionary_lookup(s2);
        if (dn == null) {
            this.opts.out.println("    \"" + s2 + "\" matches nothing in the dictionary.");
            return;
        }
        this.opts.out.println("Matches:");
        while (dn != null) {
            Disjunct d1;
            int len = 0;
            Disjunct d2 = d1 = dn.build_disjuncts_for_dict_node();
            while (d2 != null) {
                ++len;
                d2 = d2.next;
            }
            this.opts.out.print("          ");
            this.opts.left_print_string(dn.string, "                  ");
            this.opts.out.print(" " + len + "  ");
            if (dn.file != null) {
                this.opts.out.print("<" + dn.file.file + ">");
            }
            this.opts.out.println();
            dn = dn.right;
        }
    }

    static boolean is_idiom_string(String s2) {
        int i;
        for (i = 0; i < s2.length(); ++i) {
            if (s2.charAt(i) != '.') continue;
            return false;
        }
        if (s2.charAt(0) == '_' || s2.charAt(s2.length() - 1) == '_') {
            return false;
        }
        for (i = 0; i < s2.length() - 1; ++i) {
            if (s2.charAt(i) != '_' || s2.charAt(i + 1) != '_') continue;
            return false;
        }
        return true;
    }

    static boolean is_idiom_word(String s2) {
        return Dictionary.numberfy(s2) != -1;
    }

    static boolean is_initials_word(String word) {
        for (int i = 0; i < word.length() - 1; i += 2) {
            if (!Character.isUpperCase(word.charAt(i))) {
                return false;
            }
            if (word.charAt(i + 1) == '.') continue;
            return false;
        }
        return true;
    }

    static boolean is_number(String s2) {
        if (!Character.isDigit(s2.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s2.length(); ++i) {
            if (Character.isDigit(s2.charAt(i)) || s2.charAt(i) == '.' || s2.charAt(i) == ',' || s2.charAt(i) == ':') continue;
            return false;
        }
        return true;
    }

    static boolean ishyphenated(String s2) {
        int i;
        int hyp = 0;
        if (s2.charAt(0) == '-') {
            return false;
        }
        for (i = 0; i < s2.length(); ++i) {
            if (!Character.isLetterOrDigit(s2.charAt(i)) && s2.charAt(i) != '.' && s2.charAt(i) != ',' && s2.charAt(i) != '-') {
                return false;
            }
            if (s2.charAt(i) != '-') continue;
            ++hyp;
        }
        return hyp > 0 && s2.charAt(i - 1) != '-';
    }

    static boolean is_ing_word(String s2) {
        int i = s2.length();
        if (i < 5) {
            return false;
        }
        return s2.endsWith("ing");
    }

    static boolean is_s_word(String s2) {
        int i = s2.length() - 1;
        if (i < 1) {
            return false;
        }
        if (s2.charAt(i) != 's') {
            return false;
        }
        return s2.charAt(--i) != 'i' && s2.charAt(i) != 'u' && s2.charAt(i) != 'o' && s2.charAt(i) != 'y' && s2.charAt(i) != 's';
    }

    static boolean is_ed_word(String s2) {
        int i = s2.length();
        if (i < 4) {
            return false;
        }
        return s2.endsWith("ed");
    }

    static boolean is_ly_word(String s2) {
        int i = s2.length();
        if (i < 4) {
            return false;
        }
        return s2.endsWith("ly");
    }

    static int numberfy(String s2) {
        int i;
        for (i = 0; i < s2.length() && s2.charAt(i) != '.'; ++i) {
        }
        if (i >= s2.length()) {
            return -1;
        }
        if (++i >= s2.length() || s2.charAt(i) != 'I') {
            return -1;
        }
        if (++i >= s2.length() || !Dictionary.is_idiom_number(s2.substring(i))) {
            return -1;
        }
        return Integer.parseInt(s2.substring(i));
    }

    static boolean is_idiom_number(String s2) {
        for (int i = 0; i < s2.length(); ++i) {
            if (Character.isDigit(s2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static boolean contains_underbar(String s2) {
        return s2.indexOf(95) >= 0;
    }

    void dict_error(String s2) throws IOException {
        StringBuffer tokens = new StringBuffer(1024);
        for (int i = 0; i < 5 && this.token.length() > 0; ++i) {
            tokens.append('\"');
            tokens.append(this.token);
            tokens.append("\" ");
            this.advance();
        }
        GlobalBean.lperrmsg = "Error parsing dictionary . " + s2 + ", line " + this.line_number + ", tokens = " + tokens.toString();
    }

    void warning(String s2) {
        this.opts.out.println();
        this.opts.out.println("Warning: " + s2);
        this.opts.out.println("line " + this.line_number + ", current token = \"" + this.token.toString() + "\"");
        this.opts.out.println();
    }

    Exp Exp_create() {
        Exp e = new Exp();
        e.next = this.exp_list;
        this.exp_list = e;
        return e;
    }

    int get_character(boolean quote_mode) throws IOException {
        int c = this.fp.read();
        if (c == 37 && !quote_mode) {
            while (c >= 0 && c != 10) {
                c = this.fp.read();
            }
        }
        if (c == 10) {
            ++this.line_number;
        }
        return c;
    }

    boolean advance() throws IOException {
        int c;
        this.is_special = false;
        this.token.setLength(0);
        if (this.already_got_it != 0) {
            boolean bl = this.is_special = SPECIAL.indexOf(this.already_got_it) >= 0;
            if (this.already_got_it >= 0) {
                this.token.append((char)this.already_got_it);
            }
            this.already_got_it = 0;
            return true;
        }
        while ((c = this.get_character(false)) >= 0 && Character.isWhitespace((char)c)) {
        }
        boolean quote_mode = false;
        int i = 0;
        while (true) {
            if (quote_mode) {
                if (c == 34) {
                    quote_mode = false;
                    return true;
                }
                if (Character.isWhitespace((char)c)) {
                    this.dict_error("White space inside of token");
                    return false;
                }
                this.token.append((char)c);
                ++i;
            } else {
                if (SPECIAL.indexOf(c) >= 0) {
                    if (i == 0) {
                        this.token.append((char)c);
                        this.is_special = true;
                        return true;
                    }
                    this.already_got_it = c;
                    return true;
                }
                if (c < 0) {
                    if (i == 0) {
                        return true;
                    }
                    this.already_got_it = c;
                    return true;
                }
                if (Character.isWhitespace((char)c)) {
                    return true;
                }
                if (c == 34) {
                    quote_mode = true;
                } else {
                    this.token.append((char)c);
                    ++i;
                }
            }
            c = this.get_character(quote_mode);
        }
    }

    boolean is_equal(int c) {
        return this.is_special && this.token.length() == 1 && c == this.token.charAt(0);
    }

    boolean check_connector(String s2) throws IOException {
        int i = s2.length();
        int j = 0;
        if (i < 1) {
            this.dict_error("Expecting a connector.");
            return false;
        }
        if (s2.charAt(i - 1) != '+' && s2.charAt(i - 1) != '-') {
            this.dict_error("A connector must end in a \"+\" or \"-\".");
            return false;
        }
        if (s2.charAt(j) == '@') {
            ++j;
        }
        if (!Character.isUpperCase(s2.charAt(j))) {
            this.dict_error("The first letter of a connector must be in [A-Z] (was " + s2.charAt(j) + ").");
            return false;
        }
        if (s2.charAt(j) == 'I' && j < s2.length() - 1 && s2.charAt(j + 1) == 'D') {
            this.dict_error("Connectors beginning with \"ID\" are forbidden");
            return false;
        }
        while (j < s2.length() - 1) {
            if (!Character.isLetterOrDigit(s2.charAt(j)) && s2.charAt(j) != '*' && s2.charAt(j) != '^') {
                this.dict_error("All letters of a connector must be alpha-numeric.");
                return false;
            }
            ++j;
        }
        return true;
    }

    Exp connector() throws IOException {
        Exp n;
        int i = this.token.length() - 1;
        if (this.token.charAt(i) != '+' && this.token.charAt(i) != '-') {
            DictNode dn = this.abridged_lookup(this.token.toString());
            while (dn != null && !dn.string.equals(this.token.toString())) {
                dn = dn.right;
            }
            if (dn == null) {
                this.dict_error("\nPerhaps missing + or - in a connector.\nOr perhaps you forgot the suffix on a word.\nOr perhaps a word is used before it is defined.\n");
                return null;
            }
            n = this.make_unary_node(dn.exp);
        } else {
            if (!this.check_connector(this.token.toString())) {
                return null;
            }
            n = this.Exp_create();
            n.dir = this.token.charAt(i);
            this.token.deleteCharAt(i);
            if (this.token.charAt(0) == '@') {
                n.string = this.token.substring(1);
                n.multi = true;
            } else {
                n.string = this.token.toString();
                n.multi = false;
            }
            n.type = 2;
            n.cost = 0;
        }
        if (!this.advance()) {
            return null;
        }
        return n;
    }

    Exp make_unary_node(Exp e) {
        Exp n = this.Exp_create();
        n.type = 1;
        n.cost = 0;
        n.l = new ExpList();
        n.l.next = null;
        n.l.e = e;
        return n;
    }

    Exp make_zeroary_node() {
        Exp n = this.Exp_create();
        n.type = 1;
        n.cost = 0;
        n.l = null;
        return n;
    }

    Exp make_optional_node(Exp e) {
        ExpList elx;
        ExpList el;
        Exp n = this.Exp_create();
        n.type = 0;
        n.cost = 0;
        n.l = el = new ExpList();
        el.e = this.make_zeroary_node();
        el.next = elx = new ExpList();
        elx.next = null;
        elx.e = e;
        return n;
    }

    Exp expression() throws IOException {
        return this.restricted_expression(true, true);
    }

    Exp restricted_expression(boolean and_ok, boolean or_ok) throws IOException {
        Exp n;
        Exp nl = null;
        if (this.is_equal(40)) {
            if (!this.advance()) {
                return null;
            }
            nl = this.expression();
            if (nl == null) {
                return null;
            }
            if (!this.is_equal(41)) {
                this.dict_error("Expecting a \")\".");
                return null;
            }
            if (!this.advance()) {
                return null;
            }
        } else if (this.is_equal(123)) {
            if (!this.advance()) {
                return null;
            }
            nl = this.expression();
            if (nl == null) {
                return null;
            }
            if (!this.is_equal(125)) {
                this.dict_error("Expecting a \"}\".");
                return null;
            }
            if (!this.advance()) {
                return null;
            }
            nl = this.make_optional_node(nl);
        } else if (this.is_equal(91)) {
            if (!this.advance()) {
                return null;
            }
            nl = this.expression();
            if (nl == null) {
                return null;
            }
            if (!this.is_equal(93)) {
                this.dict_error("Expecting a \"]\".");
                return null;
            }
            if (!this.advance()) {
                return null;
            }
            ++nl.cost;
        } else if (!this.is_special) {
            nl = this.connector();
            if (nl == null) {
                return null;
            }
        } else if (this.is_equal(41) || this.is_equal(93)) {
            nl = this.make_zeroary_node();
        } else {
            this.dict_error("Connector, \"(\", \"[\", or \"{\" expected.");
            return null;
        }
        if (this.is_equal(38) || this.token.toString().equals("and")) {
            ExpList elr;
            ExpList ell;
            if (!and_ok) {
                this.warning("\"and\" and \"or\" at the same level in an expression");
            }
            if (!this.advance()) {
                return null;
            }
            Exp nr = this.restricted_expression(true, false);
            if (nr == null) {
                return null;
            }
            n = this.Exp_create();
            n.l = ell = new ExpList();
            ell.next = elr = new ExpList();
            elr.next = null;
            ell.e = nl;
            elr.e = nr;
            n.type = 1;
            n.cost = 0;
        } else if (this.is_equal(124) || this.token.toString().equals("or")) {
            ExpList elr;
            ExpList ell;
            if (!or_ok) {
                this.warning("\"and\" and \"or\" at the same level in an expression");
            }
            if (!this.advance()) {
                return null;
            }
            Exp nr = this.restricted_expression(false, true);
            if (nr == null) {
                return null;
            }
            n = this.Exp_create();
            n.l = ell = new ExpList();
            ell.next = elr = new ExpList();
            elr.next = null;
            ell.e = nl;
            elr.e = nr;
            n.type = 0;
            n.cost = 0;
        } else {
            return nl;
        }
        return n;
    }

    int dict_compare(String s2, String t) {
        int i;
        for (i = 0; i < s2.length() && i < t.length() && s2.charAt(i) == t.charAt(i); ++i) {
        }
        return (i >= s2.length() ? 0 : (s2.charAt(i) == '.' ? 1 : s2.charAt(i) << 1)) - (i >= t.length() ? 0 : (t.charAt(i) == '.' ? 1 : t.charAt(i) << 1));
    }

    DictNode insert_dict(DictNode n, DictNode newNode) throws IOException {
        if (n == null) {
            return newNode;
        }
        int comp = this.dict_compare(newNode.string, n.string);
        if (comp < 0) {
            n.left = this.insert_dict(n.left, newNode);
        } else if (comp > 0) {
            n.right = this.insert_dict(n.right, newNode);
        } else {
            this.dict_error("The word \"" + newNode.string + "\" has been multiply defined\n");
            return null;
        }
        return n;
    }

    void insert_list(DictNode p, int l) throws IOException {
        if (l == 0) {
            return;
        }
        int k = (l - 1) / 2;
        DictNode dn = p;
        for (int i = 0; i < k; ++i) {
            dn = dn.left;
        }
        DictNode dn_second_half = dn.left;
        dn.right = null;
        dn.left = null;
        if (Dictionary.contains_underbar(dn.string)) {
            this.insert_idiom(dn);
        } else if (Dictionary.is_idiom_word(dn.string)) {
            this.opts.out.println("*** Word \"" + dn.string + "\" found near line " + this.line_number + ".");
            this.opts.out.println("    Words ending \".Ix\" (x a number) are reserved for idioms.");
            this.opts.out.println("    This word will be ignored.");
        } else {
            DictNode dnx = this.abridged_lookup(dn.string);
            if (dnx != null) {
                this.opts.out.println("*** The word \"" + dn.string + "\"");
                this.opts.out.println(" found near line " + this.line_number + " matches the following words:");
                while (dnx != null) {
                    this.opts.out.print(" " + dnx.string);
                    dnx = dnx.right;
                }
                this.opts.out.println("\n    This word will be ignored.");
            } else {
                this.root = this.insert_dict(this.root, dn);
                ++this.num_entries;
            }
        }
        this.insert_list(p, k);
        this.insert_list(dn_second_half, l - k - 1);
    }

    boolean read_entry() throws IOException {
        DictNode dn = null;
        while (!this.is_equal(58)) {
            if (this.is_special) {
                this.dict_error("I expected a word but didn't get it.");
                throw new RuntimeException(GlobalBean.lperrmsg);
            }
            if (this.token.charAt(0) == '/') {
                if ((dn = this.read_word_file(dn, this.token.toString())) == null) {
                    throw new RuntimeException("Error reading word file " + this.token.toString() + ", file empty?");
                }
            } else {
                DictNode dn_new = new DictNode();
                dn_new.left = dn;
                dn = dn_new;
                dn.file = null;
                dn.string = this.token.toString();
            }
            this.advance();
        }
        if (!this.advance()) {
            return false;
        }
        Exp n = this.expression();
        if (n == null) {
            return false;
        }
        if (!this.is_equal(59)) {
            this.dict_error("Expecting \";\" at the end of an entry.");
            throw new RuntimeException(GlobalBean.lperrmsg);
        }
        if (!this.advance()) {
            return false;
        }
        int i = 0;
        DictNode dnx = dn;
        while (dnx != null) {
            dnx.exp = n;
            ++i;
            dnx = dnx.left;
        }
        this.insert_list(dn, i);
        return true;
    }

    void insert_idiom(DictNode dn) throws IOException {
        ExpList elr;
        ExpList ell;
        DictNode start_dn_list;
        Exp no = dn.exp;
        String s2 = dn.string;
        if (!Dictionary.is_idiom_string(s2)) {
            this.opts.out.println("*** Word \"" + s2 + "\" on line " + this.line_number + " is not a correctly formed idiom string.\n");
            this.opts.out.println("    This word will be ignored");
            return;
        }
        DictNode dn_list = start_dn_list = this.make_idiom_DictNodes(s2);
        if (dn_list.right == null) {
            throw new RuntimeException("Idiom string with only one connector -- should have been caught");
        }
        Exp nc = this.Exp_create();
        nc.string = this.generate_id_connector();
        nc.dir = (char)45;
        nc.multi = false;
        nc.type = 2;
        nc.cost = 0;
        Exp n1 = this.Exp_create();
        n1.l = ell = new ExpList();
        ell.next = elr = new ExpList();
        elr.next = null;
        ell.e = nc;
        elr.e = no;
        n1.type = 1;
        n1.cost = 0;
        dn_list.exp = n1;
        dn_list = dn_list.right;
        while (dn_list.right != null) {
            n1 = this.Exp_create();
            n1.string = null;
            n1.type = 1;
            n1.cost = 0;
            n1.l = ell = new ExpList();
            ell.next = elr = new ExpList();
            elr.next = null;
            nc = this.Exp_create();
            nc.string = this.generate_id_connector();
            nc.dir = (char)43;
            nc.multi = false;
            nc.type = 2;
            nc.cost = 0;
            elr.e = nc;
            this.increment_current_name();
            nc = this.Exp_create();
            nc.string = this.generate_id_connector();
            nc.dir = (char)45;
            nc.multi = false;
            nc.type = 2;
            nc.cost = 0;
            ell.e = nc;
            dn_list.exp = n1;
            dn_list = dn_list.right;
        }
        nc = this.Exp_create();
        nc.string = this.generate_id_connector();
        nc.dir = (char)43;
        nc.multi = false;
        nc.type = 2;
        nc.cost = 0;
        dn_list.exp = nc;
        this.increment_current_name();
        dn_list = start_dn_list;
        while (dn_list != null) {
            DictNode xdn = dn_list.right;
            dn_list.right = null;
            dn_list.left = null;
            dn_list.string = this.build_idiom_word_name(dn_list.string);
            this.root = this.insert_dict(this.root, dn_list);
            ++this.num_entries;
            dn_list = xdn;
        }
    }

    DictNode read_word_file(DictNode dn, String filename) throws IOException {
        String s2;
        String file_name_copy;
        if (filename.startsWith("/words/")) {
            int len = this.name.lastIndexOf("/");
            file_name_copy = this.name.substring(0, len) + filename;
        } else {
            file_name_copy = filename.substring(1);
        }
        Reader fp = Dictionary.dictopen(this.opts, this.name, file_name_copy);
        if (fp == null) {
            throw new RuntimeException("Error opening word file " + file_name_copy);
        }
        WordFile wf = new WordFile();
        wf.file = file_name_copy.toString();
        wf.changed = false;
        wf.next = this.word_file_header;
        this.word_file_header = wf;
        while ((s2 = this.get_a_word(fp)) != null) {
            DictNode dn_new = new DictNode();
            dn_new.left = dn;
            dn = dn_new;
            dn.string = s2;
            dn.file = wf;
        }
        fp.close();
        return dn;
    }

    String get_a_word(Reader fp) throws IOException {
        int c;
        StringBuffer word = new StringBuffer();
        while ((c = fp.read()) >= 0 && Character.isWhitespace((char)c)) {
        }
        if (c < 0) {
            return null;
        }
        int j = 0;
        while (c >= 0 && !Character.isWhitespace((char)c)) {
            word.append((char)c);
            c = fp.read();
            ++j;
        }
        return word.toString();
    }

    static Reader dictopen(ParseOptions opts, String dictname, String filename) throws IOException {
        int pos;
        if (Env.WINDOWSOS) {
            if (filename.charAt(0) == '\\') {
                return new FileReader(filename);
            }
            if (Character.isLetter(filename.charAt(0)) && filename.charAt(1) == ':') {
                return new FileReader(filename);
            }
        }
        if (filename.charAt(0) == '/') {
            return new FileReader(filename);
        }
        File absFile = new File(filename);
        String absFileName = absFile.getAbsolutePath();
        if (absFile.exists()) {
            return new FileReader(absFileName);
        }
        String dp1 = "";
        if (dictname != null) {
            String dummy1 = dictname;
            dp1 = new File(dictname).getParent().toString();
            dp1 = new File(dp1).getAbsolutePath().toString();
        }
        String dp2 = "";
        String fulldictpath = dp1 + ":" + dp2 + ".:./data:./data/link:/home/liferay/linkgrammar:/home/liferay/linkgrammar/data:/home/liferay/linkgrammar/data/link";
        int oldpos = 0;
        while ((pos = fulldictpath.indexOf(58, oldpos)) >= 0) {
            String completename = fulldictpath.substring(oldpos, pos) + "/" + filename;
            File f = new File(completename);
            completename = f.getCanonicalPath();
            if (f.exists()) {
                if (opts.verbosity > 2) {
                    opts.out.println("   Opening " + completename);
                }
                return new FileReader(f);
            }
            oldpos = pos + 1;
        }
        return null;
    }

    String generate_id_connector() {
        int i;
        for (i = 0; i < current_name.length() - 1 && current_name.charAt(i) == 'A'; ++i) {
        }
        StringBuffer s2 = new StringBuffer("ID");
        s2.append(current_name.substring(i));
        return s2.toString();
    }

    String build_idiom_word_name(String s2) {
        int count = this.max_postfix_found(this.dictionary_lookup(s2)) + 1;
        int x = s2.indexOf(46);
        StringBuffer newString = x >= 0 ? new StringBuffer(s2.substring(0, x)) : new StringBuffer(s2);
        newString.append(".I");
        newString.append(count);
        return newString.toString();
    }

    int max_postfix_found(DictNode d) {
        int i = 0;
        while (d != null) {
            int j = Dictionary.numberfy(d.string);
            if (j > i) {
                i = j;
            }
            d = d.right;
        }
        return i;
    }

    DictNode make_idiom_DictNodes(String string) {
        DictNode dn = null;
        StringTokenizer tok = new StringTokenizer(string, "_");
        while (tok.hasMoreTokens()) {
            String word = tok.nextToken();
            DictNode dn_new = new DictNode();
            dn_new.right = dn;
            dn = dn_new;
            dn.string = word;
            dn.file = null;
        }
        return dn;
    }

    void increment_current_name() {
        int i = CN_size - 1;
        boolean carry = true;
        while (carry) {
            char cc = current_name.charAt(i);
            if (cc == 'Z') {
                current_name.setCharAt(i, 'A');
                carry = true;
            } else {
                current_name.setCharAt(i, (char)('\u0001' + cc));
                carry = false;
            }
            --i;
        }
    }
}

