/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import net.sf.jlinkgrammar.Clause;
import net.sf.jlinkgrammar.Connector;
import net.sf.jlinkgrammar.Disjunct;
import net.sf.jlinkgrammar.Exp;
import net.sf.jlinkgrammar.WordFile;

public class DictNode {
    String string;
    WordFile file;
    Exp exp;
    DictNode left;
    DictNode right;

    DictNode() {
    }

    DictNode(DictNode d) {
        this.string = d.string;
        this.file = d.file;
        this.exp = d.exp;
        this.left = d.left;
        this.right = d.right;
    }

    Disjunct build_disjuncts_for_dict_node() {
        Clause c = this.exp.build_Clause(1000);
        Disjunct dis = Clause.build_disjunct(c, this.string, 1000);
        return dis;
    }

    static DictNode list_whole_dictionary(DictNode root, DictNode dn) {
        if (root == null) {
            return dn;
        }
        DictNode c = new DictNode(root);
        DictNode d = DictNode.list_whole_dictionary(root.left, dn);
        c.right = DictNode.list_whole_dictionary(root.right, d);
        return c;
    }

    boolean word_has_connector(String cs, int direction) {
        Connector c2 = null;
        Disjunct d = this.build_disjuncts_for_dict_node();
        if (d == null) {
            return false;
        }
        while (d != null) {
            if (direction == 0) {
                c2 = d.right;
            }
            if (direction == 1) {
                c2 = d.left;
            }
            while (c2 != null) {
                if (DictNode.easy_match(c2.string, cs)) {
                    return true;
                }
                c2 = c2.next;
            }
            d = d.next;
        }
        return false;
    }

    static boolean easy_match(String s2, String t) {
        int i;
        for (i = 0; i < s2.length() && i < t.length() && (Character.isUpperCase(s2.charAt(i)) || Character.isUpperCase(t.charAt(i))); ++i) {
            if (s2.charAt(i) == t.charAt(i)) continue;
            return false;
        }
        while (i < s2.length() && i < t.length()) {
            if (s2.charAt(i) == '*' || t.charAt(i) == '*' || s2.charAt(i) == t.charAt(i) && s2.charAt(i) != '^') {
                ++i;
                continue;
            }
            return false;
        }
        return true;
    }
}

