/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jlinkgrammar;

import net.sf.jlinkgrammar.ConnectorSet;
import net.sf.jlinkgrammar.MyRandom;
import net.sf.jlinkgrammar.Sentence;

public class Connector {
    int label;
    int word;
    int length_limit;
    int priority;
    boolean multi;
    Connector next;
    String string;

    Connector(Connector c) {
        this.label = c.label;
        this.word = c.word;
        this.length_limit = c.length_limit;
        this.priority = c.priority;
        this.multi = c.multi;
        this.next = c.next;
        this.string = c.string;
    }

    Connector() {
    }

    Connector init_connector() {
        this.length_limit = 255;
        return this;
    }

    static Connector reverse(Connector e) {
        Connector head = null;
        while (e != null) {
            Connector x = e.next;
            e.next = head;
            head = e;
            e = x;
        }
        return head;
    }

    boolean connectors_equal_prune(Connector c2) {
        return this.label == c2.label && this.multi == c2.multi && this.priority == c2.priority && this.string.equals(c2.string);
    }

    boolean connector_types_equal(Connector c2) {
        if (this.label != c2.label) {
            return false;
        }
        String s2 = this.string;
        String t = c2.string;
        for (int i = 0; i < s2.length() && i < t.length() && (Character.isUpperCase(s2.charAt(i)) || Character.isUpperCase(t.charAt(i))); ++i) {
            if (s2.charAt(i) == t.charAt(i)) continue;
            return false;
        }
        return true;
    }

    boolean connectors_equal_AND(Connector c2) {
        return this.label == c2.label && this.multi == c2.multi && this.string.equals(c2.string);
    }

    boolean match_in_connector_set(Sentence sent, ConnectorSet conset, int d) {
        if (conset == null) {
            return false;
        }
        int h2 = conset.connector_set_hash(this.string, d);
        Connector c1 = conset.hash_table[h2];
        while (c1 != null) {
            if (Connector.x_match(sent, c1, this) && d == c1.word) {
                return true;
            }
            c1 = c1.next;
        }
        return false;
    }

    int and_connector_hash(int i) {
        String s2 = this.string;
        i = i + (i << 1) + MyRandom.randtable[this.label + i & 0xFF];
        for (int j = 0; j < s2.length() && Character.isUpperCase(s2.charAt(j)); ++j) {
            i = i + (i << 1) + MyRandom.randtable[s2.charAt(j) + i & 0xFF];
        }
        return i & 0x3FF;
    }

    static boolean x_match(Sentence sent, Connector a, Connector b) {
        return Connector.match(sent, a, b, 0, 0);
    }

    static boolean match(Sentence sent, Connector a, Connector b, int aw, int bw) {
        int dist;
        int i;
        if (a.label != b.label) {
            return false;
        }
        int x = a.priority;
        int y = b.priority;
        String s2 = a.string;
        String t = b.string;
        for (i = 0; i < s2.length() && i < t.length() && (Character.isUpperCase(s2.charAt(i)) || Character.isUpperCase(t.charAt(i))); ++i) {
            if (s2.charAt(i) == t.charAt(i)) continue;
            return false;
        }
        if (i < s2.length() && Character.isUpperCase(s2.charAt(i)) || i < t.length() && Character.isUpperCase(t.charAt(i))) {
            return false;
        }
        if (aw == 0 && bw == 0) {
            dist = 0;
        } else {
            if (aw >= bw) {
                throw new RuntimeException("match() did not receive params in the natural order.");
            }
            dist = sent.effective_dist[aw][bw];
        }
        if (dist > a.length_limit || dist > b.length_limit) {
            return false;
        }
        if (x == 0 && y == 0) {
            while (i < s2.length() && i < t.length()) {
                if (s2.charAt(i) == '*' || t.charAt(i) == '*' || s2.charAt(i) == t.charAt(i) && s2.charAt(i) != '^') {
                    ++i;
                    continue;
                }
                return false;
            }
            return true;
        }
        if (x == 1 && y == 2) {
            while (i < s2.length() && i < t.length()) {
                if (s2.charAt(i) == t.charAt(i) || s2.charAt(i) == '*' || t.charAt(i) == '^') {
                    ++i;
                    continue;
                }
                return false;
            }
            return true;
        }
        if (y == 1 && x == 2) {
            while (i < s2.length() && i < t.length()) {
                if (s2.charAt(i) == t.charAt(i) || t.charAt(i) == '*' || s2.charAt(i) == '^') {
                    ++i;
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean x_prune_match(Sentence sent, Connector a, Connector b) {
        return Connector.prune_match(sent, a, b, 0, 0);
    }

    static boolean prune_match(Sentence sent, Connector a, Connector b, int aw, int bw) {
        int dist;
        int i;
        if (a.label != b.label) {
            return false;
        }
        int x = a.priority;
        int y = b.priority;
        String s2 = a.string;
        String t = b.string;
        for (i = 0; i < s2.length() && i < t.length() && (Character.isUpperCase(s2.charAt(i)) || Character.isUpperCase(t.charAt(i))); ++i) {
            if (s2.charAt(i) == t.charAt(i)) continue;
            return false;
        }
        if (i < s2.length() && Character.isUpperCase(s2.charAt(i)) || i < t.length() && Character.isUpperCase(t.charAt(i))) {
            return false;
        }
        if (aw == 0 && bw == 0) {
            dist = 0;
        } else {
            if (aw >= bw) {
                throw new RuntimeException("prune_match() did not receive params in the natural order.");
            }
            dist = sent.effective_dist[aw][bw];
        }
        if (dist > a.length_limit || dist > b.length_limit) {
            return false;
        }
        if (x == 0 && y == 0) {
            if (!(i >= s2.length() || i >= t.length() || a.string.charAt(0) != 'S' || s2.charAt(i) != 's' && s2.charAt(i) != 'p' || t.charAt(i) != 'p' && t.charAt(i) != 's' || i != 1 && (i != 2 || s2.charAt(i - 1) != 'I'))) {
                return true;
            }
            while (i < s2.length() && i < t.length()) {
                if (s2.charAt(i) == '*' || t.charAt(i) == '*' || s2.charAt(i) == t.charAt(i) && s2.charAt(i) != '^') {
                    ++i;
                    continue;
                }
                return false;
            }
            return true;
        }
        if (x == 1 && y == 2) {
            while (i < s2.length() && i < t.length()) {
                if (s2.charAt(i) == t.charAt(i) || s2.charAt(i) == '*' || t.charAt(i) == '^') {
                    ++i;
                    continue;
                }
                return false;
            }
            return true;
        }
        if (y == 1 && x == 2) {
            while (i < s2.length() && i < t.length()) {
                if (s2.charAt(i) == t.charAt(i) || t.charAt(i) == '*' || s2.charAt(i) == '^') {
                    ++i;
                    continue;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    static Connector copy_connectors(Connector c) {
        if (c == null) {
            return null;
        }
        Connector c1 = new Connector(c);
        c1.next = Connector.copy_connectors(c.next);
        return c1;
    }
}

