/*
 * Decompiled with CFR 0.152.
 */
package net.didion.jwnl.dictionary.database;

import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.dictionary.database.ConnectionManager;
import net.didion.jwnl.dictionary.database.DatabaseManager;
import net.didion.jwnl.dictionary.database.Query;
import net.didion.jwnl.util.factory.Createable;
import net.didion.jwnl.util.factory.Param;

public class DatabaseManagerImpl
implements DatabaseManager,
Createable {
    public static final String DRIVER = "driver";
    public static final String URL = "url";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String JNDI = "jndi";
    protected static final String LEMMA_FOR_INDEX_WORD_ID_SQL = "SELECT iw.lemma FROM IndexWord iw WHERE iw.pos = ? AND iw.index_word_id = ?";
    protected static final String SYNSET_IDS_FOR_INDEX_WORD_SQL = "SELECT syn.file_offset, iws.synset_id, syn.synset_id FROM IndexWordSynset iws, IndexWord iw, Synset syn WHERE iws.index_word_id = iw.index_word_id AND syn.synset_id = iws.synset_id AND iw.pos = ?  AND iw.lemma = ?";
    protected static final String COUNT_INDEX_WORDS_SQL = "SELECT MIN(index_word_id), MAX(index_word_id) FROM indexword WHERE pos = ?";
    protected static final String ALL_LEMMAS_SQL = "SELECT lemma FROM IndexWord WHERE pos = ?";
    protected static final String ALL_LEMMAS_LIKE_SQL = "SELECT lemma FROM IndexWord WHERE pos = ? AND lemma LIKE ?";
    protected static final String SYNSET_SQL = "SELECT is_adj_cluster, gloss FROM Synset WHERE pos = ? AND file_offset = ?";
    protected static final String SYNSET_WORD_SQL = "SELECT sw.word, sw.word_index FROM Synset s, SynsetWord sw WHERE s.synset_id = sw.synset_id AND s.pos = ? AND s.file_offset = ?";
    protected static final String SYNSET_POINTER_SQL = "SELECT sp.pointer_type, sp.target_offset, sp.target_pos, sp.source_index, sp.target_index FROM Synset s, SynsetPointer sp WHERE s.synset_id = sp.synset_id AND s.pos = ? AND s.file_offset = ?";
    protected static final String SYNSET_VERB_FRAME_SQL = "SELECT svf.frame_number, svf.word_index FROM Synset s, SynsetVerbFrame svf WHERE s.synset_id = svf.synset_id AND s.pos = ? AND s.file_offset = ?";
    protected static final String ALL_SYNSETS_SQL = "SELECT offset FROM Synset WHERE pos = ?";
    protected static final String EXCEPTION_SQL = "SELECT exception FROM Exception WHERE pos = ? AND lemma = ?";
    protected static final String ALL_EXCEPTIONS_SQL = "SELECT lemma FROM Exception WHERE pos = ?";
    protected static final Random _rand = new Random(new Date().getTime());
    protected ConnectionManager _connectionManager;
    protected Map _minMaxIds = new HashMap();

    public DatabaseManagerImpl() {
    }

    public DatabaseManagerImpl(ConnectionManager connectionManager) {
        this._connectionManager = connectionManager;
    }

    @Override
    public Object create(Map params) throws JWNLException {
        String jndi;
        String driverClassName = params.containsKey(DRIVER) ? ((Param)params.get(DRIVER)).getValue() : null;
        String url = params.containsKey(URL) ? ((Param)params.get(URL)).getValue() : null;
        String userName = params.containsKey(USERNAME) ? ((Param)params.get(USERNAME)).getValue() : null;
        String password = params.containsKey(PASSWORD) ? ((Param)params.get(PASSWORD)).getValue() : null;
        String string = jndi = params.containsKey(JNDI) ? ((Param)params.get(JNDI)).getValue() : null;
        if (null != jndi && jndi.trim().length() > 0) {
            return new DatabaseManagerImpl(new ConnectionManager(jndi.trim()));
        }
        return new DatabaseManagerImpl(new ConnectionManager(driverClassName, url, userName, password));
    }

    @Override
    public Query getIndexWordSynsetsQuery(POS pos, String lemma) throws JWNLException {
        return this.createPOSStringQuery(pos, lemma, SYNSET_IDS_FOR_INDEX_WORD_SQL);
    }

    @Override
    public Query getIndexWordLemmasQuery(POS pos) throws JWNLException {
        return this.createPOSQuery(pos, ALL_LEMMAS_SQL);
    }

    @Override
    public Query getIndexWordLemmasQuery(POS pos, String substring) throws JWNLException {
        return this.createPOSStringQuery(pos, "%" + substring + "%", ALL_LEMMAS_LIKE_SQL);
    }

    @Override
    public Query getRandomIndexWordQuery(POS pos) throws JWNLException {
        MinMax minMax = (MinMax)this._minMaxIds.get(pos);
        if (minMax == null) {
            Query query = this.createPOSQuery(pos, COUNT_INDEX_WORDS_SQL);
            try {
                query.execute();
                query.getResults().next();
                minMax = new MinMax(query.getResults().getInt(1), query.getResults().getInt(2));
                this._minMaxIds.put(pos, minMax);
            }
            catch (SQLException ex) {
                throw new JWNLException("DICTIONARY_EXCEPTION_023", ex);
            }
            finally {
                if (query != null) {
                    query.close();
                }
            }
        }
        int id = minMax.getMin() + _rand.nextInt(minMax.getMax() - minMax.getMin());
        return this.createPOSIdQuery(pos, id, LEMMA_FOR_INDEX_WORD_ID_SQL);
    }

    @Override
    public Query getSynsetQuery(POS pos, long offset) throws JWNLException {
        return this.createPOSOffsetQuery(pos, offset, SYNSET_SQL);
    }

    @Override
    public Query getSynsetWordQuery(POS pos, long offset) throws JWNLException {
        return this.createPOSOffsetQuery(pos, offset, SYNSET_WORD_SQL);
    }

    @Override
    public Query getPointerQuery(POS pos, long offset) throws JWNLException {
        return this.createPOSOffsetQuery(pos, offset, SYNSET_POINTER_SQL);
    }

    @Override
    public Query getVerbFrameQuery(POS pos, long offset) throws JWNLException {
        return this.createPOSOffsetQuery(pos, offset, SYNSET_VERB_FRAME_SQL);
    }

    @Override
    public Query getSynsetsQuery(POS pos) throws JWNLException {
        return this.createPOSQuery(pos, ALL_SYNSETS_SQL);
    }

    @Override
    public Query getExceptionQuery(POS pos, String derivation) throws JWNLException {
        return this.createPOSStringQuery(pos, derivation, EXCEPTION_SQL);
    }

    @Override
    public Query getExceptionsQuery(POS pos) throws JWNLException {
        return this.createPOSQuery(pos, ALL_EXCEPTIONS_SQL);
    }

    protected Query createPOSQuery(POS pos, String sql) throws JWNLException {
        Query query = null;
        try {
            query = this._connectionManager.getQuery(sql);
            query.getStatement().setString(1, pos.getKey());
            return query;
        }
        catch (SQLException ex) {
            if (query != null) {
                query.close();
            }
            throw new JWNLException("DICTIONARY_EXCEPTION_023", ex);
        }
    }

    protected Query createPOSStringQuery(POS pos, String str, String sql) throws JWNLException {
        Query query = null;
        try {
            query = this._connectionManager.getQuery(sql);
            query.getStatement().setString(1, pos.getKey());
            query.getStatement().setString(2, str);
            return query;
        }
        catch (SQLException ex) {
            if (query != null) {
                query.close();
            }
            throw new JWNLException("DICTIONARY_EXCEPTION_023", ex);
        }
    }

    protected Query createPOSOffsetQuery(POS pos, long offset, String sql) throws JWNLException {
        Query query = null;
        try {
            query = this._connectionManager.getQuery(sql);
            query.getStatement().setString(1, pos.getKey());
            query.getStatement().setLong(2, offset);
            return query;
        }
        catch (SQLException ex) {
            if (query != null) {
                query.close();
            }
            throw new JWNLException("DICTIONARY_EXCEPTION_023", ex);
        }
    }

    protected Query createPOSIdQuery(POS pos, int id, String sql) throws JWNLException {
        Query query = null;
        try {
            query = this._connectionManager.getQuery(sql);
            query.getStatement().setString(1, pos.getKey());
            query.getStatement().setInt(2, id);
            return query;
        }
        catch (SQLException ex) {
            if (query != null) {
                query.close();
            }
            throw new JWNLException("DICTIONARY_EXCEPTION_023", ex);
        }
    }

    private class MinMax {
        private int _min;
        private int _max;

        public MinMax(int min2, int max) {
            this._min = min2;
            this._max = max;
        }

        public int getMin() {
            return this._min;
        }

        public int getMax() {
            return this._max;
        }
    }
}

