/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdenver.ccp.nlp.biolemmatizer;

import edu.northwestern.at.utils.corpuslinguistics.lexicon.DefaultWordLexicon;
import edu.ucdenver.ccp.nlp.biolemmatizer.BioLemmatizer;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class POSEntry {
    public Map<String, String> tagToTagSet = new HashMap<String, String>();

    public POSEntry() {
        Map<String, String[]> mappingPennPOStoNUPOS;
        DefaultWordLexicon wordLexicon;
        try {
            wordLexicon = new DefaultWordLexicon();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.addNewTagSet(Arrays.asList(wordLexicon.getCategories()), "NUPOS");
        String mappingFileName = "PennPOStoNUPOS.mapping";
        InputStream is = BioLemmatizer.class.getResourceAsStream(mappingFileName);
        try {
            mappingPennPOStoNUPOS = BioLemmatizer.loadPOSMappingFile(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Error while opening mapping file: " + mappingFileName, e);
        }
        this.addNewTagSet(mappingPennPOStoNUPOS.keySet(), "PennPOS");
    }

    public void addNewTagSet(Collection<String> tags, String tagSetLabel) {
        for (String tag : tags) {
            this.tagToTagSet.put(tag, tagSetLabel);
        }
    }

    public String getTagSetLabel(String category) {
        String defaultLabel = "NONE";
        return this.tagToTagSet.containsKey(category) ? this.tagToTagSet.get(category) : defaultLabel;
    }
}

