/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdenver.ccp.nlp.biolemmatizer;

import edu.ucdenver.ccp.nlp.biolemmatizer.POSEntry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;

public class LemmataEntry {
    public Map<String, String> lemmasAndCategories;
    public static String lemmaSeparator = "||";
    private final POSEntry posEntry;

    public LemmataEntry(Map<String, String> lemmasAndCategories, POSEntry posEntry) {
        this.lemmasAndCategories = lemmasAndCategories;
        this.posEntry = posEntry;
    }

    public String toString() {
        String lemmas = "*";
        if (!this.lemmasAndCategories.isEmpty()) {
            lemmas = "";
            int i = 0;
            for (String key : this.lemmasAndCategories.keySet()) {
                String lemma = this.lemmasAndCategories.get(key) + " " + key + " " + this.posEntry.getTagSetLabel(key);
                lemmas = lemmas + lemma;
                if (i < this.lemmasAndCategories.keySet().size() - 1) {
                    lemmas = lemmas + lemmaSeparator;
                }
                ++i;
            }
        }
        return lemmas;
    }

    public String lemmasToString() {
        String lemmas = "*";
        if (!this.lemmasAndCategories.isEmpty()) {
            lemmas = "";
            int i = 0;
            HashSet<String> checkSet = new HashSet<String>();
            for (String key : this.lemmasAndCategories.keySet()) {
                String lemma = this.lemmasAndCategories.get(key);
                if (checkSet.contains(lemma)) continue;
                checkSet.add(lemma);
            }
            for (String setItem : checkSet) {
                lemmas = lemmas + setItem;
                if (i < checkSet.size() - 1) {
                    lemmas = lemmas + lemmaSeparator;
                }
                ++i;
            }
        }
        return lemmas;
    }

    public Collection<Lemma> getLemmas() {
        HashSet<Lemma> lemmas = new HashSet<Lemma>();
        for (Map.Entry<String, String> entry : this.lemmasAndCategories.entrySet()) {
            String posTag = entry.getKey();
            String lemma = entry.getValue();
            String tagSetName = this.posEntry.getTagSetLabel(posTag);
            lemmas.add(new Lemma(lemma, posTag, tagSetName));
        }
        return lemmas;
    }

    public static class Lemma {
        private final String lemma;
        private final String pos;
        private final String tagSetName;

        public Lemma(String lemma, String pos, String tagSetName) {
            this.lemma = lemma;
            this.pos = pos;
            this.tagSetName = tagSetName;
        }

        public String getLemma() {
            return this.lemma;
        }

        public String getPos() {
            return this.pos;
        }

        public String getTagSetName() {
            return this.tagSetName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.lemma == null ? 0 : this.lemma.hashCode());
            result = 31 * result + (this.pos == null ? 0 : this.pos.hashCode());
            result = 31 * result + (this.tagSetName == null ? 0 : this.tagSetName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Lemma other = (Lemma)obj;
            if (this.lemma == null ? other.lemma != null : !this.lemma.equals(other.lemma)) {
                return false;
            }
            if (this.pos == null ? other.pos != null : !this.pos.equals(other.pos)) {
                return false;
            }
            return !(this.tagSetName == null ? other.tagSetName != null : !this.tagSetName.equals(other.tagSetName));
        }
    }
}

