/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdenver.ccp.nlp.biolemmatizer;

import java.io.File;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.Option;

public class BioLemmatizerCmdOpts {
    @Option(name="-f", usage="optional path to a lexicon file. If not set, the default lexicon available on the classpath is used", required=false)
    private String lexiconFilePath;
    @Option(name="-i", usage="the path to the input file", required=false)
    private String inputFilePath;
    @Option(name="-o", usage="the path to the output file", required=false)
    private String outputFilePath;
    @Option(name="-a", usage="if present, normalize common British spellings into American spellings and retrieve lemmas", required=false)
    private boolean americanize = false;
    @Option(name="-l", usage="if present, only the lemma is returned (part-of-speech information is suppressed)", required=false)
    private boolean outputLemmaOnly = false;
    @Option(name="-t", usage="if present, the interactive mode is used")
    private boolean useInteractiveMode = false;
    @Argument(index=0, usage="Single input to be lemmatized", required=false)
    private String inputStr;
    @Argument(index=1, usage="Part of speech of the single input to be lemmatized", required=false)
    private String inputStrPos;

    public File getInputFile() {
        return this.inputFilePath != null ? new File(this.inputFilePath) : null;
    }

    public File getOutputFile() {
        return this.outputFilePath != null ? new File(this.outputFilePath) : null;
    }

    public File getLexiconFile() {
        return this.lexiconFilePath != null ? new File(this.lexiconFilePath) : null;
    }

    public boolean americanizedLemma() {
        return this.americanize;
    }

    public boolean outputLemmaOnly() {
        return this.outputLemmaOnly;
    }

    public boolean useInteractiveMode() {
        return this.useInteractiveMode;
    }

    public String getInputStr() {
        return this.inputStr;
    }

    public String getInputStrPos() {
        return this.inputStrPos;
    }
}

