/*
 * Decompiled with CFR 0.152.
 */
package edu.ucdenver.ccp.nlp.biolemmatizer;

import edu.northwestern.at.utils.corpuslinguistics.lemmatizer.Lemmatizer;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.Lexicon;
import edu.northwestern.at.utils.corpuslinguistics.lexicon.LexiconEntry;
import edu.northwestern.at.utils.corpuslinguistics.partsofspeech.PartOfSpeechTags;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.PennTreebankTokenizer;
import edu.northwestern.at.utils.corpuslinguistics.tokenizer.WordTokenizer;
import edu.ucdenver.ccp.nlp.biolemmatizer.Americanize;
import edu.ucdenver.ccp.nlp.biolemmatizer.BioLemmatizerCmdOpts;
import edu.ucdenver.ccp.nlp.biolemmatizer.BioWordLexicon;
import edu.ucdenver.ccp.nlp.biolemmatizer.LemmataEntry;
import edu.ucdenver.ccp.nlp.biolemmatizer.MorphAdornerLemmatizer;
import edu.ucdenver.ccp.nlp.biolemmatizer.POSEntry;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;

public class BioLemmatizer {
    public static String lemmaSeparator = "||";
    public Lemmatizer lemmatizer;
    public Lexicon wordLexicon;
    public PartOfSpeechTags partOfSpeechTags;
    public WordTokenizer spellingTokenizer;
    public Map<String, String[]> mappingPennPOStoNUPOS;
    public Map<String, String[]> mappingMajorClasstoPennPOS;
    protected static String mappingFileName;
    public POSEntry posEntry;

    public BioLemmatizer() {
        this(null);
    }

    public BioLemmatizer(File lexiconFile) {
        try {
            this.lemmatizer = new MorphAdornerLemmatizer();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            this.wordLexicon = new BioWordLexicon(lexiconFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.partOfSpeechTags = this.wordLexicon.getPartOfSpeechTags();
        this.spellingTokenizer = new PennTreebankTokenizer();
        this.lemmatizer.setLexicon(this.wordLexicon);
        this.lemmatizer.setDictionary(this.setDictionary(this.wordLexicon));
        mappingFileName = "PennPOStoNUPOS.mapping";
        InputStream is = BioLemmatizer.class.getResourceAsStream(mappingFileName);
        try {
            this.mappingPennPOStoNUPOS = BioLemmatizer.loadPOSMappingFile(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load mapping: " + mappingFileName, e);
        }
        mappingFileName = "MajorClasstoPennPOS.mapping";
        is = BioLemmatizer.class.getResourceAsStream(mappingFileName);
        try {
            this.mappingMajorClasstoPennPOS = BioLemmatizer.loadPOSMappingFile(is);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to load mapping: " + mappingFileName, e);
        }
        this.posEntry = new POSEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String[]> loadPOSMappingFile(InputStream is) throws IOException {
        HashMap<String, String[]> mapping = new HashMap<String, String[]>();
        try {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader input = new BufferedReader(isr);
            String line = null;
            while ((line = input.readLine()) != null) {
                line = line.trim();
                String[] pair = line.split("\t");
                String[] mappingSet = pair[1].split(",");
                mapping.put(pair[0], mappingSet);
                mapping.put(pair[0].replaceAll("^\\uFEFF", ""), mappingSet);
            }
            input.close();
            isr.close();
        }
        finally {
            is.close();
        }
        return mapping;
    }

    private Set<String> setDictionary(Lexicon wordLexicon) {
        String[] lexiconEntries;
        HashSet<String> dictionarySet = new HashSet<String>();
        for (String entry : lexiconEntries = wordLexicon.getEntries()) {
            String[] lemmata;
            for (String lemma : lemmata = wordLexicon.getLemmata(entry)) {
                dictionarySet.add(lemma.toLowerCase());
            }
        }
        return dictionarySet;
    }

    private String[] getNUPOSTagFromPennPOS(String partOfSpeech) {
        String[] stringArray;
        String[] nuPOSTag = this.mappingPennPOStoNUPOS.get(partOfSpeech.toUpperCase());
        if (nuPOSTag != null) {
            stringArray = nuPOSTag;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = partOfSpeech;
        }
        return stringArray;
    }

    private String[] getPennPOSFromNUPOS(String partOfSpeech) {
        String[] stringArray;
        ArrayList<String> result = new ArrayList<String>();
        block0: for (String key : this.mappingPennPOStoNUPOS.keySet()) {
            for (String value : this.mappingPennPOStoNUPOS.get(key)) {
                if (!value.equals(partOfSpeech)) continue;
                result.add(key);
                continue block0;
            }
        }
        if (result.size() != 0) {
            stringArray = result.toArray(new String[result.size()]);
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = partOfSpeech;
        }
        return stringArray;
    }

    private String[] getSiblingPennPOSTag(String partOfSpeech) {
        boolean globalFlag = false;
        for (String key : this.mappingMajorClasstoPennPOS.keySet()) {
            String[] posTag;
            for (String pos : posTag = this.mappingMajorClasstoPennPOS.get(key)) {
                if (!pos.equals(partOfSpeech)) continue;
                globalFlag = true;
                break;
            }
            if (!globalFlag) continue;
            break;
        }
        if (globalFlag) {
            String foundKey = "";
            for (String key : this.mappingMajorClasstoPennPOS.keySet()) {
                String[] posTag = this.mappingMajorClasstoPennPOS.get(key);
                boolean localFlag = false;
                for (String pos : posTag) {
                    if (!pos.equals(partOfSpeech)) continue;
                    foundKey = key;
                    localFlag = true;
                    break;
                }
                if (!localFlag) continue;
                break;
            }
            ArrayList<String> merge = new ArrayList<String>();
            for (String pos : this.mappingMajorClasstoPennPOS.get(foundKey)) {
                if (pos.equals(partOfSpeech)) continue;
                merge.add(pos);
            }
            return merge.toArray(new String[merge.size()]);
        }
        return new String[]{partOfSpeech};
    }

    private String[] getSiblingNUPOSTag(String partOfSpeech) {
        boolean globalFlag = false;
        for (String key : this.mappingMajorClasstoPennPOS.keySet()) {
            String[] posTag;
            for (String pos : posTag = this.mappingMajorClasstoPennPOS.get(key)) {
                if (!pos.equals(partOfSpeech)) continue;
                globalFlag = true;
                break;
            }
            if (!globalFlag) continue;
            break;
        }
        if (globalFlag) {
            String foundKey = "";
            for (String key : this.mappingMajorClasstoPennPOS.keySet()) {
                String[] posTag = this.mappingMajorClasstoPennPOS.get(key);
                boolean localFlag = false;
                for (String pos : posTag) {
                    if (!pos.equals(partOfSpeech)) continue;
                    foundKey = key;
                    localFlag = true;
                    break;
                }
                if (!localFlag) continue;
                break;
            }
            ArrayList<Object> merge = new ArrayList<Object>();
            for (String pos : this.mappingMajorClasstoPennPOS.get(foundKey)) {
                if (pos.equals(partOfSpeech)) continue;
                merge.addAll(Arrays.asList((Object[])this.mappingPennPOStoNUPOS.get(pos.toUpperCase())));
            }
            return merge.toArray(new String[merge.size()]);
        }
        return new String[]{partOfSpeech};
    }

    private Map<String, String> getLemmasAndCategories(String spelling) {
        Map<String, String> lemmasAndCategories = new HashMap<String, String>();
        LexiconEntry lexiconEntry = this.wordLexicon.getLexiconEntry(spelling);
        if (lexiconEntry != null) {
            lemmasAndCategories = lexiconEntry.lemmata;
        }
        return lemmasAndCategories;
    }

    private static String cleanUpLemma(String lemma) {
        String newLemma = lemma;
        String lastChar = lemma.substring(lemma.length() - 1);
        if (lastChar.equals("'")) {
            newLemma = lemma.substring(0, lemma.length() - 1);
        }
        return newLemma;
    }

    static String unicodeHandler(String input) {
        HashMap<String, String> specialUnicodeCharToModernEnglishMapping = new HashMap<String, String>();
        specialUnicodeCharToModernEnglishMapping.put("u00E6", "ae");
        specialUnicodeCharToModernEnglishMapping.put("u0153", "oe");
        specialUnicodeCharToModernEnglishMapping.put("u00E4", "a");
        specialUnicodeCharToModernEnglishMapping.put("u00E0", "a");
        specialUnicodeCharToModernEnglishMapping.put("u00E1", "a");
        specialUnicodeCharToModernEnglishMapping.put("u0113", "e");
        specialUnicodeCharToModernEnglishMapping.put("u00E9", "e");
        specialUnicodeCharToModernEnglishMapping.put("u00E8", "e");
        specialUnicodeCharToModernEnglishMapping.put("u00EB", "e");
        specialUnicodeCharToModernEnglishMapping.put("u00EF", "i");
        specialUnicodeCharToModernEnglishMapping.put("u00F1", "n");
        specialUnicodeCharToModernEnglishMapping.put("u014D", "o");
        specialUnicodeCharToModernEnglishMapping.put("u00F6", "o");
        specialUnicodeCharToModernEnglishMapping.put("u00F4", "o");
        specialUnicodeCharToModernEnglishMapping.put("u016B", "u");
        specialUnicodeCharToModernEnglishMapping.put("u00FA", "u");
        String output = input;
        for (String unicode : specialUnicodeCharToModernEnglishMapping.keySet()) {
            String regex = "\\" + unicode;
            output = output.replaceAll(regex, (String)specialUnicodeCharToModernEnglishMapping.get(unicode));
        }
        return output;
    }

    public LemmataEntry lemmatizeByLexicon(String spelling, String partOfSpeech) {
        String[] hierarachicalNUPOSTag;
        Map<Object, Object> lemmataAndLemmataTag = new HashMap();
        String lemmata = spelling;
        if (partOfSpeech == null) {
            partOfSpeech = "";
        }
        String lemmataTag = partOfSpeech.trim().length() == 0 ? "NONE" : partOfSpeech;
        String tagSetLabel = this.posEntry.getTagSetLabel(partOfSpeech);
        String[] nuPOSTag = this.getNUPOSTagFromPennPOS(partOfSpeech);
        String lemma = "*";
        String category = "*";
        if (tagSetLabel.equals("PennPOS")) {
            lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), partOfSpeech);
            if (lemma.equals("*")) {
                lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), partOfSpeech);
            }
            if (!lemma.equals("*")) {
                lemmata = lemma;
                category = partOfSpeech;
            }
            if (lemma.equals("*")) {
                String[] hierarachicalPennPOSTag;
                for (String pos : hierarachicalPennPOSTag = this.getSiblingPennPOSTag(partOfSpeech)) {
                    lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), pos);
                    if (lemma.equals("*")) {
                        lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), pos);
                    }
                    if (lemma.equals("*")) continue;
                    lemmata = lemma;
                    category = pos;
                    break;
                }
            }
            if (lemma.equals("*")) {
                for (String pos : nuPOSTag) {
                    lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), pos);
                    if (lemma.equals("*")) {
                        lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), pos);
                    }
                    if (lemma.equals("*")) continue;
                    lemmata = lemma;
                    category = pos;
                    break;
                }
            }
            if (lemma.equals("*")) {
                hierarachicalNUPOSTag = this.getSiblingNUPOSTag(partOfSpeech);
                for (String pos : hierarachicalNUPOSTag) {
                    lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), pos);
                    if (lemma.equals("*")) {
                        lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), pos);
                    }
                    if (lemma.equals("*")) continue;
                    lemmata = lemma;
                    category = pos;
                    break;
                }
            }
        } else if (tagSetLabel.equals("NUPOS")) {
            lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), partOfSpeech);
            if (lemma.equals("*")) {
                lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), partOfSpeech);
            }
            if (!lemma.equals("*")) {
                lemmata = lemma;
                category = partOfSpeech;
            }
            if (lemma.equals("*")) {
                for (String pos : hierarachicalNUPOSTag = this.getSiblingNUPOSTag(this.getPennPOSFromNUPOS(partOfSpeech)[0])) {
                    lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), pos);
                    if (lemma.equals("*")) {
                        lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), pos);
                    }
                    if (lemma.equals("*")) continue;
                    lemmata = lemma;
                    category = pos;
                    break;
                }
            }
        }
        Map<Object, Object> lemmasAndCategories = new HashMap();
        if ((tagSetLabel.equals("NONE") || lemma.equals("*")) && (lemmasAndCategories = this.getLemmasAndCategories(spelling.toLowerCase())).isEmpty()) {
            lemmasAndCategories = this.getLemmasAndCategories(spelling.toUpperCase());
        }
        if (!lemmasAndCategories.isEmpty()) {
            lemmataAndLemmataTag = lemmasAndCategories;
        } else if (!lemma.equals("*")) {
            lemmata = lemma;
            lemmataTag = category;
            lemmataAndLemmataTag.put(lemmataTag, lemmata);
        } else {
            lemmataAndLemmataTag.put(lemmataTag, lemmata);
        }
        return new LemmataEntry(lemmataAndLemmataTag, this.posEntry);
    }

    public LemmataEntry lemmatizeByRules(String spelling, String partOfSpeech) {
        String pos;
        HashMap<String, String> lemmataAndLemmataTag = new HashMap<String, String>();
        String lemmata = spelling;
        if (partOfSpeech == null) {
            partOfSpeech = "";
        }
        String lemmataTag = partOfSpeech.trim().length() == 0 ? "NONE" : partOfSpeech;
        String[] nuPOSTag = this.getNUPOSTagFromPennPOS(partOfSpeech);
        String lemmaClass = "";
        String[] arr$ = nuPOSTag;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (lemmaClass = this.partOfSpeechTags.getLemmaWordClass(pos = arr$[i$])).length() == 0; ++i$) {
        }
        if (!this.lemmatizer.cantLemmatize(spelling) && !lemmaClass.equals("none") && (lemmata = this.lemmatizer.lemmatize(spelling, "compound")).equalsIgnoreCase(spelling)) {
            List<String> wordList = this.spellingTokenizer.extractWords(spelling);
            if (!this.partOfSpeechTags.isCompoundTag(partOfSpeech) || wordList.size() == 1) {
                lemmata = lemmaClass.length() == 0 ? this.lemmatizer.lemmatize(spelling) : this.lemmatizer.lemmatize(spelling, lemmaClass);
            } else {
                lemmata = "";
                String[] posTags = this.partOfSpeechTags.splitTag(partOfSpeech);
                if (posTags.length == wordList.size()) {
                    for (int i = 0; i < wordList.size(); ++i) {
                        String wordPiece = wordList.get(i);
                        if (i > 0) {
                            lemmata = lemmata + lemmaSeparator;
                        }
                        LemmataEntry lemmaPiece = this.lemmatizeByRules(wordPiece, posTags[i]);
                        lemmata = lemmata + lemmaPiece.lemmasToString();
                    }
                }
            }
        }
        lemmataAndLemmataTag.put(lemmataTag, lemmata);
        return new LemmataEntry(lemmataAndLemmataTag, this.posEntry);
    }

    public LemmataEntry lemmatizeByLexiconAndRules(String spelling, String partOfSpeech) {
        String[] hierarachicalNUPOSTag;
        HashMap<String, String> lemmataAndLemmataTag = new HashMap<String, String>();
        String lemmata = spelling;
        if (partOfSpeech == null) {
            partOfSpeech = "";
        }
        String lemmataTag = partOfSpeech.trim().length() == 0 ? "NONE" : partOfSpeech;
        String tagSetLabel = this.posEntry.getTagSetLabel(partOfSpeech);
        String[] nuPOSTag = this.getNUPOSTagFromPennPOS(partOfSpeech);
        String lemma = "*";
        String category = "*";
        if (tagSetLabel.equals("PennPOS")) {
            lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), partOfSpeech);
            if (lemma.equals("*")) {
                lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), partOfSpeech);
            }
            if (!lemma.equals("*")) {
                category = partOfSpeech;
            }
            if (lemma.equals("*")) {
                String[] hierarachicalPennPOSTag;
                for (String pos : hierarachicalPennPOSTag = this.getSiblingPennPOSTag(partOfSpeech)) {
                    lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), pos);
                    if (lemma.equals("*")) {
                        lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), pos);
                    }
                    if (lemma.equals("*")) continue;
                    category = pos;
                    break;
                }
            }
            if (lemma.equals("*")) {
                for (String pos : nuPOSTag) {
                    lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), pos);
                    if (lemma.equals("*")) {
                        lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), pos);
                    }
                    if (lemma.equals("*")) continue;
                    category = pos;
                    break;
                }
            }
            if (lemma.equals("*")) {
                hierarachicalNUPOSTag = this.getSiblingNUPOSTag(partOfSpeech);
                for (String pos : hierarachicalNUPOSTag) {
                    lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), pos);
                    if (lemma.equals("*")) {
                        lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), pos);
                    }
                    if (lemma.equals("*")) continue;
                    category = pos;
                    break;
                }
            }
        } else if (tagSetLabel.equals("NUPOS")) {
            lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), partOfSpeech);
            if (lemma.equals("*")) {
                lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), partOfSpeech);
            }
            if (!lemma.equals("*")) {
                category = partOfSpeech;
            }
            if (lemma.equals("*")) {
                hierarachicalNUPOSTag = this.getSiblingNUPOSTag(this.getPennPOSFromNUPOS(partOfSpeech)[0]);
                for (String pos : hierarachicalNUPOSTag) {
                    lemma = this.wordLexicon.getLemma(spelling.toLowerCase(), pos);
                    if (lemma.equals("*")) {
                        lemma = this.wordLexicon.getLemma(spelling.toUpperCase(), pos);
                    }
                    if (lemma.equals("*")) continue;
                    category = pos;
                    break;
                }
            }
        }
        Map<Object, Object> lemmasAndCategories = new HashMap();
        if (tagSetLabel.equals("NONE") && (lemmasAndCategories = this.getLemmasAndCategories(spelling.toLowerCase())).isEmpty()) {
            lemmasAndCategories = this.getLemmasAndCategories(spelling.toUpperCase());
        }
        if (!lemmasAndCategories.isEmpty()) {
            lemmataAndLemmataTag = lemmasAndCategories;
        } else if (!lemma.equals("*")) {
            lemmata = lemma;
            lemmataTag = category;
            lemmataAndLemmataTag.put(lemmataTag, lemmata);
        } else {
            String pos;
            String lemmaClass = "";
            String[] arr$ = nuPOSTag;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (lemmaClass = this.partOfSpeechTags.getLemmaWordClass(pos = arr$[i$])).length() == 0; ++i$) {
            }
            if (!this.lemmatizer.cantLemmatize(spelling) && !lemmaClass.equals("none") && (lemmata = this.lemmatizer.lemmatize(spelling, "compound")).equalsIgnoreCase(spelling)) {
                List<String> wordList = this.spellingTokenizer.extractWords(spelling);
                if (!this.partOfSpeechTags.isCompoundTag(partOfSpeech) || wordList.size() == 1) {
                    lemmata = lemmaClass.length() == 0 ? this.lemmatizer.lemmatize(spelling) : this.lemmatizer.lemmatize(spelling, lemmaClass);
                } else {
                    lemmata = "";
                    String[] posTags = this.partOfSpeechTags.splitTag(partOfSpeech);
                    if (posTags.length == wordList.size()) {
                        for (int i = 0; i < wordList.size(); ++i) {
                            String wordPiece = wordList.get(i);
                            if (i > 0) {
                                lemmata = lemmata + lemmaSeparator;
                            }
                            LemmataEntry lemmaPiece = this.lemmatizeByLexiconAndRules(wordPiece, posTags[i]);
                            lemmata = lemmata + lemmaPiece.lemmasToString();
                        }
                    }
                }
            }
            lemmataAndLemmataTag.put(lemmataTag, lemmata);
        }
        return new LemmataEntry(lemmataAndLemmataTag, this.posEntry);
    }

    public static void main(String[] args) {
        BioLemmatizerCmdOpts options = new BioLemmatizerCmdOpts();
        CmdLineParser parser2 = new CmdLineParser(options);
        try {
            parser2.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            parser2.printUsage(System.err);
            return;
        }
        File lexiconFile = options.getLexiconFile();
        BioLemmatizer bioLemmatizer = new BioLemmatizer(lexiconFile);
        boolean americanize = options.americanizedLemma();
        boolean outputLemmaOnly = options.outputLemmaOnly();
        boolean useInteractiveMode = options.useInteractiveMode();
        String inputStr = options.getInputStr();
        if (inputStr != null) {
            inputStr = inputStr.trim();
        }
        String inputStrPos = options.getInputStrPos();
        File inputFile = options.getInputFile();
        File outputFile = options.getOutputFile();
        System.out.println("=========================================================");
        System.out.println("=========================================================");
        System.out.println("=========================================================");
        System.out.println("Running BioLemmatizer....");
        try {
            if (useInteractiveMode) {
                BioLemmatizer.runInteractiveMode(bioLemmatizer, outputLemmaOnly, americanize);
            } else if (inputStr != null) {
                LemmataEntry lemmata = americanize ? bioLemmatizer.lemmatizeByLexiconAndRules(new Americanize().americanize(BioLemmatizer.unicodeHandler(inputStr)), inputStrPos) : bioLemmatizer.lemmatizeByLexiconAndRules(BioLemmatizer.unicodeHandler(inputStr), inputStrPos);
                if (outputLemmaOnly) {
                    System.out.println("The lemma for '" + inputStr + "' is: " + lemmata.lemmasToString());
                } else {
                    System.out.println("The lemma for '" + inputStr + "' is: " + lemmata);
                }
            } else if (inputFile != null) {
                if (outputFile == null) {
                    System.err.println("Output file must be set if the input file parameter is used.");
                    parser2.printUsage(System.err);
                }
                BioLemmatizer.processInputFile(inputFile, outputFile, bioLemmatizer, outputLemmaOnly, americanize);
            } else {
                System.err.println("Invalid input parameters...");
                parser2.printUsage(System.err);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        System.out.println("=========================================================");
        System.out.println("=========================================================");
        System.out.println("=========================================================");
    }

    private static void processInputFile(File inputFile, File outputFile, BioLemmatizer bioLemmatizer, boolean outputLemmaOnly, boolean americanize) throws IOException {
        BufferedWriter output;
        BufferedReader input;
        Americanize convert = null;
        if (americanize) {
            convert = new Americanize();
        }
        try {
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inputFile), Charset.forName("UTF-8").newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to open the input file: " + inputFile.getAbsolutePath(), e);
        }
        try {
            output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile, false), Charset.forName("UTF-8").newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT)));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Unable to open the output file: " + outputFile.getAbsolutePath(), e);
        }
        String line = null;
        while ((line = input.readLine()) != null) {
            if (line.trim().length() == 0) {
                output.write("\n");
                continue;
            }
            String[] pair = (line = line.trim()).split("\t");
            String pos = pair.length == 1 ? "" : pair[1];
            LemmataEntry lemmata = americanize ? bioLemmatizer.lemmatizeByLexiconAndRules(convert.americanize(BioLemmatizer.unicodeHandler(pair[0])), pos) : bioLemmatizer.lemmatizeByLexiconAndRules(BioLemmatizer.unicodeHandler(pair[0]), pos);
            String result = outputLemmaOnly ? line + "\t" + lemmata.lemmasToString() + "\n" : line + "\t" + lemmata + "\n";
            output.write(result);
        }
        input.close();
        output.close();
    }

    private static void runInteractiveMode(BioLemmatizer bioLemmatizer, boolean outputLemmaOnly, boolean americanize) throws IOException {
        String input;
        Americanize convert = null;
        if (americanize) {
            convert = new Americanize();
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Running BioLemmatizer in interactive mode. Please type a word to be lemmatized with an optional part-of-speech, e.g. \"run\" or \"run NN\"");
        while ((input = in.readLine()) != null && input.length() != 0) {
            String[] arguments = input.split("\\s");
            if (arguments.length > 2) {
                System.out.println("Only one word to be lemmatized (with or without POS) is allowed");
                System.exit(0);
            }
            String spelling = arguments[0].trim();
            String partOfSpeech = arguments.length == 2 ? arguments[1].trim() : null;
            LemmataEntry lemmata = americanize ? bioLemmatizer.lemmatizeByLexiconAndRules(convert.americanize(BioLemmatizer.unicodeHandler(spelling)), partOfSpeech) : bioLemmatizer.lemmatizeByLexiconAndRules(BioLemmatizer.unicodeHandler(spelling), partOfSpeech);
            if (outputLemmaOnly) {
                System.out.println(lemmata.lemmasToString());
                continue;
            }
            System.out.println(lemmata);
        }
    }
}

